/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Client;
import com.sun.cluster.sccheck.ClientProtocol;
import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.SCProperties;
import com.sun.cluster.sccheck.Session;
import com.sun.cluster.sccheck.SessionFactory;

public class ClientThread
extends Thread
implements Globals {
    private ProgressListener progresslistener;
    private Client parent;
    private String publicName;
    private String privateName;
    private String resultsFilename;
    private String reportFilename;
    private boolean brief = false;
    private int minSeverity = 0;
    private String checkListFilePath = null;
    private String exploArchivePath = null;
    private Logger logger = Logger.getLogger();
    private SCProperties props = SCProperties.getSCProperties();

    public ClientThread(ProgressListener progressListener, Client client, String string, String string2, String string3, String string4, boolean bl, int n, String string5, String string6) {
        this.logger.info("ClientThread() -- ENTER -- " + string);
        this.logger.info("ClientThread() resultsFilename: " + string3);
        this.logger.info("ClientThread() reportFilename: " + string4);
        this.logger.info("ClientThread() brief: " + bl);
        this.logger.info("ClientThread() minSeverity: " + n);
        this.logger.info("ClientThread() check rule file: " + string5);
        this.logger.info("ClientThread() explorer archive: " + string6);
        this.progresslistener = progressListener;
        this.parent = client;
        this.publicName = string;
        this.privateName = string2;
        this.resultsFilename = string3;
        this.reportFilename = string4;
        this.checkListFilePath = string5;
        this.exploArchivePath = string6;
        this.brief = bl;
        this.minSeverity = n;
        this.logger.trace("ClientThread() -- EXIT -- " + string);
    }

    public void run() {
        try {
            this.remoteOperations();
        }
        catch (SCException sCException) {
            this.logger.error("ClientThread.run() SCException on: " + this.publicName + ": " + sCException.getMessage());
            Object[] objectArray = new Object[]{this.publicName, sCException.getMessage()};
            String string = I18n.getLocalized("clientThreadRunError", objectArray);
            this.progresslistener.postErrMsg(string);
            this.parent.postFailure(this.publicName);
        }
    }

    private void remoteOperations() throws SCException {
        String string = null;
        ClientProtocol clientProtocol = null;
        Session session = null;
        try {
            clientProtocol = new ClientProtocol(this.progresslistener, this.parent, this.publicName, this.privateName, this.parent.getClientHostname());
            int n = clientProtocol.getCommonVersion(2);
            session = SessionFactory.getSession(n);
            this.logger.trace("ClientThread.remoteOperations() initializing SessionV" + n);
            switch (n) {
                case 1: {
                    if (this.exploArchivePath != null) {
                        this.logger.error("- ClientThread.remoteOperations() -\nERROR:   the server does not support  SessionV2 or greater which is required for custom\n-----------------------------------");
                        Object[] objectArray = new Object[]{"" + n};
                        String string2 = I18n.getLocalized("unsupportedSessionVersion", objectArray);
                        throw new SCException(string2);
                    }
                    session.initClient(this.parent, clientProtocol, this.publicName, this.privateName, this.resultsFilename, this.reportFilename, this.brief, this.minSeverity);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Object[]{this.checkListFilePath, this.exploArchivePath};
                    session.initClient(this.parent, clientProtocol, this.publicName, this.privateName, this.resultsFilename, this.reportFilename, this.brief, this.minSeverity, objectArray);
                    break;
                }
                default: {
                    this.logger.error("ClientThread.remoteOperations(): init: unknown version: " + n);
                    Object[] objectArray = new Object[]{"" + n};
                    String string3 = I18n.getLocalized("unsupportedSessionVersion", objectArray);
                    throw new SCException(string3);
                }
            }
            this.logger.info("ClientThread.remoteOperations() running SessionV" + n);
            switch (n) {
                case 1: 
                case 2: {
                    session.runClient(this.progresslistener);
                    break;
                }
                default: {
                    this.logger.error("ClientThread.remoteOperations(): run: unknown version: " + n);
                    Object[] objectArray = new Object[]{"" + n};
                    String string4 = I18n.getLocalized("unsupportedSessionVersion", objectArray);
                    throw new SCException(string4);
                }
            }
        }
        catch (ProtocolException protocolException) {
            String string5 = string = protocolException.getMessage();
            if (string == null) {
                string = "Unexpected early return from server.";
                string5 = I18n.getLocalized("unexpectedEarlyReturnFromServer");
            }
            this.logger.error("ClientThread.remoteOperations() in ProtocolException: " + string);
            throw new SCException(string5);
        }
    }

    public void die() {
        this.logger.trace("ClientThread.die(): killing thread for: " + this.publicName);
        this.destroy();
    }
}

