/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.UserAttrUtil;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserRightsUtil;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisPasswdTable;
import com.sun.wbem.solarisprovider.usermgr.users.SolarisUserAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.UMgrNative;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import java.util.Enumeration;
import java.util.Vector;

public class UserAttrUpdate {
    private static final String ROLE_TYPE = "role";
    private static final String USER_TYPE = "normal";
    private static final String USER_LIST = "members";
    private static final String ROLE_LIST = "roles";
    private static final int CK_BAD = -1;
    private static final int CK_USER = 0;
    private static final int CK_ROLE = 1;
    private ProviderUtility provUtil;
    private UserAttrUtil validUtil;
    private String scope;

    public UserAttrUpdate(ProviderUtility providerUtility, String string) {
        this.provUtil = providerUtility;
        this.scope = string;
        this.validUtil = new UserAttrUtil(this.scope);
    }

    Vector checkList(SolarisUserAttrTable solarisUserAttrTable, Vector vector, boolean bl, boolean bl2) {
        SolarisPasswdTable solarisPasswdTable = null;
        Vector<String> vector2 = new Vector<String>();
        if (vector == null) {
            return vector2;
        }
        int n = bl ? 0 : 1;
        if (!bl2 || bl) {
            solarisPasswdTable = new SolarisPasswdTable(this.scope);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = bl2 && !bl ? UMgrNative.checkUserName(string) : this.checkUserInScope(string, solarisPasswdTable, solarisUserAttrTable);
            if (n2 == n) continue;
            vector2.addElement(string);
        }
        return vector2;
    }

    private int checkUserInScope(String string, SolarisPasswdTable solarisPasswdTable, SolarisUserAttrTable solarisUserAttrTable) {
        FlatUserObj flatUserObj = new FlatUserObj();
        flatUserObj.setUserName(string);
        int n = -1;
        try {
            flatUserObj = solarisPasswdTable.getPasswdRow(flatUserObj);
        }
        catch (Exception exception) {
            flatUserObj = null;
        }
        if (flatUserObj != null) {
            n = 0;
            UserAttrObj userAttrObj = null;
            try {
                userAttrObj = solarisUserAttrTable.readUserAttr(string);
            }
            catch (Exception exception) {}
            if (userAttrObj != null && userAttrObj.getUserType().equals(ROLE_TYPE)) {
                n = 1;
            }
        }
        return n;
    }

    private void createEmptyRoleEntry(String string) throws UserException {
        try {
            SolarisUserAttrTable solarisUserAttrTable = new SolarisUserAttrTable(this.scope);
            UserAttrObj userAttrObj = new UserAttrObj(string, ROLE_TYPE);
            solarisUserAttrTable.writeUserAttr(userAttrObj);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (Exception exception) {
            throw new UserException("EXM_UAU_AD1", (Object)this.scope, (Object)string, exception.getLocalizedMessage());
        }
    }

    private String getBadUserList(Vector vector) {
        String string = "";
        String string2 = null;
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (bl) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + string2;
            bl = true;
        }
        return string;
    }

    private Vector getVectorDiff(Vector vector, Vector vector2) {
        if (vector == null) {
            return new Vector(0);
        }
        Vector vector3 = (Vector)vector.clone();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                vector3.removeElement(vector2.elementAt(n));
                ++n;
            }
        }
        return vector3;
    }

    public void userAttrAdd(String string, String string2, UserAttrObj userAttrObj, CIMObjectPath cIMObjectPath) throws UserException {
        boolean bl = string2.equals(ROLE_TYPE);
        if (userAttrObj == null) {
            if (bl) {
                this.createEmptyRoleEntry(string);
            }
            return;
        }
        this.validUtil.validateUserAttrKeys(userAttrObj);
        this.validUtil.validateAuthNames(null, userAttrObj);
        this.validUtil.validateProfNames(null, userAttrObj);
        UserRightsUtil userRightsUtil = new UserRightsUtil(this.provUtil);
        try {
            userRightsUtil.checkAuthAssignRights(null, userAttrObj);
            userRightsUtil.checkProfAssignRights(null, userAttrObj, cIMObjectPath);
            userRightsUtil.checkRoleAssignRights(string, string2, null, userAttrObj, cIMObjectPath);
        }
        catch (UserException userException) {
            if (bl) {
                try {
                    this.createEmptyRoleEntry(string);
                }
                catch (Exception exception) {}
            }
            throw userException;
        }
        SolarisUserAttrTable solarisUserAttrTable = new SolarisUserAttrTable(this.scope);
        String string3 = this.provUtil.getScopeType(this.scope);
        boolean bl2 = false;
        if (string3.equalsIgnoreCase("file")) {
            bl2 = true;
        }
        Vector vector = null;
        Vector vector2 = null;
        if (bl) {
            vector = userAttrObj.getAttribute(USER_LIST);
            userAttrObj.clearAttribute(USER_LIST);
            vector2 = this.checkList(solarisUserAttrTable, vector, bl, bl2);
            if (vector2.size() > 0) {
                vector = this.getVectorDiff(vector, vector2);
            }
        } else {
            vector = userAttrObj.getAttribute(ROLE_LIST);
            vector2 = this.checkList(solarisUserAttrTable, vector, bl, bl2);
            if (vector2.size() > 0 && bl2) {
                vector = this.getVectorDiff(vector, vector2);
                userAttrObj.setAttribute(ROLE_LIST, vector);
            }
        }
        try {
            solarisUserAttrTable.writeUserAttr(userAttrObj);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (Exception exception) {
            throw new UserException("EXM_UAU_AD1", (Object)this.scope, (Object)string, exception.getLocalizedMessage());
        }
        if (bl && vector != null && vector.size() > 0) {
            try {
                solarisUserAttrTable.addRoleToUsers(string, vector);
            }
            catch (Exception exception) {
                throw new UserException("EXM_UAU_AD2", (Object)string, (Object)this.scope, exception.getLocalizedMessage());
            }
        }
        if (vector2.size() > 0) {
            String string4 = this.getBadUserList(vector2);
            if (bl) {
                throw new UserException("EXM_UAU_CK1", (Object)string, (Object)this.scope, string4);
            }
            if (bl2) {
                throw new UserException("EXM_UAU_CK3", (Object)string, (Object)this.scope, string4);
            }
            throw new UserException("EXM_UAU_CK4", (Object)string, (Object)this.scope, string4);
        }
    }

    public void userAttrDelete(String string, UserAttrObj userAttrObj) throws UserException {
        Throwable throwable = null;
        UserAttrObj userAttrObj2 = userAttrObj;
        if (userAttrObj2 == null) {
            userAttrObj2 = this.userAttrRead(string);
        }
        if (userAttrObj2 != null) {
            Vector vector;
            SolarisUserAttrTable solarisUserAttrTable = new SolarisUserAttrTable(this.scope);
            String string2 = userAttrObj2.getUserType();
            boolean bl = false;
            if (string2.equals(ROLE_TYPE) && (vector = userAttrObj2.getAttribute(USER_LIST)) != null && vector.size() > 0) {
                try {
                    solarisUserAttrTable.removeRoleFromUsers(string, vector);
                }
                catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                    throw new UserException("EXM_UAU_DB1", this.scope);
                }
                catch (Exception exception) {
                    bl = true;
                    throwable = exception;
                }
            }
            try {
                solarisUserAttrTable.removeUserAttr(string);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (Exception exception) {
                throw new UserException("EXM_UAU_DL1", (Object)this.scope, (Object)string, exception.getLocalizedMessage());
            }
            if (bl) {
                throw new UserException("EXM_UAU_DL2", (Object)string, (Object)this.scope, throwable.getLocalizedMessage());
            }
        }
    }

    public void userAttrModify(String string, UserAttrObj userAttrObj, CIMObjectPath cIMObjectPath) throws UserException {
        Object object;
        UserAttrObj userAttrObj2;
        if (userAttrObj == null) {
            return;
        }
        String string2 = string;
        String string3 = userAttrObj.getUserType();
        String string4 = userAttrObj.getUserName();
        boolean bl = false;
        if (!string2.equals(string4)) {
            bl = true;
        }
        if ((userAttrObj2 = this.userAttrRead(string2)) == null) {
            this.userAttrAdd(string4, string3, userAttrObj, cIMObjectPath);
            return;
        }
        if (userAttrObj2.equals(userAttrObj) && !bl) {
            return;
        }
        this.validUtil.validateUserAttrKeys(userAttrObj);
        this.validUtil.validateAuthNames(userAttrObj2, userAttrObj);
        this.validUtil.validateProfNames(userAttrObj2, userAttrObj);
        UserRightsUtil userRightsUtil = new UserRightsUtil(this.provUtil);
        userRightsUtil.checkAuthAssignRights(userAttrObj2, userAttrObj);
        userRightsUtil.checkProfAssignRights(userAttrObj2, userAttrObj, cIMObjectPath);
        userRightsUtil.checkRoleAssignRights(string2, string3, userAttrObj2, userAttrObj, cIMObjectPath);
        boolean bl2 = string3.equals(ROLE_TYPE);
        SolarisUserAttrTable solarisUserAttrTable = new SolarisUserAttrTable(this.scope);
        String string5 = this.provUtil.getScopeType(this.scope);
        boolean bl3 = false;
        if (string5.equalsIgnoreCase("file")) {
            bl3 = true;
        }
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        if (bl2) {
            vector = userAttrObj2.getAttribute(USER_LIST);
            vector2 = userAttrObj.getAttribute(USER_LIST);
            userAttrObj.clearAttribute(USER_LIST);
            vector3 = this.checkList(solarisUserAttrTable, vector2, bl2, bl3);
            if (vector3.size() > 0) {
                vector2 = this.getVectorDiff(vector2, vector3);
            }
        } else {
            vector2 = userAttrObj.getAttribute(ROLE_LIST);
            vector3 = this.checkList(solarisUserAttrTable, vector2, bl2, bl3);
            if (vector3.size() > 0 && bl3) {
                vector2 = this.getVectorDiff(vector2, vector3);
                userAttrObj.setAttribute(ROLE_LIST, vector2);
            }
        }
        try {
            if (!bl2 && solarisUserAttrTable.isEmpty(userAttrObj)) {
                solarisUserAttrTable.removeUserAttr(userAttrObj);
            } else {
                solarisUserAttrTable.writeUserAttr(userAttrObj);
            }
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (Exception exception) {
            throw new UserException("EXM_UAU_MD1", (Object)this.scope, (Object)string2, exception.getLocalizedMessage());
        }
        if (bl) {
            try {
                solarisUserAttrTable.removeUserAttr(userAttrObj2);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            }
            catch (Exception exception) {
                throw new UserException("EXM_UAU_DL1", (Object)this.scope, (Object)string2, exception.getLocalizedMessage());
            }
        }
        if (bl2) {
            object = null;
            Vector vector4 = null;
            if (bl) {
                object = vector;
                vector4 = vector2;
            } else {
                object = this.getVectorDiff(vector, vector2);
                vector4 = this.getVectorDiff(vector2, vector);
            }
            try {
                if (object != null && ((Vector)object).size() > 0) {
                    solarisUserAttrTable.removeRoleFromUsers(string2, (Vector)object);
                }
                if (vector4 != null && vector4.size() > 0) {
                    solarisUserAttrTable.addRoleToUsers(string4, vector4);
                }
            }
            catch (Exception exception) {
                throw new UserException("EXM_UAU_MD2", (Object)string2, (Object)this.scope, exception.getLocalizedMessage());
            }
        }
        if (vector3.size() > 0) {
            object = this.getBadUserList(vector3);
            if (bl2) {
                throw new UserException("EXM_UAU_CK1", (Object)string2, (Object)this.scope, object);
            }
            if (bl3) {
                throw new UserException("EXM_UAU_CK3", (Object)string2, (Object)this.scope, object);
            }
            throw new UserException("EXM_UAU_CK4", (Object)string2, (Object)this.scope, object);
        }
    }

    public UserAttrObj userAttrRead(String string) throws UserException {
        String string2;
        UserAttrObj userAttrObj = null;
        SolarisUserAttrTable solarisUserAttrTable = new SolarisUserAttrTable(this.scope);
        try {
            userAttrObj = solarisUserAttrTable.readUserAttr(string);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new UserException("EXM_UAU_DB1", this.scope);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            throw new UserException("EXM_UAU_RD1", (Object)this.scope, string);
        }
        catch (Exception exception) {
            throw new UserException("EXM_UAU_RD2", (Object)this.scope, (Object)string, exception.getLocalizedMessage());
        }
        if (userAttrObj != null && (string2 = userAttrObj.getUserType()).equals(ROLE_TYPE)) {
            Vector vector = null;
            try {
                vector = solarisUserAttrTable.getUsersInRole(string);
            }
            catch (Exception exception) {
                throw new UserException("EXM_UAU_RD3", (Object)string, this.scope);
            }
            if (vector != null && vector.size() > 0) {
                userAttrObj.setAttribute(USER_LIST, vector);
            }
        }
        return userAttrObj;
    }
}

