/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.audit.AuditEvent;
import com.sun.audit.AuditEvent_serialport_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.client.audit.WbemAuditSession;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.SerialPortInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_SerialPortConfiguration
implements InstanceProvider,
Authorizable {
    public static final String SERIAL_MODIFY_RIGHT = "solaris.admin.serialmgr.modify";
    public static final String SERIAL_DELETE_RIGHT = "solaris.admin.serialmgr.delete";
    public static final String SERIAL_READ_RIGHT = "solaris.admin.serialmgr.read";
    SerialPortInfo dat = null;
    int num_ports;
    private CIMOMHandle cimomhandle = null;
    private LogUtil util = null;
    private ProviderUtility provUtil = null;

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        this.dat = this.initData();
        int n = 0;
        while (n < this.num_ports) {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            try {
                cIMObjectPath2.addKey("PortName", new CIMValue((Object)this.dat.getPortName(n)));
                cIMObjectPath2.addKey("ServiceTag", new CIMValue((Object)this.dat.getServiceTag(this.dat.getPortName(n))));
            }
            catch (Exception exception) {
                String string = this.provUtil.writeLog(2, exception);
                throw new CIMException("CIM_ERR_FAILED", (Object)string);
            }
            vector.addElement(cIMObjectPath2);
            ++n;
        }
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        String string = "";
        String string2 = "";
        CIMInstance cIMInstance = null;
        this.dat = this.initData();
        SerialPortData serialPortData = null;
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        int n = 0;
        while (n < this.num_ports) {
            cIMInstance = cIMClass.newInstance();
            try {
                serialPortData = this.dat.getPortData(this.dat.getPortName(n));
                cIMInstance.setProperty("PortName", new CIMValue((Object)this.dat.getPortName(n)));
            }
            catch (SerialPortException serialPortException) {
                String string3 = serialPortException.getLocalizedMessage();
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
            }
            catch (Exception exception) {
                String string4 = this.provUtil.writeLog(2, exception);
                throw new CIMException("CIM_ERR_FAILED", (Object)string4);
            }
            cIMInstance.setProperty("ServiceTag", new CIMValue((Object)serialPortData.getServiceTag()));
            cIMInstance.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(serialPortData.isEnableSet())));
            cIMInstance.setProperty("PortDeleted", new CIMValue((Object)new Boolean(serialPortData.isDeleted())));
            cIMInstance.setProperty("PortmonTag", new CIMValue((Object)serialPortData.getPortMonTag()));
            cIMInstance.setProperty("Comment", new CIMValue((Object)serialPortData.getComment()));
            cIMInstance.setProperty("BaudRate", new CIMValue((Object)serialPortData.getTTYLabel()));
            cIMInstance.setProperty("TerminalType", new CIMValue((Object)serialPortData.getTerminalType()));
            cIMInstance.setProperty("TTYFlag_Init", new CIMValue((Object)new Boolean(serialPortData.isInitializeSet())));
            cIMInstance.setProperty("TTYFlag_Bidirectional", new CIMValue((Object)new Boolean(serialPortData.isBidirectionalSet())));
            cIMInstance.setProperty("TTYFlag_CarrierConnect", new CIMValue((Object)new Boolean(serialPortData.isConnectOnCarrierSet())));
            cIMInstance.setProperty("SoftwareCarrier", new CIMValue((Object)new Boolean(serialPortData.isSoftwareCarrier())));
            cIMInstance.setProperty("CreateUtmp", new CIMValue((Object)new Boolean(serialPortData.isUTMPSet())));
            cIMInstance.setProperty("LoginPrompt", new CIMValue((Object)serialPortData.getPrompt()));
            cIMInstance.setProperty("ServiceProgram", new CIMValue((Object)serialPortData.getServiceCmdLine()));
            cIMInstance.setProperty("StreamsModules", new CIMValue((Object)serialPortData.getModules()));
            cIMInstance.setProperty("Timeout", new CIMValue((Object)serialPortData.getTimeoutVal()));
            cIMInstance.setProperty("deviceName", new CIMValue((Object)serialPortData.getDeviceName()));
            vector.addElement(cIMInstance);
            ++n;
        }
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
        return vector;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        Object object;
        this.provUtil.checkRights(SERIAL_READ_RIGHT, cIMObjectPath);
        String string = "";
        String string2 = "";
        this.dat = this.initData();
        Enumeration enumeration = cIMObjectPath.getKeys().elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (object.getName().equalsIgnoreCase("PortName")) {
                string = (String)object.getValue().getValue();
            }
            if (!object.getName().equalsIgnoreCase("ServiceTag")) continue;
            string2 = (String)object.getValue().getValue();
        }
        object = null;
        try {
            object = this.dat.getPortData(string);
        }
        catch (SerialPortException serialPortException) {
            String string3 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string3);
        }
        catch (Exception exception) {
            String string4 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string4);
        }
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty("PortName", new CIMValue((Object)string));
        cIMInstance.setProperty("ServiceTag", new CIMValue((Object)string2));
        cIMInstance.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(((SerialPortData)object).isEnableSet())));
        cIMInstance.setProperty("PortDeleted", new CIMValue((Object)new Boolean(((SerialPortData)object).isDeleted())));
        cIMInstance.setProperty("PortmonTag", new CIMValue((Object)((SerialPortData)object).getPortMonTag()));
        cIMInstance.setProperty("Comment", new CIMValue((Object)((SerialPortData)object).getComment()));
        cIMInstance.setProperty("BaudRate", new CIMValue((Object)((SerialPortData)object).getTTYLabel()));
        cIMInstance.setProperty("TerminalType", new CIMValue((Object)((SerialPortData)object).getTerminalType()));
        cIMInstance.setProperty("TTYFlag_Init", new CIMValue((Object)new Boolean(((SerialPortData)object).isInitializeSet())));
        cIMInstance.setProperty("TTYFlag_Bidirectional", new CIMValue((Object)new Boolean(((SerialPortData)object).isBidirectionalSet())));
        cIMInstance.setProperty("TTYFlag_CarrierConnect", new CIMValue((Object)new Boolean(((SerialPortData)object).isConnectOnCarrierSet())));
        cIMInstance.setProperty("SoftwareCarrier", new CIMValue((Object)new Boolean(((SerialPortData)object).isSoftwareCarrier())));
        cIMInstance.setProperty("CreateUtmp", new CIMValue((Object)new Boolean(((SerialPortData)object).isUTMPSet())));
        cIMInstance.setProperty("LoginPrompt", new CIMValue((Object)((SerialPortData)object).getPrompt()));
        cIMInstance.setProperty("ServiceProgram", new CIMValue((Object)((SerialPortData)object).getServiceCmdLine()));
        cIMInstance.setProperty("StreamsModules", new CIMValue((Object)((SerialPortData)object).getModules()));
        cIMInstance.setProperty("Timeout", new CIMValue((Object)((SerialPortData)object).getTimeoutVal()));
        cIMInstance.setProperty("deviceName", new CIMValue((Object)((SerialPortData)object).getDeviceName()));
        return cIMInstance;
    }

    private SerialPortInfo initData() throws CIMException {
        try {
            SerialPortInfo serialPortInfo = new SerialPortInfo(this.util);
            this.num_ports = serialPortInfo.initData();
            return serialPortInfo;
        }
        catch (SerialPortException serialPortException) {
            String string = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        catch (Exception exception) {
            String string = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string);
        }
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.util = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        String string = this.util.getMessage("LM_SERIAL_APP_NAME");
        this.provUtil = new ProviderUtility(cIMOMHandle, string);
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.provUtil.checkRights(SERIAL_MODIFY_RIGHT, cIMObjectPath);
        String string = "";
        this.dat = this.initData();
        string = (String)cIMInstance.getProperty("PortName").getValue().getValue();
        SerialPortData serialPortData = null;
        try {
            serialPortData = this.dat.getPortData(string);
        }
        catch (SerialPortException serialPortException) {
            String string2 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        catch (Exception exception) {
            String string3 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string3);
        }
        SerialPortData serialPortData2 = new SerialPortData(string);
        serialPortData2.setDefaults(string);
        serialPortData2.setPortMonTag(serialPortData.getPortMonTag());
        serialPortData2.setOldPortMonTag(serialPortData.getPortMonTag());
        serialPortData2.setServiceTag(serialPortData.getServiceTag());
        serialPortData2.setOldServiceTag(serialPortData.getServiceTag());
        serialPortData2.setEnable((Boolean)cIMInstance.getProperty("ServiceEnabled").getValue().getValue());
        serialPortData2.setTTYLabel((String)cIMInstance.getProperty("BaudRate").getValue().getValue());
        serialPortData2.setTerminalType((String)cIMInstance.getProperty("TerminalType").getValue().getValue());
        serialPortData2.setServiceTag((String)cIMInstance.getProperty("ServiceTag").getValue().getValue());
        serialPortData2.setTTYFlags((Boolean)cIMInstance.getProperty("TTYFlag_Init").getValue().getValue(), (Boolean)cIMInstance.getProperty("TTYFlag_Bidirectional").getValue().getValue(), (Boolean)cIMInstance.getProperty("TTYFlag_CarrierConnect").getValue().getValue());
        serialPortData2.setSoftwareCarrier((Boolean)cIMInstance.getProperty("SoftwareCarrier").getValue().getValue());
        serialPortData2.setPortFlags((Boolean)cIMInstance.getProperty("CreateUtmp").getValue().getValue());
        serialPortData2.setPrompt((String)cIMInstance.getProperty("LoginPrompt").getValue().getValue());
        serialPortData2.setComment((String)cIMInstance.getProperty("Comment").getValue().getValue());
        serialPortData2.setPortMonTag((String)cIMInstance.getProperty("PortmonTag").getValue().getValue());
        serialPortData2.setServiceCmdLine((String)cIMInstance.getProperty("ServiceProgram").getValue().getValue());
        serialPortData2.setModules((String)cIMInstance.getProperty("StreamsModules").getValue().getValue());
        serialPortData2.setTimeoutVal((String)cIMInstance.getProperty("Timeout").getValue().getValue());
        serialPortData2.setDeviceName((String)cIMInstance.getProperty("deviceName").getValue().getValue());
        boolean bl = serialPortData2.isEqualTo(serialPortData) ^ true;
        try {
            this.dat.synchronizedSetPortInfo(string, serialPortData2, bl);
        }
        catch (SerialPortException serialPortException) {
            String string4 = serialPortException.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
        }
        catch (Exception exception) {
            String string5 = this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)string5);
        }
        WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
        AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
        if (auditSession == null) {
            return;
        }
        String string6 = null;
        string6 = this.provUtil.formatAuditToken(cIMInstance);
        String string7 = this.provUtil.getMgmtScope(cIMObjectPath);
        AuditEvent_serialport_modify auditEvent_serialport_modify = new AuditEvent_serialport_modify(auditSession);
        auditEvent_serialport_modify.object_name(cIMObjectPath.getObjectName());
        this.provUtil.setDomainScopeTokens(this.provUtil, string7, (AuditEvent)auditEvent_serialport_modify);
        auditEvent_serialport_modify.auth_used(SERIAL_MODIFY_RIGHT);
        auditEvent_serialport_modify.changed_values(string6);
        auditEvent_serialport_modify.putEvent(0, 0);
    }
}

