/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    static Hashtable nullHashtable = new Hashtable();

    public static StringBuffer getRequestURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        String string2 = httpServletRequest.getRequestURI();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private static String parseName(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                        n += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(n);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) break;
                        ++n;
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Hashtable parsePostData(int n, ServletInputStream servletInputStream) {
        byte[] byArray = null;
        if (n <= 0) {
            return new Hashtable();
        }
        if (servletInputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            int n2;
            byArray = new byte[n];
            int n3 = 0;
            do {
                if ((n2 = servletInputStream.read(byArray, n3, n - n3)) > 0) continue;
                String string = lStrings.getString("err.io.short_read");
                throw new IOException(string);
            } while (n - (n3 += n2) > 0);
        }
        catch (IOException iOException) {
            return nullHashtable;
        }
        String string = new String(byArray, 0, n);
        return HttpUtils.parseQueryString(string);
    }

    public static Hashtable parseQueryString(String string) {
        String[] stringArray = null;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            String string3 = HttpUtils.parseName(string2.substring(0, n), stringBuffer);
            String string4 = HttpUtils.parseName(string2.substring(n + 1, string2.length()), stringBuffer);
            if (hashtable.containsKey(string3)) {
                String[] stringArray2 = (String[])hashtable.get(string3);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string4;
            } else {
                stringArray = new String[]{string4};
            }
            hashtable.put(string3, stringArray);
        }
        return hashtable;
    }
}

