/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.core.Request;
import com.sun.web.server.ServletInputStreamImpl;
import com.sun.web.util.MimeHeaders;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;

class ServerRequest
extends Request {
    private Socket socket;
    private boolean moreRequests = false;
    private ServletInputStreamImpl in;
    private MimeHeaders headers = new MimeHeaders();
    private String serverName = "";

    ServerRequest() {
    }

    public long getDateHeader(String string) {
        return this.headers.getDateHeader(string);
    }

    public String getHeader(String string) {
        return this.headers.getHeader(string);
    }

    public Enumeration getHeaderNames() {
        return this.headers.names();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        return this.in;
    }

    public int getIntHeader(String string) {
        return this.headers.getIntHeader(string);
    }

    public BufferedReader getReader() throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream());
        return new BufferedReader(inputStreamReader);
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    boolean hasMoreRequests() {
        return this.moreRequests;
    }

    private void processCookies() {
        String string = this.headers.getHeader("cookie");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (n <= -1) continue;
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1, string2.length()).trim();
                Cookie cookie = new Cookie(string3, string4);
                this.cookies.addElement(cookie);
            }
        }
    }

    private void processFormData(InputStream inputStream, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            while ((n2 += inputStream.read(byArray, n2, byArray.length - n2)) < n && n2 != -1) {
            }
        }
        catch (IOException iOException) {}
        String string = new String(byArray, 0, n2);
        this.processFormData(string);
    }

    private void processFormData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&", false);
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = this.unUrlDecode(string2.substring(0, n));
            String string4 = this.unUrlDecode(string2.substring(n + 1, string2.length()));
            if (this.parameters.containsKey(string3)) {
                String[] stringArray2 = (String[])this.parameters.get(string3);
                stringArray = new String[stringArray2.length + 1];
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray[n2] = stringArray2[n2];
                    ++n2;
                }
                stringArray[stringArray2.length] = string4;
            } else {
                stringArray = new String[]{string4};
            }
            this.parameters.put(string3, stringArray);
        }
    }

    private void processRequestLine(String string) {
        String string2;
        String string3 = string.trim();
        int n = string3.indexOf(32);
        int n2 = string3.lastIndexOf(32);
        if (n == -1 && n2 == -1 && string3.trim().length() > 0) {
            n = string3.trim().length();
            n2 = string3.trim().length();
        }
        if (n != n2 && (string2 = string3.substring(n, n2)).trim().length() == 0) {
            n = n2;
        }
        if (n != n2) {
            this.method = string3.substring(0, n).trim();
            this.protocol = string3.substring(n2 + 1).trim();
            this.requestURI = string3.substring(n + 1, n2).trim();
        } else if (n != -1 && n2 != -1) {
            this.method = string3.substring(0, n).trim();
            this.protocol = null;
            if (n2 < string3.length()) {
                this.requestURI = string3.substring(n2 + 1).trim();
            }
        }
        if (this.protocol != null && !this.protocol.toLowerCase().startsWith("http/")) {
            this.requestURI = String.valueOf(this.requestURI) + " " + this.protocol;
            this.protocol = null;
        }
        int n3 = 0;
        try {
            int n4 = string.length();
            if (n4 < 2) {
                n3 = 400;
            } else if (string.charAt(n4 - 2) != '\r' || string.charAt(n4 - 1) != '\n') {
                n3 = 414;
                this.protocol = "HTTP/1.0";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        if (n3 == 0 && (this.requestURI == null || this.requestURI.indexOf(32) > -1 || this.requestURI.indexOf(47) != 0)) {
            n3 = 400;
        }
        if (n3 != 0) {
            try {
                this.response.sendError(n3);
            }
            catch (IOException iOException) {}
            return;
        }
        if (this.requestURI.indexOf("?") > -1) {
            this.queryString = this.requestURI.substring(this.requestURI.indexOf("?") + 1, this.requestURI.length());
            this.processFormData(this.queryString);
            this.requestURI = this.requestURI.substring(0, this.requestURI.indexOf("?"));
        }
    }

    void readNextRequest() throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        this.in = new ServletInputStreamImpl(this, inputStream);
        this.processRequestLine(this.in.readLine());
        if (this.response.getStatus() >= 400) {
            return;
        }
        this.headers.read(this.in);
        this.processCookies();
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
        this.moreRequests = false;
    }

    protected void reset() {
        super.reset();
        this.moreRequests = false;
        this.in = null;
        this.headers.clear();
        this.serverName = "";
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
        this.moreRequests = true;
    }

    private String unUrlDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                        n += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(n);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) break;
                        ++n;
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

