/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.core;

import com.sun.web.core.ApplicationSession;
import com.sun.web.core.Context;
import com.sun.web.core.Reaper;
import com.sun.web.core.Request;
import com.sun.web.core.Response;
import com.sun.web.core.ServerSession;
import com.sun.web.util.SessionIdGenerator;
import com.sun.web.util.StringManager;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.Cookie;

public class ServerSessionManager {
    private static final String SESSION_COOKIE_NAME = "SESSIONID";
    private StringManager sm = StringManager.getManager("com.sun.web.core");
    private static ServerSessionManager manager = new ServerSessionManager();
    private Hashtable sessions = new Hashtable();
    private Reaper reaper = Reaper.getReaper();

    private ServerSessionManager() {
        this.reaper.setServerSessionManager(this);
        this.reaper.start();
    }

    static ServerSessionManager getManager() {
        return manager;
    }

    ServerSession getServerSession(Request request, Response response, boolean bl) {
        Cookie cookie;
        String string = null;
        ServerSession serverSession = null;
        Enumeration enumeration = request.getCookies().elements();
        while (enumeration.hasMoreElements()) {
            cookie = (Cookie)enumeration.nextElement();
            if (!cookie.getName().equals(SESSION_COOKIE_NAME) || (string = cookie.getValue()) == null) continue;
            request.setRequestedSessionId(string);
            serverSession = (ServerSession)this.sessions.get(string);
        }
        if (serverSession == null && bl) {
            if (string == null) {
                string = SessionIdGenerator.generateId();
                cookie = new Cookie(SESSION_COOKIE_NAME, string);
                cookie.setMaxAge(-1);
                cookie.setPath("/");
                cookie.setVersion(1);
                response.addCookie(cookie);
            }
            serverSession = new ServerSession(string);
            this.sessions.put(string, serverSession);
        }
        return serverSession;
    }

    synchronized void reap() {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ServerSession serverSession = (ServerSession)this.sessions.get(k);
            serverSession.reap();
            serverSession.validate();
        }
    }

    void removeApplicationSessions(Context context) {
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ServerSession serverSession = (ServerSession)this.sessions.get(k);
            ApplicationSession applicationSession = serverSession.getApplicationSession(context, false);
            if (applicationSession == null) continue;
            applicationSession.invalidate();
        }
    }

    synchronized void removeSession(ServerSession serverSession) {
        String string = serverSession.getId();
        serverSession.invalidate();
        this.sessions.remove(string);
    }
}

