/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Util;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class BufferedInputStream
extends FilterInputStream {
    private byte[] buffer = new byte[2000];
    private int pos = 0;
    private int end = 0;
    private int mark_pos = -1;
    private int lr_thrshld = 1500;

    BufferedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        if (this.pos >= this.end) {
            this.fillBuff();
        }
        return this.end > this.pos ? this.buffer[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        if (this.pos >= this.end && n2 >= this.lr_thrshld && this.mark_pos < 0) {
            return this.in.read(byArray, n, n2);
        }
        if (this.pos >= this.end) {
            this.fillBuff();
        }
        if (this.pos >= this.end) {
            return -1;
        }
        int n3 = this.end - this.pos;
        if (n2 > n3) {
            n2 = n3;
        }
        System.arraycopy(this.buffer, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.end - this.pos;
        if (l <= (long)n) {
            this.pos = (int)((long)this.pos + l);
            return l;
        }
        this.pos = this.end;
        return (long)n + this.in.skip(l - (long)n);
    }

    private final void fillBuff() throws IOException {
        if (this.mark_pos > 0) {
            if (this.end >= this.buffer.length) {
                System.arraycopy(this.buffer, this.mark_pos, this.buffer, 0, this.end - this.mark_pos);
                this.pos = this.end - this.mark_pos;
            }
        } else if (this.mark_pos != 0 || this.end >= this.buffer.length) {
            this.pos = 0;
        }
        this.end = this.pos;
        int n = this.in.read(this.buffer, this.pos, this.buffer.length - this.pos);
        if (n > 0) {
            this.end = this.pos + n;
        }
    }

    public int available() throws IOException {
        int n = this.end - this.pos;
        if (n == 0) {
            return this.in.available();
        }
        try {
            n += this.in.available();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    void markForSearch() {
        this.mark_pos = this.pos;
    }

    int pastEnd(byte[] byArray, int[] nArray) {
        int n = Util.findStr(byArray, nArray, this.buffer, this.mark_pos, this.pos);
        if (n == -1) {
            this.mark_pos = this.pos > byArray.length ? this.pos - byArray.length : 0;
        } else {
            int n2 = n + byArray.length;
            n = this.pos - n2;
            this.pos = n2;
            this.mark_pos = -1;
        }
        return n;
    }
}

