/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ProxyAuthFailedException;
import com.sun.portal.util.ProxyAuthNeededException;
import com.sun.portal.util.ProxyUnreachableException;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import sun.misc.BASE64Encoder;

public class PingServiceRequest {
    private String serviceHost = null;
    private int servicePort = -1;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUser = null;
    private String proxyPassword = null;
    private boolean proxyAuthRequired = false;
    private static String retries = SystemProperties.get("gateway.sockretries", "2");

    public PingServiceRequest(URL uRL) {
        this.serviceHost = uRL.getHost();
        this.servicePort = uRL.getPort();
    }

    public PingServiceRequest(URL uRL, String string, int n) {
        this.serviceHost = uRL.getHost();
        this.servicePort = uRL.getPort();
        this.proxyHost = string;
        this.proxyPort = n;
    }

    public PingServiceRequest(URL uRL, String string, int n, String string2, String string3) {
        this.serviceHost = uRL.getHost();
        this.servicePort = uRL.getPort();
        this.proxyHost = string;
        this.proxyPort = n;
        this.proxyUser = string2;
        this.proxyPassword = string3;
        this.proxyAuthRequired = true;
    }

    public PingServiceRequest(String string, int n, String string2, int n2) {
        this.serviceHost = string;
        this.servicePort = n;
        this.proxyHost = string2;
        this.proxyPort = n2;
    }

    public PingServiceRequest(String string, int n, String string2, int n2, String string3, String string4) {
        this.serviceHost = string;
        this.servicePort = n;
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.proxyUser = string3;
        this.proxyPassword = string4;
        this.proxyAuthRequired = true;
    }

    public boolean isServiceAlive() throws ProxyAuthNeededException, ProxyAuthFailedException, ProxyUnreachableException {
        int n = Integer.parseInt(retries);
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Retry Number for Server # " + n2);
            }
            if (bl = this.checkService()) {
                return true;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    private boolean checkService() throws ProxyAuthNeededException, ProxyAuthFailedException, ProxyUnreachableException {
        if (GWDebug.debug.messageEnabled()) {
            String string = new String("\n***************Check Proxy information ....**************\n");
            string = string + "Proxy Host : " + this.proxyHost + "\n";
            string = string + "Proxy Port : " + this.proxyPort + "\n";
            string = string + "Proxy User : " + this.proxyUser + "\n";
            String string2 = null;
            if (this.proxyPassword != null) {
                string2 = "isPresent";
            }
            string = string + "Proxy Password : " + string2 + "\n";
            string = string + "Service Host : " + this.serviceHost + "\n";
            string = string + "Service Port : " + this.servicePort + "\n";
            string = string + "*********************************************************\n";
            GWDebug.debug.message("Checking Proxy Status:" + string.toString());
        }
        if (this.proxyHost == null || this.proxyHost.equals("null") || this.proxyHost.trim().length() < 1) {
            return this.directConnection();
        }
        return this.proxyConnection();
    }

    private boolean directConnection() {
        try {
            Socket socket = new Socket(this.serviceHost, this.servicePort);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Unable to connect to " + this.serviceHost + ":" + this.servicePort, exception);
            }
            return false;
        }
    }

    private boolean proxyConnection() throws ProxyAuthNeededException, ProxyAuthFailedException, ProxyUnreachableException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("CONNECT ").append(this.serviceHost).append(":").append(this.servicePort).append(" HTTP/1.0\r\n");
        if (this.proxyAuthRequired) {
            if (this.proxyUser == null || this.proxyPassword == null) {
                throw new ProxyAuthFailedException("Proxy Password or Proxy User is null");
            }
            object2 = new BASE64Encoder();
            object = object2.encode((this.proxyUser + ":" + this.proxyPassword).toString().getBytes());
            stringBuffer.append("Proxy-Authorization: Basic ").append((String)object).append("\r\n\r\n");
        } else {
            stringBuffer.append("\r\n");
        }
        try {
            object2 = new Socket(this.proxyHost, this.proxyPort);
            object = new DataInputStream(((Socket)object2).getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object2).getOutputStream());
            dataOutputStream.write(stringBuffer.toString().getBytes(), 0, stringBuffer.length());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
            String string = "";
            while ((string = bufferedReader.readLine()) != null && string.length() >= 3) {
                if (!string.startsWith("HTTP/1")) continue;
                int n = string.indexOf(" ");
                String string2 = string.substring(n + 1);
                if (string2.startsWith("407")) {
                    throw new ProxyAuthNeededException("Proxy Authentication Required");
                }
                if (string2.startsWith("401")) {
                    throw new ProxyAuthFailedException("Proxy Authentication Failed : Digest Authentication not supported");
                }
                if (!string2.startsWith("500")) continue;
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
        catch (IOException iOException) {
            throw new ProxyUnreachableException("Proxy is not reachable " + this.proxyHost + ":" + this.proxyPort);
        }
        return true;
    }
}

