/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.Base64;
import com.sun.portal.cli.cert.SRADecoderContext;
import com.sun.portal.cli.cert.SRADecoderException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public abstract class SRADecoder {
    protected Cipher cipher;
    protected MessageDigest digest;
    protected PBEParameterSpec paramSpec;
    protected SecretKey secretKey;
    protected SRADecoderContext decoderCntx;

    public abstract void init() throws SRADecoderException;

    protected abstract SRADecoderContext getDecoderContext();

    public String encrypt(String string) throws SRADecoderException {
        try {
            return this.getEncodedStr(this.encrypt(string.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            return this.getEncodedStr(this.encrypt(string.getBytes()));
        }
    }

    public String decrypt(String string) throws SRADecoderException {
        try {
            return new String(this.decrypt(this.decode(string.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception exception) {
            return new String(this.decrypt(this.decode(string.getBytes())));
        }
    }

    public byte[] encrypt(byte[] byArray) throws SRADecoderException {
        try {
            this.cipher.init(1, (Key)this.secretKey, this.paramSpec);
            return this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new SRADecoderException(exception.toString());
        }
    }

    public byte[] decrypt(byte[] byArray) throws SRADecoderException {
        try {
            this.cipher.init(2, (Key)this.secretKey, this.paramSpec);
            return this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new SRADecoderException(exception.toString());
        }
    }

    public String digest(String string) throws SRADecoderException {
        try {
            return this.getEncodedStr(this.digest(string.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            return this.getEncodedStr(this.digest(string.getBytes()));
        }
    }

    public byte[] digest(byte[] byArray) throws SRADecoderException {
        try {
            return this.digest.digest(byArray);
        }
        catch (Exception exception) {
            throw new SRADecoderException(exception.toString());
        }
    }

    protected byte[] encode(byte[] byArray) {
        return Base64.encode(byArray);
    }

    protected byte[] decode(byte[] byArray) {
        return Base64.decode(byArray);
    }

    public String getEncodedStr(byte[] byArray) {
        try {
            return new String(this.encode(byArray), "UTF-8");
        }
        catch (Exception exception) {
            return new String(this.encode(byArray));
        }
    }

    public String getDecodeStr(byte[] byArray) {
        try {
            return new String(this.decode(byArray), "UTF-8");
        }
        catch (Exception exception) {
            return new String(this.decode(byArray));
        }
    }
}

