/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.SRADecoderException;
import java.security.Security;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.util.PasswordCallback;
import sun.security.provider.Sun;

public class JSSContextImpl
implements JSSContext {
    protected String certdir;
    protected String fqdn;
    protected String locale = "en_US";
    protected String inst;
    protected CryptoManager cm;
    protected boolean passfileExist = true;
    protected boolean dbfileExist = true;
    protected SignatureAlgorithm sigAlg = SignatureAlgorithm.RSASignatureWithMD5Digest;
    protected boolean isPassEncrypted = true;
    protected PasswordContext passwdcntx;

    public JSSContextImpl() {
    }

    public JSSContextImpl(String string, String string2, String string3) {
        this(string, string3);
        this.fqdn = string2;
    }

    public JSSContextImpl(String string, String string2) {
        this.certdir = string;
        this.locale = string2;
    }

    public void setCertdir(String string) {
        this.certdir = string;
    }

    public void setHost(String string) {
        this.fqdn = string;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public String getCertdir() {
        return this.certdir;
    }

    public String getHost() {
        return this.fqdn;
    }

    public String getLocale() {
        return this.locale;
    }

    public CryptoManager getCryptoManager() {
        return this.cm;
    }

    public SignatureAlgorithm getSigAlg() {
        return this.sigAlg;
    }

    public boolean isPassFileExist() {
        return CertAdminUtil.fileExist(this.certdir + CertAdminConstants.SEPERATOR + ".jsspass");
    }

    public boolean isDBFileExist() {
        return CertAdminUtil.fileExist(this.certdir + CertAdminConstants.SEPERATOR + "key3.db");
    }

    public boolean isPasswordEcrypted() {
        if (this.isPassFileExist()) {
            String string = CertAdminUtil.readLine(this.certdir + CertAdminConstants.SEPERATOR + ".jsspass");
            this.isPassEncrypted = JSSUtil.isPasswordEncrypted(string);
        }
        return this.isPassEncrypted;
    }

    public void setPasswordMode(boolean bl) {
        this.isPassEncrypted = bl;
    }

    public void setPasswordContext(PasswordContext passwordContext) {
        this.passwdcntx = passwordContext;
    }

    public PasswordContext getPasswordContext() {
        return this.passwdcntx;
    }

    public boolean init() {
        CertAdminLocale.createDefault(this.locale);
        try {
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(this.certdir);
            CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
            this.cm = CryptoManager.getInstance();
            Security.insertProviderAt(new Sun(), 1);
            JSSUtil.setDefaultDecoder(this.certdir);
            CertAdminPasswordCallback certAdminPasswordCallback = new CertAdminPasswordCallback(this.passwdcntx.generatePassphrase(this));
            this.cm.setPasswordCallback((PasswordCallback)certAdminPasswordCallback);
        }
        catch (KeyDatabaseException keyDatabaseException) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m3", "Initialization: couldn't open the key database") + CertAdminConstants.newline + (Object)((Object)keyDatabaseException));
            return false;
        }
        catch (CertDatabaseException certDatabaseException) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m4", "Initialization: couldn't open the certificate database") + CertAdminConstants.newline + (Object)((Object)certDatabaseException));
            return false;
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m5", "Initialization: CryptoManager already initialized") + CertAdminConstants.newline + (Object)((Object)alreadyInitializedException));
        }
        catch (SRADecoderException sRADecoderException) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m54", "Error!, Could not initialize the JSS password engine") + CertAdminConstants.newline + sRADecoderException);
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m6", "Initialization: Exception occurred"));
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

