/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Hashtable;
import java.util.Properties;

public class ExchangeCalendarSSOAdapter
extends SSOAdapter {
    protected CalendarSession calSession;
    protected CalendarStore calStore;
    protected static String CALENDAR_DEFAULT_PROTOCOL = "http";
    protected static String serviceClass = "com.sun.ssoadapter.calendar.pim.APimCalStore";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String uidString = this.adapterProperties.getProperty("uid");
        if (uidString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingUid");
            throw ve;
        }
        String passwordString = this.adapterProperties.getProperty("password");
        if (passwordString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingPassword");
            throw ve;
        }
        String winDomainString = this.adapterProperties.getProperty("winDomain");
        if (winDomainString == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingWinDomain");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
    }

    public boolean isAvailable() {
        return this.calStore != null && this.calStore.isConnected();
    }

    public Object getConnection() {
        CalendarStore obj = null;
        try {
            obj = this.getCalStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public CalendarStore getCalStore() throws Exception {
        String host = this.adapterProperties.getProperty("host");
        if (this.isAvailable()) {
            return this.calStore;
        }
        this.calSession = this.getCalSession();
        this.calStore = this.calSession.getStore(serviceClass);
        this.calStore.connect(host);
        return this.calStore;
    }

    public CalendarSession getCalSession() throws Exception {
        if (this.calSession != null) {
            return this.calSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String uid = this.adapterProperties.getProperty("uid");
        String password = this.adapterProperties.getProperty("password");
        String protocol = this.adapterProperties.getProperty("protocol", CALENDAR_DEFAULT_PROTOCOL);
        String domain = this.adapterProperties.getProperty("winDomain");
        String ocxHost = this.adapterProperties.getProperty("ocxHost", host);
        if (uid != null) {
            ((Hashtable)props).put("cal.user", uid);
        }
        if (password != null) {
            ((Hashtable)props).put("cal.password", password);
        }
        if (protocol != null) {
            ((Hashtable)props).put("cal.protocol", protocol);
        }
        if (domain != null) {
            ((Hashtable)props).put("cal.exchange.domain", domain);
        }
        if (ocxHost != null) {
            ((Hashtable)props).put("cal.exchange.ocxhost", ocxHost);
        }
        ((Hashtable)props).put("cal.pim.service", "exchange");
        this.calSession = CalendarSession.getInstance((Properties)props);
        return this.calSession;
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.calStore.disconnect();
            this.calStore = null;
            this.calSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.calStore != null) {
                this.calStore.disconnect();
            }
            this.calStore = null;
            this.calSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

