/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.portlet.cli.PDDPUpdater;
import com.sun.portal.portlet.cli.PDProviderEntryGenerator;
import com.sun.portal.portlet.cli.PDWarUpdater;
import com.sun.portal.portlet.cli.PDWebAppUpdater;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

class PDDeploy {
    private static final String CONFIG_LOCATION_PROPERTY = "deployer.propertiesFile";
    private static final String WEB_XML = "web.xml";
    private static final String PORTLET_XML = "portlet.xml";
    private static final String EXT_XML = "sun-portlet.xml";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String DD_SUFFIX = "_portlet.xml";
    private Properties configProps = new Properties();

    public PDDeploy() throws PortletDeployerException {
        String configName = System.getProperty(CONFIG_LOCATION_PROPERTY);
        if (configName == null) {
            throw new PortletDeployerException("errorConfigFile");
        }
        try {
            this.configProps.load(new FileInputStream(configName));
        }
        catch (FileNotFoundException fnfe) {
            Object[] tokens = new Object[]{fnfe.toString()};
            throw new PortletDeployerException("errorConfigFile", tokens);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorConfigFile", tokens);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String process(DSAMEAdminDPContext dadc, String dn, boolean global, File warFile, String rolesfilename, String userinfofilename, boolean verbose) throws PortletDeployerException {
        PDWarUpdater pdwr = null;
        JarFile jar = null;
        String warName = warFile.getName();
        String portletAppName = warName.substring(0, warName.indexOf(46));
        String ddLocation = this.configProps.getProperty(DD_LOCATION);
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgGettingJarFile");
        }
        try {
            pdwr = new PDWarUpdater(warFile, this.configProps);
            jar = pdwr.getJarFile();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorGettingJarFile", tokens);
        }
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgGettingPortletDD");
        }
        InputStream in = null;
        try {
            int bytesRead;
            ZipEntry portletXMLEntry = jar.getEntry("WEB-INF/portlet.xml");
            in = jar.getInputStream(portletXMLEntry);
            InputStream portletIn = jar.getInputStream(portletXMLEntry);
            String ddName = portletAppName + DD_SUFFIX;
            File portletFile = new File(ddLocation, ddName);
            portletFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(portletFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = portletIn.read(buffer)) != -1) {
                void var20_28;
                fos.write(buffer, 0, (int)var20_28);
            }
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorStreamRead", tokens);
        }
        Properties rolesProps = new Properties();
        if (rolesfilename != null) {
            try {
                File rolesFile = new File(rolesfilename);
                if (!rolesFile.exists() || !rolesFile.canRead()) {
                    throw new PortletDeployerException("errorFileRead");
                }
                FileInputStream rolesIn = new FileInputStream(rolesFile);
                rolesProps.load(rolesIn);
                rolesIn.close();
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{ioe.toString()};
                throw new PortletDeployerException("errorFileRead", tokens);
            }
        }
        Properties uiProps = new Properties();
        if (userinfofilename != null) {
            try {
                File uiFile = new File(userinfofilename);
                if (!uiFile.exists() || !uiFile.canRead()) {
                    throw new PortletDeployerException("errorFileRead");
                }
                FileInputStream uiIn = new FileInputStream(uiFile);
                uiProps.load(uiIn);
                uiIn.close();
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{ioe.toString()};
                throw new PortletDeployerException("errorFileRead", tokens);
            }
        }
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgCreatingProviders");
        }
        InputStream webXMLStream1 = null;
        List roles = new ArrayList();
        try {
            ZipEntry webXMLEntry = jar.getEntry("WEB-INF/web.xml");
            webXMLStream1 = jar.getInputStream(webXMLEntry);
            roles = PDWebAppUpdater.getRoles(webXMLStream1);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorGettingRoles", tokens);
        }
        InputStream extStream = null;
        try {
            ZipEntry extXMLEntry = jar.getEntry("WEB-INF/sun-portlet.xml");
            if (extXMLEntry != null) {
                extStream = jar.getInputStream(extXMLEntry);
            }
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorGettingExtension", tokens);
        }
        PDProviderEntryGenerator providerGen = new PDProviderEntryGenerator(in, extStream, this.configProps, portletAppName);
        List providerElements = providerGen.createProviderElements(rolesProps, uiProps, roles);
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgUpdatingWebApp");
        }
        File newWebXMLFile = null;
        InputStream webXMLStream2 = null;
        try {
            ZipEntry webXMLEntry = jar.getEntry("WEB-INF/web.xml");
            webXMLStream2 = jar.getInputStream(webXMLEntry);
            newWebXMLFile = PDWebAppUpdater.addWebAppParam(webXMLStream2, this.configProps, portletAppName);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorUpdatingWebApp", tokens);
        }
        try {
            webXMLStream1.close();
            webXMLStream2.close();
            in.close();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorStreamClose", tokens);
        }
        try {
            File newWarFile = pdwr.getUpdatedWarFile(newWebXMLFile);
            if (newWarFile != null) {
                File destFile = new File(ddLocation, warFile.getName());
                PDDeploy.copyFile(newWarFile, destFile, true, false);
            }
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorJarUpdate", tokens);
        }
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgAddingProviders");
        }
        PDDPUpdater dpUpdater = new PDDPUpdater(dadc, dn, global, verbose);
        dpUpdater.addProviders(providerElements);
        return PortletDeployerLocalizer.getLocalizedString("msgSuccess");
    }

    public static void copyFile(String sourceFile, String destFile) throws IOException {
        PDDeploy.copyFile(new File(sourceFile), new File(destFile), false, true);
    }

    public static void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            File parent;
            if (destFile.exists() && destFile.isFile()) {
                destFile.delete();
            }
            if (!(parent = new File(destFile.getParent())).exists()) {
                parent.mkdirs();
            }
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            in.close();
            out.close();
            if (preserveLastModified) {
                destFile.setLastModified(sourceFile.lastModified());
            }
        }
    }
}

