/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.FreeBusy;
import com.sun.comclient.calendar.FreeBusyException;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.VFreeBusy;
import com.sun.comclient.calendar.socs.SOCSSession;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSFreeBusy
extends VFreeBusy {
    private boolean hasDuration = false;
    public static final String FREEBUSY = "FREEBUSY";
    public static final String DTEND = "DTEND";
    public static final String FBTYPE = "FBTYPE";
    public static final String BUSY = "BUSY";
    public static final String BUSY_UNAVAILABLE = "BUSY-UNAVAILABLE";
    public static final String BUSY_TENTATIVE = "BUSY-TENTATIVE";
    public static final String FREE = "FREE";
    public static final String ATTENDEE = "ATTENDEE";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String DURATION = "DURATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String RSTATUS = "REQUEST-STATUS";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String CALID = "RELATIVE-CALID";
    private static final int rfcDurationPrefixLength = new String("DURATION:").length();

    public SOCSFreeBusy(DateTime dateTime, DateTime dateTime2, FreeBusy[] freeBusyArray) throws IllegalArgumentException {
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == dateTime2) {
            throw new IllegalArgumentException("input given for \"dtend\" argument was found to be null");
        }
        if (null == freeBusyArray) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dateTime);
        this.setProperty(DTEND, dateTime2);
        this.setProperty(FREEBUSY, freeBusyArray);
        this.hasDuration = false;
        this.removeProperty(DURATION);
    }

    public SOCSFreeBusy(DateTime dateTime, Duration duration, FreeBusy[] freeBusyArray) throws IllegalArgumentException, PropertiesException {
        if (null == dateTime) {
            throw new IllegalArgumentException("input given for \"dtstart\" argument was found to be null");
        }
        if (null == duration) {
            throw new IllegalArgumentException("input given for \"duration\" argument was found to be null");
        }
        if (null == freeBusyArray) {
            throw new IllegalArgumentException("input given for \"freebusy\" argument was found to be null");
        }
        this.setStart(dateTime);
        this.setDuration(duration);
        this.setProperty(FREEBUSY, freeBusyArray);
        this.hasDuration = true;
        this.removeProperty(DTEND);
    }

    private String calendarComponentToRFC2445() {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Attendee[] attendeeArray;
        String string = new String("");
        if (null != this.getID()) {
            string = string + "\nUID:" + this.getID();
        }
        if (null != this.getUrl()) {
            string = string + "\nURL:" + this.getUrl();
        }
        if (null != this.getStamp()) {
            string = string + "\nDTSTAMP:" + this.getStamp().toISOString();
        }
        if (null != this.getOrganizer()) {
            string = string + "\n" + this.getOrganizer().toRFC2445();
        }
        if (null != (attendeeArray = this.getAttendees())) {
            int n = 0;
            while (n < attendeeArray.length) {
                string = string + "\n" + attendeeArray[n].toRFC2445();
                ++n;
            }
        }
        if (null != (stringArray3 = this.getComments())) {
            int n = 0;
            while (n < stringArray3.length) {
                string = string + "\nCOMMENT:" + stringArray3[n];
                ++n;
            }
        }
        if (null != (stringArray2 = this.getContacts())) {
            int n = 0;
            while (n < stringArray2.length) {
                string = string + "\nCONTACT:" + stringArray2[n];
                ++n;
            }
        }
        if (null != (stringArray = this.getRequestStatus())) {
            int n = 0;
            while (n < stringArray.length) {
                string = string + "\nRSTATUS:" + stringArray[n];
                ++n;
            }
        }
        return string;
    }

    private String freeBusyToRFC2445(FreeBusy[] freeBusyArray) {
        if (null == freeBusyArray) {
            return null;
        }
        String string = new String("");
        int n = 0;
        while (n < freeBusyArray.length) {
            string = string + "\n" + freeBusyArray[n].toRFC2445();
            ++n;
        }
        return string;
    }

    private String freeBusyToString(FreeBusy[] freeBusyArray) {
        if (null == freeBusyArray) {
            return null;
        }
        String string = new String("");
        int n = 0;
        while (n < freeBusyArray.length) {
            string = string + ";\n" + freeBusyArray[n].toString();
            ++n;
        }
        return string;
    }

    private boolean getHasDuration() {
        boolean bl = false;
        try {
            bl = this.hasDuration();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            bl = false;
        }
        catch (CalendarComponentException calendarComponentException) {
            bl = false;
        }
        return bl;
    }

    private FreeBusy[] getGetFreeBusy() {
        FreeBusy[] freeBusyArray = null;
        try {
            freeBusyArray = this.getFreeBusy();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            freeBusyArray = null;
        }
        catch (CalendarComponentException calendarComponentException) {
            freeBusyArray = null;
        }
        return freeBusyArray;
    }

    public String toRFC2445() {
        return "BEGIN:VFREEBUSY\nDTSTART:" + this.getStart().toISOString() + (this.getHasDuration() ? "\n" + this.getDuration().toRFC2445() : "\nDTEND:" + this.getEnd().toISOString()) + this.freeBusyToRFC2445(this.getGetFreeBusy()) + this.calendarComponentToRFC2445() + "\nEND:VFREEBUSY";
    }

    public String toString() {
        return "SOCSFreeBusy[" + super.toString() + ", hasDuration=\"" + this.getHasDuration() + "\"" + ", FreeBusy=\"" + this.freeBusyToString(this.getGetFreeBusy()) + "\"" + "]";
    }

    public boolean hasAttendee() {
        return this.hasProperty(ATTENDEE);
    }

    public Attendee getAttendee(String string) {
        if (null == string) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            return null;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Attendee attendee = (Attendee)arrayList.get(n);
            if (string.equals(attendee.getValue())) {
                return attendee;
            }
            ++n;
        }
        return null;
    }

    public Attendee[] getAttendees() {
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            return null;
        }
        Attendee[] attendeeArray = new Attendee[arrayList.size()];
        return arrayList.toArray(attendeeArray);
    }

    public void addAttendee(Attendee attendee) {
        ArrayList<Attendee> arrayList = (ArrayList<Attendee>)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            arrayList = new ArrayList<Attendee>();
            arrayList.add(attendee);
            this.setProperty(ATTENDEE, arrayList);
        } else {
            arrayList.add(attendee);
        }
    }

    public void removeAttendee(Attendee attendee) {
        if (null == attendee) {
            return;
        }
        String string = attendee.getValue();
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                Attendee attendee2 = (Attendee)arrayList.get(n);
                if (string.equals(attendee2.getValue())) {
                    arrayList.remove(n);
                    if (arrayList.size() > 0) break;
                    this.removeProperty(ATTENDEE);
                    break;
                }
                ++n;
            }
        }
    }

    public void removeAllAttendees() {
        this.removeProperty(ATTENDEE);
    }

    public String[] getContacts() {
        ArrayList arrayList = (ArrayList)this.getProperty(CONTACT);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addContact(String string) {
        if (null == string) {
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(CONTACT);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(CONTACT, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeContact(String string) {
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(CONTACT);
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equals((String)arrayList.get(n))) {
                    arrayList.remove(n);
                    if (arrayList.size() > 0) break;
                    this.removeProperty(CONTACT);
                    break;
                }
                ++n;
            }
        }
    }

    public void removeAllContacts() {
        this.removeProperty(CONTACT);
    }

    public String[] getComments() {
        ArrayList arrayList = (ArrayList)this.getProperty(COMMENT);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addComment(String string) {
        if (null == string) {
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(COMMENT);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(COMMENT, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeComment(String string) {
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(COMMENT);
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equals((String)arrayList.get(n))) {
                    arrayList.remove(n);
                    if (arrayList.size() > 0) break;
                    this.removeProperty(COMMENT);
                    break;
                }
                ++n;
            }
        }
    }

    public void removeAllComments() {
        this.removeProperty(COMMENT);
    }

    public DateTime getStamp() {
        return (DateTime)this.getProperty(DTSTAMP);
    }

    public void setStamp(DateTime dateTime) {
        this.setProperty(DTSTAMP, dateTime);
    }

    public Duration getDuration() {
        return (Duration)this.getProperty(DURATION);
    }

    public void setDuration(Duration duration) {
        this.setProperty(DURATION, duration);
    }

    public Organizer getOrganizer() {
        return (Organizer)this.getProperty(ORGANIZER);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(ORGANIZER, organizer);
    }

    public boolean isCalIdTheOrganizer(String string) {
        if (this.hasProperty(ORGANIZER)) {
            String string2 = this.getOrganizer().getValue();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public String[] getRequestStatus() {
        ArrayList arrayList = (ArrayList)this.getProperty(RSTATUS);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addRequestStatus(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(RSTATUS);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(RSTATUS, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeRequestStatus(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RSTATUS);
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RSTATUS);
            }
        }
    }

    public void removeAllRequestStatus() {
        this.removeProperty(RSTATUS);
    }

    public String getID() {
        return (String)this.getProperty(UID);
    }

    public void setID(String string) {
        this.setProperty(UID, string);
    }

    public String getUrl() {
        return (String)this.getProperty(URL);
    }

    public void setUrl(String string) {
        this.setProperty(URL, string);
    }

    public String getCalID() {
        return (String)this.getProperty(CALID);
    }

    public void setCalID(String string) {
        this.setProperty(CALID, string);
    }

    public DateTime getStart() {
        return (DateTime)this.getProperty("DTSTART");
    }

    public void setStart(DateTime dateTime) {
        this.setProperty("DTSTART", dateTime);
    }

    public DateTime getEnd() {
        return (DateTime)this.getProperty(DTEND);
    }

    public void setEnd(DateTime dateTime) {
        this.setProperty(DTEND, dateTime);
    }

    public FreeBusy[] getFreeBusy() throws OperationNotSupportedException, CalendarComponentException {
        return (FreeBusy[])this.getProperty(FREEBUSY);
    }

    public boolean hasDuration() throws OperationNotSupportedException, CalendarComponentException {
        return this.hasDuration;
    }

    public static SOCSFreeBusy fromXML(SOCSSession sOCSSession, Properties properties) throws IllegalArgumentException, PropertiesException, ParseException, FreeBusyException {
        String string;
        Object object;
        Object object2;
        if (null == properties) {
            throw new IllegalArgumentException("Null Argument passed: props is null");
        }
        if (null == sOCSSession) {
            throw new IllegalArgumentException("Null Argument passed: session is null");
        }
        TimeZone timeZone = sOCSSession.getCalStore().getSession().getTimeZone();
        if (null == timeZone) {
            timeZone = sOCSSession.getTimeZone();
        }
        ArrayList<FreeBusy> arrayList = new ArrayList<FreeBusy>();
        ArrayList arrayList2 = null;
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        if (null == properties.getProperty("START")) {
            throw new IllegalArgumentException("The tag or property \"START\" is missing in Free/Busy XML response");
        }
        dateTime = new DateTime(properties.getProperty("START"), timeZone);
        if (null == properties.getProperty("END")) {
            throw new IllegalArgumentException("The tag or property \"END\" is missing in Free/Busy XML response");
        }
        dateTime2 = new DateTime(properties.getProperty("END"), timeZone);
        if (null == properties.get("FB")) {
            throw new IllegalArgumentException("The tag or property \"FB\" is missing in Free/Busy XML response");
        }
        arrayList2 = (ArrayList)properties.get("FB");
        int n = 0;
        while (n < arrayList2.size()) {
            object2 = (Properties)arrayList2.get(n);
            object = null;
            string = ((Properties)object2).getProperty(FBTYPE);
            object = null == string ? "FREEBUSY:" + ((Properties)object2).getProperty("FB") : "FREEBUSY;FBTYPE=" + string + ":" + ((Properties)object2).getProperty("FB");
            FreeBusy[] freeBusyArray = FreeBusy.fromRFC2445((String)object, timeZone);
            int n2 = 0;
            while (n2 < freeBusyArray.length) {
                arrayList.add(freeBusyArray[n2]);
                ++n2;
            }
            ++n;
        }
        object2 = new FreeBusy[arrayList.size()];
        arrayList.toArray((T[])object2);
        object = new SOCSFreeBusy(dateTime, dateTime2, (FreeBusy[])object2);
        if (null != object && null != (string = properties.getProperty(CALID))) {
            ((SOCSFreeBusy)object).setCalID(string);
        }
        return object;
    }
}

