/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.util.GWDebug;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Redirect {
    private String dstHost;
    private int dstPort = 0;
    private String dstPortList;
    private boolean found = false;

    public Redirect(int n, SessionRequest sessionRequest) {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(sessionRequest.getSessionID());
            sSOTokenManager.refreshSession(sSOToken);
            String string = sSOToken.getProperty(Integer.toString(n));
            if (string == null || string.compareTo("") == 0) {
                this.found = false;
                return;
            }
            this.found = true;
            this.parseRedirect(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public String getDstHost() {
        return this.dstHost;
    }

    public boolean doRedirect() {
        return this.found;
    }

    private void parseRedirect(String string) {
        block7: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "^");
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    if (this.dstHost == null) {
                        this.dstHost = stringTokenizer.nextToken();
                    }
                    if (this.dstPort != 0) continue;
                    this.dstPortList = stringTokenizer.nextToken();
                    this.dstPort = Integer.parseInt(this.dstPortList);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Redirect: error reading target host/port");
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!GWDebug.debug.errorEnabled()) break block7;
                GWDebug.debug.error("Redirect: error parsing target port");
            }
        }
        if (GWDebug.debug.debugEnabled() && GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Redirect: parsed = " + this.dstHost + " " + this.dstPortList);
        }
    }

    public String getDstPortList() {
        return this.dstPortList;
    }
}

