/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.portlet.impl.EntityIDThreadLocal;
import com.sun.portal.portlet.impl.PortletRequestConstants;
import com.sun.portal.portlet.impl.PortletSessionImpl;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityRoleRefDescriptor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortletRequestImpl
implements PortletRequest {
    private HttpServletRequest _req;
    private HttpServletResponse _res;
    private PortletContainerRequest _pContReq;
    private PortletContainerResponse _pContRes;
    private Map _attributes;
    private PortletContext _context;
    private PortalContext _portalContext;
    private PortletDescriptor _pDescriptor;
    private Logger _logger;
    private static String PORTLET_SESSION_PREFIX = "javax.portlet.portlet_session";
    private static String HTTP_SESSION_ID = "javax.portlet.http_session_id";
    private static String CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    private static final String SESSION_INVALID = "javax.portlet.session_invalid";

    void init(HttpServletRequest req, HttpServletResponse res, PortletContainerRequest pContReq, PortletContainerResponse pContRes, PortletContext context, PortalContext portalContext, PortletDescriptor pDescriptor, Logger logger) {
        this._req = req;
        this._res = res;
        this._pContReq = pContReq;
        this._pContRes = pContRes;
        this._attributes = new HashMap();
        this._context = context;
        this._portalContext = portalContext;
        this._pDescriptor = pDescriptor;
        this._logger = logger;
        if (this._pContReq.getUserInfo() != null) {
            this._attributes.put("javax.portlet.userinfo", this._pContReq.getUserInfo());
        }
        this._attributes.put(PortletRequestConstants.SSO_TOKEN, this._pContReq.getSSOToken());
        EntityIDThreadLocal.set(pContReq.getEntityID());
        this.setAttribute(PortletRequestConstants.HTTP_SERVLET_REQUEST, this._req);
        this.setAttribute(PortletRequestConstants.HTTP_SERVLET_RESPONSE, this._res);
    }

    void clear() {
        this._req = null;
        this._res = null;
        this._pContReq = null;
        this._pContRes = null;
        this._attributes = null;
        this._context = null;
        this._portalContext = null;
        this._pDescriptor = null;
        this._logger = null;
        EntityIDThreadLocal.set(null);
    }

    public PortletMode getPortletMode() {
        return null;
    }

    public WindowState getWindowState() {
        return null;
    }

    public boolean isWindowStateAllowed(WindowState state) {
        boolean retVal = false;
        com.sun.portal.container.WindowState newState = new com.sun.portal.container.WindowState(state.toString());
        if (this._pContReq.getAllowableWindowState().contains(newState)) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        boolean isAllowed = false;
        ChannelMode newMode = new ChannelMode(portletMode.toString());
        if (this._pContReq.getAllowableChannelMode().contains(newMode)) {
            String mimeType;
            List supportedPortletModes;
            if (portletMode.equals((Object)PortletMode.VIEW)) {
                isAllowed = true;
            } else if (this._pDescriptor != null && (supportedPortletModes = this._pDescriptor.getSupportedPortletModes(mimeType = this.getResponseContentType())) != null) {
                int i = 0;
                while (i < supportedPortletModes.size() && !isAllowed) {
                    String mode = (String)supportedPortletModes.get(i);
                    if (portletMode.toString().equalsIgnoreCase(mode)) {
                        isAllowed = true;
                    }
                    ++i;
                }
            }
        }
        return isAllowed;
    }

    public PortletPreferences getPreferences() {
        return this._pContReq.getPortletPreferences();
    }

    public PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public PortletSession getPortletSession(boolean create) {
        PortletSession portletSession = null;
        HttpSession session = null;
        try {
            session = this._req.getSession(create);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        if (session != null) {
            String session_id = (String)this._req.getAttribute(HTTP_SESSION_ID);
            String sessionInvalid = (String)this._req.getAttribute(SESSION_INVALID);
            if (!session.getId().equals(session_id) && sessionInvalid.equals("true")) {
                session.invalidate();
                session = this._req.getSession(create);
            }
            if (session != null && (portletSession = (PortletSession)session.getAttribute(PORTLET_SESSION_PREFIX)) == null && create) {
                portletSession = new PortletSessionImpl(session, this._context);
                session.setAttribute(PORTLET_SESSION_PREFIX, (Object)portletSession);
            }
        }
        return portletSession;
    }

    public String getAuthType() {
        return this._req.getAuthType();
    }

    public String getRemoteUser() {
        return this._pContReq.getUserID();
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String role) {
        boolean isInRole = false;
        List refDescriptors = this._pDescriptor.getSecurityRoleRefDescriptors();
        List secRoleNames = this._pContReq.getRoles();
        if (secRoleNames != null) {
            int i = 0;
            while (i < refDescriptors.size() && !isInRole) {
                SecurityRoleRefDescriptor refDescriptor = (SecurityRoleRefDescriptor)refDescriptors.get(i);
                String roleName = refDescriptor.getRoleName();
                String roleLink = refDescriptor.getRoleLink();
                if (role.equalsIgnoreCase(roleName)) {
                    int j = 0;
                    while (j < secRoleNames.size() && !isInRole) {
                        String secRoleName = (String)secRoleNames.get(j);
                        if (roleLink != null) {
                            if (secRoleName.equalsIgnoreCase(roleLink)) {
                                isInRole = true;
                            }
                        } else if (secRoleName.equalsIgnoreCase(roleName)) {
                            isInRole = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return isInRole;
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name should not be null.");
        }
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public String getParameter(String name) {
        Object value;
        Map map = this.getParameterMap();
        String retVal = null;
        if (name == null) {
            throw new IllegalArgumentException("Parameter name should not be null.");
        }
        if (map != null && (value = map.get(name)) != null) {
            retVal = ((String[])value)[0];
        }
        return retVal;
    }

    public Enumeration getParameterNames() {
        Map map = this.getParameterMap();
        return Collections.enumeration(map.keySet());
    }

    public String[] getParameterValues(String name) {
        Object value;
        Map map = this.getParameterMap();
        String[] retVals = null;
        if (name == null) {
            throw new IllegalArgumentException("Parameter name should not be null.");
        }
        if (map != null && (value = map.get(name)) != null) {
            retVals = (String[])value;
        }
        return retVals;
    }

    public Map getParameterMap() {
        return Collections.EMPTY_MAP;
    }

    public Locale getLocale() {
        return this._pContReq.getLocale();
    }

    public Enumeration getLocales() {
        ArrayList<Locale> localeList = new ArrayList<Locale>(1);
        localeList.add(this._pContReq.getLocale());
        return Collections.enumeration(localeList);
    }

    public String getScheme() {
        return this._req.getScheme();
    }

    public String getServerName() {
        return this._req.getServerName();
    }

    public int getServerPort() {
        return this._req.getServerPort();
    }

    public boolean isSecure() {
        return this._req.isSecure();
    }

    public void setAttribute(String name, Object o) {
        if (name == null) {
            throw new IllegalArgumentException("Can not set attribue with null name.");
        }
        if (o == null) {
            this._attributes.remove(name);
        } else {
            this._attributes.put(name, o);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name should not be null.");
        }
        this._attributes.remove(name);
    }

    public String getResponseContentType() {
        List list = this._pContReq.getAllowableContentType();
        return (String)list.get(0);
    }

    public Enumeration getResponseContentTypes() {
        List contentTypes = this._pContReq.getAllowableContentType();
        List mimeTypes = this._pDescriptor.getSupportedMimeTypes();
        List<String> returnList = new ArrayList();
        boolean stop = false;
        int i = 0;
        while (i < contentTypes.size() && !stop) {
            String contentType = ((String)contentTypes.get(i)).toLowerCase();
            int j = 0;
            while (j < mimeTypes.size() && !stop) {
                String mimeType = ((String)mimeTypes.get(j)).toLowerCase();
                if (mimeType.equals("*/*")) {
                    returnList = contentTypes;
                    stop = true;
                } else if (contentType.equals(mimeType)) {
                    returnList.add(contentType);
                } else if (mimeType.equals("text/*") && contentType.startsWith("text/")) {
                    returnList.add(contentType);
                }
                ++j;
            }
            ++i;
        }
        return Collections.enumeration(returnList);
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        String retVal = null;
        if (name.equals("portlet.expiration-cache") && this._pContRes.getExpiration() != -999) {
            retVal = Integer.toString(this._pContRes.getExpiration());
        }
        if (retVal == null) {
            retVal = this._req.getHeader(name);
        }
        return retVal;
    }

    public Enumeration getProperties(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name should not be null.");
        }
        return this._req.getHeaders(name);
    }

    public Enumeration getPropertyNames() {
        return this._req.getHeaderNames();
    }

    public PortalContext getPortalContext() {
        return this._portalContext;
    }

    public String getContextPath() {
        return (String)this._req.getAttribute(CONTEXT_PATH_ATTRIBUTE);
    }

    public String getRequestedSessionId() {
        return this._req.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this._req.isRequestedSessionIdValid();
    }

    class BasicPrincipal
    implements Principal {
        private String user;

        BasicPrincipal(String user) {
            this.user = user;
        }

        public boolean equals(Object another) {
            return another instanceof Principal && ((Principal)another).getName().equals(this.user);
        }

        public String getName() {
            return this.user;
        }

        public String toString() {
            return this.getName();
        }
    }
}

