/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimSortType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.interfaces.PimMessageItems;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import lotus.domino.Database;
import lotus.domino.View;
import lotus.domino.ViewEntryCollection;

public abstract class LotusPimMessageItems
extends LotusPimItems
implements PimMessageItems {
    private ViewEntryCollection _oViewEntryCollection;
    private PimSortType m_oPimSortType = PimSortType.ASCENDING;

    public LotusPimMessageItems(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(lotusPimSession, recycle);
        this._oViewEntryCollection = viewEntryCollection;
    }

    public void setLotusMessageItems(ViewEntryCollection viewEntryCollection) {
        this._oViewEntryCollection = viewEntryCollection;
    }

    public Database getLotusDatabase() throws LotusPimException {
        try {
            View view = this.getLotusViewEntryCollection().getParent();
            Database database = view.getParent();
            return database;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntryCollection getLotusMessageItems() throws LotusPimException {
        return this.getLotusViewEntryCollection();
    }

    public ViewEntryCollection getLotusViewEntryCollection() throws LotusPimException {
        this.updateFilters();
        return this._oViewEntryCollection;
    }

    public ViewEntryCollection getLotusViewEntryCollectionWithoutUpdate() {
        return this._oViewEntryCollection;
    }

    public void updateFilters() throws LotusPimException {
    }

    public void sort(PimSortType pimSortType) throws LotusPimException {
        try {
            if (pimSortType != null) {
                this.m_oPimSortType = pimSortType;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimSortType getSortType() throws LotusPimException {
        return this.m_oPimSortType;
    }

    public int getCount() throws LotusPimException {
        try {
            return this.getLotusMessageItems().getCount();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.getLotusMessageItems().removeAll(true);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public abstract PimMessageItem getPreviousMessageItem() throws PimException;

    public abstract PimMessageItem getLastMessageItem() throws PimException;

    public abstract PimMessageItem getNextMessageItem() throws PimException;

    public abstract PimMessageItem getFirstMessageItem() throws PimException;

    public abstract PimMessageItem addMessageItem() throws PimException;

    public abstract PimMessageItem getMessageItem(String var1) throws PimException;

    public abstract PimMessageItem getMessageItem(int var1) throws PimException;

    public abstract PimMessageItemFilter getMessageItemFilter() throws PimException;
}

