/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.PimUserInfoParameter;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimUserInfo;
import com.aligo.pim.lotus.LotusPimAddressBook;
import com.aligo.pim.lotus.LotusPimCalendar;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimGlobalAddressBook;
import com.aligo.pim.lotus.LotusPimInbox;
import com.aligo.pim.lotus.LotusPimPersonalAddressBook;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTask;
import com.aligo.pim.lotus.LotusPimUserInfo;
import com.aligo.pim.util.ssl.PimSSLHandler;
import com.aligo.pim.util.ssl.PimSSLHandlerType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ProtocolException;
import java.net.URL;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

public class LotusPimContainer
implements PimContainer {
    LotusPimUserInfo m_oPimUserInfo;
    LotusPimSession m_oPimSession;
    private boolean isLocalThreadInited = false;
    private boolean isLocalConnect = false;
    private boolean m_bLoggedOn = false;
    private int m_iNumOfTries = 0;
    private int m_iMaxNumOfTries = 2;

    public PimUserInfo addUserInfo() {
        this.m_oPimUserInfo = new LotusPimUserInfo();
        return this.m_oPimUserInfo;
    }

    public void logon() throws LotusPimException {
        if (this.m_oPimUserInfo == null) {
            throw new LotusPimException(2L);
        }
        if (this.m_bLoggedOn) {
            this.logoff();
        }
        this.getLotusPimSession();
        this.m_bLoggedOn = true;
    }

    public void recycle() throws LotusPimException {
        this.logoff();
    }

    public void logoff() throws LotusPimException {
        if (!this.m_bLoggedOn) {
            throw new LotusPimException(9L);
        }
        if (this.m_oPimSession != null) {
            this.m_oPimSession.recycle();
            this.m_oPimUserInfo = null;
            this.m_oPimSession = null;
        }
        this.m_bLoggedOn = false;
    }

    private Session getLotusSession() throws LotusPimException {
        if (this.m_oPimUserInfo == null) {
            throw new LotusPimException(2L);
        }
        String string = this.m_oPimUserInfo.getServer();
        String string2 = this.m_oPimUserInfo.getUserName();
        String string3 = this.m_oPimUserInfo.getPassword();
        boolean bl = this.m_oPimUserInfo.isHTTPSEnabled();
        if (string == null || string.equals("")) {
            throw new LotusPimException(1L);
        }
        if (string2 == null || string2.equals("")) {
            throw new LotusPimException(1L);
        }
        try {
            Session session = null;
            if (string == null) {
                NotesThread.sinitThread();
                this.isLocalThreadInited = true;
                session = NotesFactory.createSession((String)null, (String)string2, (String)string3);
                this.isLocalConnect = true;
            } else {
                String string4;
                int n;
                int n2;
                URL uRL = null;
                String string5 = "";
                String string6 = "";
                int n3 = -500;
                int n4 = string.indexOf("/");
                int n5 = string.indexOf(":");
                if (n4 != -1) {
                    n2 = n4;
                    n = string.length();
                    string5 = string.substring(n2, n);
                    if (string5.lastIndexOf("/") == string5.length() - 1) {
                        string5 = string5.substring(0, string5.length() - 1);
                    }
                    string = string.substring(0, n4);
                }
                if (n5 != -1) {
                    n2 = n5 + 1;
                    n = string.length();
                    n3 = Integer.parseInt(string.substring(n2, n));
                    string = string.substring(0, n5);
                }
                string6 = string;
                if (bl) {
                    PimSSLHandler.set((PimSSLHandlerType)PimSSLHandlerType.TRUST_ALL);
                    uRL = n3 == -500 ? new URL("https", string6, string5 + "/diiop_ior.txt") : new URL("https", string6, n3, string5 + "/diiop_ior.txt");
                } else {
                    uRL = n3 == -500 ? new URL("http", string6, string5 + "/diiop_ior.txt") : new URL("http", string6, n3, string5 + "/diiop_ior.txt");
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string7 = "";
                while ((string4 = bufferedReader.readLine()) != null) {
                    string7 = string4;
                }
                bufferedReader.close();
                session = NotesFactory.createSessionWithIOR((String)string7, (String)string2, (String)string3);
            }
            return session;
        }
        catch (ProtocolException protocolException) {
            if (this.m_iNumOfTries < this.m_iMaxNumOfTries) {
                this.m_oPimUserInfo.set(PimUserInfoParameter.LOTUS_ENABLE_HTTPS, "true");
                ++this.m_iNumOfTries;
                return this.getLotusSession();
            }
            throw new LotusPimException(protocolException);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private LotusPimSession getLotusPimSession() throws LotusPimException {
        if (this.m_oPimSession == null) {
            Session session = this.getLotusSession();
            if (session == null) {
                return null;
            }
            this.m_oPimSession = new LotusPimSession(session, this.m_oPimUserInfo);
        }
        return this.m_oPimSession;
    }

    public PimFolder getFolder(String string) throws LotusPimException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimFolder getFolder(PimFolderType pimFolderType, String string) throws LotusPimException {
        return null;
    }

    public void refreshAndClean() throws LotusPimException {
        LotusPimSession lotusPimSession = this.getLotusPimSession();
        if (lotusPimSession == null) {
            return;
        }
        lotusPimSession.getDefaultRecycle().recycleAll();
        lotusPimSession.refreshDatabase();
    }

    public PimFolder getFolder(PimFolderType pimFolderType) throws LotusPimException {
        if (!this.m_bLoggedOn) {
            throw new LotusPimException(9L);
        }
        if (PimFolderType.INBOX.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            this.refreshAndClean();
            lotusPimSession.getInboxRecycle().recycleAll();
            LotusPimInbox lotusPimInbox = lotusPimSession.getInbox();
            return lotusPimInbox;
        }
        if (PimFolderType.OUTBOX.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            lotusPimSession.getOutboxRecycle().recycleAll();
            LotusPimInbox lotusPimInbox = lotusPimSession.getOutbox();
            return lotusPimInbox;
        }
        if (PimFolderType.CALENDAR.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            this.refreshAndClean();
            lotusPimSession.getCalendarRecycle().recycleAll();
            LotusPimCalendar lotusPimCalendar = lotusPimSession.getCalendar();
            return lotusPimCalendar;
        }
        if (PimFolderType.GLOBAL_ADDRESS_BOOK.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            if (this.m_oPimUserInfo.isGlobalAddressEntryItemsCacheTrue()) {
                LotusPimGlobalAddressBook lotusPimGlobalAddressBook = lotusPimSession.getGlobalAddressBook();
                return lotusPimGlobalAddressBook;
            }
            LotusPimAddressBook lotusPimAddressBook = lotusPimSession.getGlobalAddressBookNoCache();
            return lotusPimAddressBook;
        }
        if (PimFolderType.TASK.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            this.refreshAndClean();
            lotusPimSession.getTaskRecycle().recycleAll();
            LotusPimTask lotusPimTask = lotusPimSession.getTask();
            return lotusPimTask;
        }
        if (PimFolderType.PERSONAL_ADDRESS_BOOK.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            this.refreshAndClean();
            lotusPimSession.getPersonalAddressBookRecycle().recycleAll();
            LotusPimPersonalAddressBook lotusPimPersonalAddressBook = lotusPimSession.getPersonalAddressBook();
            return lotusPimPersonalAddressBook;
        }
        if (PimFolderType.SENT.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            lotusPimSession.getSentRecycle().recycleAll();
            LotusPimInbox lotusPimInbox = lotusPimSession.getSent();
            return lotusPimInbox;
        }
        if (PimFolderType.DELETED.equals(pimFolderType)) {
            LotusPimSession lotusPimSession = this.getLotusPimSession();
            if (lotusPimSession == null) {
                return null;
            }
            lotusPimSession.getDeletedRecycle().recycleAll();
            LotusPimInbox lotusPimInbox = lotusPimSession.getDeleted();
            return lotusPimInbox;
        }
        if (PimFolderType.JOURNAL.equals(pimFolderType)) {
            return null;
        }
        if (PimFolderType.NOTES.equals(pimFolderType)) {
            return null;
        }
        return null;
    }

    public PimAddressEntryItem getCurrentUser() throws LotusPimException {
        if (!this.m_bLoggedOn) {
            throw new LotusPimException(9L);
        }
        return this.getLotusPimSession().getCurrentUser();
    }

    public void setTimeZone(PimTimeZoneType pimTimeZoneType) throws LotusPimException {
    }

    public PimFolder getRootFolder() throws PimException {
        return this.getLotusPimSession().getRootFolder();
    }

    public PimFolder getPublicRootFolder() throws PimException {
        return null;
    }
}

