/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.pim.exchange.ExchangePimAppointmentItem;
import com.aligo.pim.exchange.ExchangePimContactItem;
import com.aligo.pim.exchange.ExchangePimDeleted;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimJournalItem;
import com.aligo.pim.exchange.ExchangePimMailItem;
import com.aligo.pim.exchange.ExchangePimMeetingItem;
import com.aligo.pim.exchange.ExchangePimMessageItems;
import com.aligo.pim.exchange.ExchangePimNotesItem;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimTaskItem;
import com.aligo.pim.interfaces.PimDeletedItem;
import com.aligo.pim.interfaces.PimDeletedItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;

public class ExchangePimDeletedItems
extends ExchangePimMessageItems
implements PimDeletedItems {
    public ExchangePimDeletedItems(ExchangeMessages _oMessages, ExchangePimSession pimSession) {
        super(_oMessages, pimSession);
    }

    public void setExchangeDeletedItems(ExchangeMessages _oMessages) {
        this.setExchangeMessages(_oMessages);
    }

    public ExchangeMessages getExchangeDeletedItems() {
        return this.getExchangeMessages();
    }

    public PimMessageItem getFirstDeletedItem() throws ExchangePimException {
        try {
            Object obj = this.getExchangeDeletedItems().getFirst(null);
            return this.getRespectiveItem(obj);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getNextDeletedItem() throws ExchangePimException {
        try {
            Object obj = this.getExchangeDeletedItems().getNext();
            return this.getRespectiveItem(obj);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getLastDeletedItem() throws ExchangePimException {
        try {
            Object obj = this.getExchangeDeletedItems().getLast(null);
            return this.getRespectiveItem(obj);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getPreviousDeletedItem() throws ExchangePimException {
        try {
            Object obj = this.getExchangeDeletedItems().getPrevious();
            return this.getRespectiveItem(obj);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getDeletedItem(int itemNumber) throws ExchangePimException {
        try {
            Object obj = this.getExchangeDeletedItems().getItem(itemNumber + 1);
            return this.getRespectiveItem(obj);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getDeletedItem(String id) throws ExchangePimException {
        return null;
    }

    public PimMessageItem getDeletedItemBackUpStrategy(String id) throws ExchangePimException {
        try {
            ExchangePimSession pimSession = this.getPimSession();
            ExchangePimDeleted pimDeleted = pimSession.getFreshDeleted();
            PimDeletedItems pimDeletedItems = pimDeleted.getDeletedItems();
            PimMessageItem pimMessageItem = pimDeletedItems.getFirstDeletedItem();
            while (pimMessageItem != null) {
                if (pimMessageItem.getID().equals(id)) {
                    return pimMessageItem;
                }
                pimMessageItem = pimDeletedItems.getNextDeletedItem();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimDeletedItem addDeletedItem() throws ExchangePimException {
        return null;
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExchangePimException {
        return this.getDeletedItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExchangePimException {
        return this.getDeletedItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExchangePimException {
        return this.getFirstDeletedItem();
    }

    public PimMessageItem getNextMessageItem() throws ExchangePimException {
        return this.getNextDeletedItem();
    }

    public PimMessageItem getLastMessageItem() throws ExchangePimException {
        return this.getLastDeletedItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExchangePimException {
        return this.getPreviousDeletedItem();
    }

    public PimMessageItem addMessageItem() throws ExchangePimException {
        return this.addDeletedItem();
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousMessageItem();
    }

    protected PimMessageItem getRespectiveItem(Object obj) throws ExchangePimException {
        block10: {
            try {
                if (this.getExchangeMessages().isMessage(obj)) {
                    ExchangeMessage exchangeMessage = (ExchangeMessage)obj;
                    if (exchangeMessage.getType().equals("IPM.Note")) {
                        ExchangePimMailItem mailItem = new ExchangePimMailItem(exchangeMessage, this.getPimSession());
                        return mailItem;
                    }
                    if (exchangeMessage.getType().equals("IPM.Task")) {
                        ExchangePimTaskItem taskItem = new ExchangePimTaskItem(exchangeMessage, this.getPimSession());
                        return taskItem;
                    }
                    if (exchangeMessage.getType().equals("IPM.Contact") || exchangeMessage.getType().equals("IPM.DistList")) {
                        ExchangePimContactItem contactItem = new ExchangePimContactItem(exchangeMessage, this.getPimSession());
                        return contactItem;
                    }
                    if (exchangeMessage.getType().equals("IPM.Activity")) {
                        ExchangePimJournalItem journalItem = new ExchangePimJournalItem(exchangeMessage, this.getPimSession());
                        return journalItem;
                    }
                    if (exchangeMessage.getType().equals("IPM.StickyNote")) {
                        ExchangePimNotesItem notesItem = new ExchangePimNotesItem(exchangeMessage, this.getPimSession());
                        return notesItem;
                    }
                    break block10;
                }
                if (this.getExchangeMessages().isMeeting(obj)) {
                    ExchangePimMeetingItem meetingItem = new ExchangePimMeetingItem(obj, this.getPimSession());
                    return meetingItem;
                }
                if (this.getExchangeMessages().isAppointment(obj)) {
                    ExchangePimAppointmentItem exchangePimAppointmentItem = new ExchangePimAppointmentItem(obj, this.getPimSession());
                    return exchangePimAppointmentItem;
                }
                return null;
            }
            catch (Exception e) {
                throw new ExchangePimException(e);
            }
        }
        return null;
    }
}

