/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.util;

public class Password {
    private static int DEFAULT_PAD_LENGTH = 15;

    public static String encode(String plaintext) {
        int a;
        boolean firstFound = false;
        int lenn = plaintext.length();
        char[] sbuf = plaintext.toCharArray();
        char[] nbuf = new char[lenn];
        int i = 0;
        while (i < lenn) {
            a = Character.getNumericValue(sbuf[i]);
            nbuf[i] = a >= 10 && a <= 22 ? (char)(sbuf[i] + 13) : (a >= 23 && a <= 35 ? (char)(sbuf[i] - 13) : (sbuf[i] >= '[' && sbuf[i] <= '`' || sbuf[i] >= '{' && sbuf[i] <= '\u007f' ? (char)(sbuf[i] - 32) : (char)(sbuf[i] - 7)));
            ++i;
        }
        char[] vbuf = new char[lenn + 26];
        int vj = 0;
        i = 0;
        while (i < lenn) {
            if (!firstFound) {
                a = Character.getNumericValue(nbuf[i]);
                if (a >= 10 && a <= 35) {
                    vbuf[vj] = nbuf[i];
                    int numChars = Password.calcNum(nbuf[i]);
                    firstFound = true;
                    Password.pad(++vj, numChars, vbuf, firstFound);
                    vj += numChars;
                } else {
                    vbuf[vj] = nbuf[i];
                    ++vj;
                }
            } else {
                vbuf[vj] = nbuf[i];
                ++vj;
            }
            ++i;
        }
        if (!firstFound) {
            Password.pad(vj, DEFAULT_PAD_LENGTH, vbuf, firstFound);
            vj += DEFAULT_PAD_LENGTH;
        }
        return new String(vbuf, 0, vj);
    }

    public static String decode(String encodedtext) {
        boolean found = false;
        int lenn = encodedtext.length();
        char[] sbuf = encodedtext.toCharArray();
        int i = 0;
        while (i < lenn) {
            int a = Character.getNumericValue(sbuf[i]);
            if (a >= 10 && a <= 35) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            char[] temp2 = new char[lenn];
            Password.rot13(sbuf, temp2);
            return new String(temp2, 0, lenn - DEFAULT_PAD_LENGTH);
        }
        int count = sbuf[i] % 20;
        if (count == 0) {
            count = 1;
        }
        count += 7;
        char[] temp = new char[lenn];
        char[] temp2 = new char[lenn];
        ++i;
        int l = 0;
        while (l < i) {
            temp[l] = sbuf[l];
            ++l;
        }
        i += count;
        while (i < lenn) {
            temp[l++] = sbuf[i++];
        }
        Password.rot13(temp, temp2);
        return new String(temp2, 0, l);
    }

    private static int calcNum(char c) {
        int x = c % 20;
        if (x == 0) {
            ++x;
        }
        return x + 7;
    }

    private static void rot13(char[] vbuf, char[] nbuf) {
        int i = 0;
        while (i < vbuf.length) {
            int a = Character.getNumericValue(vbuf[i]);
            nbuf[i] = a >= 10 && a <= 22 ? (char)(vbuf[i] + 13) : (a >= 23 && a <= 35 ? (char)(vbuf[i] - 13) : (vbuf[i] >= ';' && vbuf[i] <= '@' || vbuf[i] >= '[' && vbuf[i] <= '_' ? (char)(vbuf[i] + 32) : (char)(vbuf[i] + 7)));
            ++i;
        }
    }

    private static void pad(int start, int numChars, char[] vbuf, boolean found) {
        int vj = start;
        int j = 1;
        while (j <= numChars) {
            int rand;
            int ranInt;
            while (found ? (ranInt = (rand = (int)(Math.floor(Math.random() * 25.0) + 97.0)) % 123) < 65 || ranInt >= 91 && ranInt <= 96 : (ranInt = (rand = (int)(Math.floor(Math.random() * 25.0) + 33.0)) % 127) < 33 || ranInt >= 65 && ranInt <= 90 || ranInt >= 97 && ranInt <= 122) {
            }
            vbuf[vj] = (char)ranInt;
            ++vj;
            ++j;
        }
    }
}

