/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.ServiceContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PropertiesServiceContext
implements ServiceContext {
    protected Properties properties = new Properties();
    protected String filename = null;
    protected static final String CONTAINERPROVIDERCONTEXTCLASSNAME_KEY = "containerProviderContextClassName";
    protected static final String PROVIDERMANAGERCONTEXTCLASSNAME_KEY = "providerManagerContextClassName";
    protected static final String DPCONTEXTCLASSNAME_KEY = "dpContextClassName";
    protected static final String DPUSERCONTEXTCLASSNAME_KEY = "dpUserContextClassName";
    protected static final String DEBUGCONTEXTCLASSNAME_KEY = "debugContextClassName";
    protected static final String SESSIONCONTEXTCLASSNAME_KEY = "sessionContextClassName";
    protected static final String TEMPLATECONTEXTCLASSNAME_KEY = "templateContextClassName";
    protected static final String CLIENTCONTEXTCLASSNAME_KEY = "clientContextClassName";
    protected static final String PROPERTIESCONTEXTCLASSNAME_KEY = "propertiesContextClassName";
    protected static final String LOCALESTRING_KEY = "localeString";
    protected static final String NOSESSIONURL_KEY = "noSessionURL";
    protected static final String SESSIONRETURNURLPARAMNAME_KEY = "sessionReturnURLParamName";
    protected static final String DESKTOPURL_KEY = "desktopURL";
    protected static final String LOGOUTURL_KEY = "logoutURL";
    protected static final String LOGINURL_KEY = "loginURL";
    protected static final String EXECUTABLE_KEY = "executable";
    protected static final String TYPE_KEY = "type";
    protected static final String DEFAULTCHANNELNAME_KEY = "defaultChannelName";
    protected static final String EDITPROVIDERCONTAINERNAME_KEY = "editProviderContainerName";
    protected static final String TEMPLATEBASEDIR_KEY = "templateBaseDir";
    protected static final String DEFAULT_FILENAME = "/etc/opt/SUNWps/service-context.properties";

    public PropertiesServiceContext() {
        this(DEFAULT_FILENAME);
    }

    public PropertiesServiceContext(String filename) {
        this.filename = filename;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesContext.getDP(): ", ioe);
        }
    }

    public void init(HttpServletRequest req) {
    }

    public void init(HttpServletRequest req, String uid, String pw) {
    }

    public String getLocaleString() {
        return this.properties.getProperty(LOCALESTRING_KEY);
    }

    public String getDesktopType() {
        return this.properties.getProperty(TYPE_KEY);
    }

    public String getDefaultChannelName() {
        return this.properties.getProperty(DEFAULTCHANNELNAME_KEY);
    }

    public String getEditProviderContainerName() {
        return this.properties.getProperty(EDITPROVIDERCONTAINERNAME_KEY);
    }

    public String getDPContextClassName() {
        return this.properties.getProperty(DPCONTEXTCLASSNAME_KEY);
    }

    public String getDPUserContextClassName() {
        return this.properties.getProperty(DPUSERCONTEXTCLASSNAME_KEY);
    }

    public String getContainerProviderContextClassName() {
        return this.properties.getProperty(CONTAINERPROVIDERCONTEXTCLASSNAME_KEY);
    }

    public String getProviderManagerContextClassName() {
        return this.properties.getProperty(PROVIDERMANAGERCONTEXTCLASSNAME_KEY);
    }

    public String getPropertiesContextClassName() {
        return this.properties.getProperty(PROPERTIESCONTEXTCLASSNAME_KEY);
    }

    public String getTemplateContextClassName() {
        return this.properties.getProperty(TEMPLATECONTEXTCLASSNAME_KEY);
    }

    public String getClientContextClassName() {
        return this.properties.getProperty(CLIENTCONTEXTCLASSNAME_KEY);
    }

    public boolean isExecutable() {
        return new Boolean(this.properties.getProperty(EXECUTABLE_KEY));
    }

    public String getDesktopServletPath() {
        return this.properties.getProperty(DESKTOPURL_KEY);
    }

    public String getNoSessionURL() {
        return this.properties.getProperty(NOSESSIONURL_KEY);
    }

    public String getSessionReturnURLParamName() {
        return this.properties.getProperty(SESSIONRETURNURLPARAMNAME_KEY);
    }

    public String getLogoutURL() {
        return this.properties.getProperty(LOGOUTURL_KEY);
    }

    public String getLoginURL() {
        return this.properties.getProperty(LOGINURL_KEY);
    }

    public String getDebugContextClassName() {
        return this.properties.getProperty(DEBUGCONTEXTCLASSNAME_KEY);
    }

    public String getSessionContextClassName() {
        return this.properties.getProperty(SESSIONCONTEXTCLASSNAME_KEY);
    }

    public String getAuthlessSessionContextClassName() {
        return null;
    }

    public String getStringAttribute(String name) {
        return this.properties.getProperty(name);
    }

    public void setStringAttribute(String name, String val) {
        this.properties.setProperty(name, val);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(this.filename));
            this.properties.store(fos, "Last updated at: ");
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesContext.storeAttribute()", ioe);
        }
    }

    public Set getRoles() {
        return null;
    }
}

