/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DebugContext;
import com.sun.portal.desktop.util.PropertiesDebug;

public class PropertiesDebugContext
implements DebugContext {
    private PropertiesDebug debug = null;

    public void init(String name, short level) {
        this.debug = PropertiesDebug.getInstance(name);
        this.setDebugLevel(level);
    }

    public void setDebugLevel(short level) {
        switch (level) {
            case 0: {
                this.debug.setDebug(0);
                break;
            }
            case 1: {
                this.debug.setDebug(1);
                break;
            }
            case 2: {
                this.debug.setDebug(2);
                break;
            }
            case 3: {
                this.debug.setDebug(3);
                break;
            }
            default: {
                throw new ContextError("PropertiesDebugContext.setDebugLevel(): invalid log level=" + level);
            }
        }
    }

    public short getDebugLevel() {
        return (short)this.debug.getState();
    }

    public boolean isDebugWarningEnabled() {
        return this.debug.warningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.debug.messageEnabled();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isDebugErrorEnabled() {
        return true;
    }

    public void debugMessage(Object o) {
        if (o != null) {
            this.debug.message(o.toString());
        } else {
            this.debug.message("<null>");
        }
    }

    public void debugWarning(Object o) {
        if (o != null) {
            this.debug.warning(o.toString());
        } else {
            this.debug.warning("<null>");
        }
    }

    public void debugError(Object o) {
        if (o != null) {
            this.debug.error(o.toString());
        } else {
            this.debug.warning("<null>");
        }
    }

    public void debugMessage(Object o, Throwable t) {
        if (o != null) {
            this.debug.message(o.toString(), t);
        } else {
            this.debug.message("<null>", t);
        }
    }

    public void debugWarning(Object o, Throwable t) {
        if (o != null) {
            this.debug.warning(o.toString(), t);
        } else {
            this.debug.warning("<null>", t);
        }
    }

    public void debugError(Object o, Throwable t) {
        if (o != null) {
            this.debug.error(o.toString(), t);
        } else {
            this.debug.warning("<null>");
        }
    }

    public void debugTrace(Object o) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            this.debugError(o, e);
            return;
        }
    }
}

