/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.ParentContainerThreadLocalizer;
import com.sun.portal.desktop.context.PropertiesContext;
import com.sun.portal.desktop.context.SessionListener;
import com.sun.portal.desktop.context.UserEvent;
import com.sun.portal.desktop.context.UserListener;
import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.desktop.encode.EncoderException;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.IURLEncoder;
import com.sun.portal.providers.context.ClientPropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import com.sun.portal.providers.context.PropertiesFilterFactory;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public abstract class PSProviderContext
implements ProviderContext,
UserListener {
    protected static Map propertiesContexts = new HashMap();
    protected PropertiesContext propertiesContext = null;
    private static ServletConfig servletConfig = null;
    protected DesktopContext desktopContext = null;
    protected List localePropertiesFilters = null;
    protected String localeString = null;
    protected List clientPropertiesFilters = null;
    protected List clientAndLocalePropertiesFilters = null;
    protected String clientType = null;
    protected Set clientTypeParents = null;
    public static final String CLIENT_PROPERTIES_FILTERS = "clientPropertiesFilters";
    public static final String LOCALE_PROPERTIES_FILTERS = "localePropertiesFilters";
    public static final String CLIENT_AND_LOCALE_PROPERTIES_FILTERS = "clientAndLocalePropertiesFilters";

    public synchronized void init(HttpServletRequest req) {
        this.desktopContext = DesktopContextThreadLocalizer.get();
        servletConfig = ServletConfigThreadLocalizer.get();
        if (servletConfig == null) {
            throw new ContextError("PSProviderContext.init(): servlet config was null");
        }
        this.addUserListener(this);
        if (this.isAuthless(req)) {
            this.initAuthlessClientAndLocalePropertiesFilters();
        } else {
            this.initClientAndLocalePropertiesFilters(true, true);
        }
        this.initPropertiesContext();
    }

    public void refresh() {
        this.getPropertiesContext().refresh();
    }

    public abstract void contentChanged(String var1);

    public abstract void allContentChanged();

    protected String getPropertiesContextClassName() {
        return this.getDesktopContext().getPropertiesContextClassName();
    }

    protected PropertiesContext getPropertiesContext() {
        if (this.propertiesContext == null) {
            throw new ContextError("PSProviderContext.getPropertiesContext(): not initialized");
        }
        return this.propertiesContext;
    }

    protected void initPropertiesContext() {
        Map map = propertiesContexts;
        synchronized (map) {
            if (this.propertiesContext == null) {
                this.propertiesContext = (PropertiesContext)propertiesContexts.get(this.getUserID());
            }
            if (this.propertiesContext == null) {
                String propertiesContextClassName = this.getPropertiesContextClassName();
                if (propertiesContextClassName == null) {
                    throw new ContextError("DesktopContext.getPropertiesContext(): class name was null");
                }
                try {
                    this.propertiesContext = (PropertiesContext)Class.forName(propertiesContextClassName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", ncdfe);
                }
                catch (IllegalAccessException iae) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", iae);
                }
                catch (ClassCastException cce) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", cce);
                }
                catch (InstantiationException ie) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", ie);
                }
                catch (SecurityException se) {
                    throw new ContextError("PSProviderContext.getPropertiesContext()", se);
                }
                this.propertiesContext.init(DesktopRequestThreadLocalizer.getRequest());
                propertiesContexts.put(this.getUserID(), this.propertiesContext);
            }
        }
    }

    protected DesktopContext getDesktopContext() {
        return this.desktopContext;
    }

    public String getClassName(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getClassName(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getClassName(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getStringProperty(channel, key, false);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getStringProperty(channel, key, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, String def) throws ProviderContextException {
        try {
            return this.getStringProperty(channel, key, def, false);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, String def, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getStringProperty(channel, key, def, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, boolean localized) throws ProviderContextException {
        try {
            if (localized) {
                List pflist = this.getLocalePropertiesFilters();
                return this.getPropertiesContext().getStringProperty(channel, key, pflist);
            }
            return this.getPropertiesContext().getStringProperty(channel, key, (List)null);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public String getStringProperty(String channel, String key, String def, boolean localized) throws ProviderContextException {
        try {
            if (localized) {
                List pflist = this.getLocalePropertiesFilters();
                return this.getPropertiesContext().getStringProperty(channel, key, def, pflist);
            }
            return this.getPropertiesContext().getStringProperty(channel, key, def, null);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getStringProperty(): ", ce);
        }
    }

    public void setStringProperty(String channel, String key, String val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setStringProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setStringProperty(): ", ce);
        }
    }

    public void setStringProperty(String channel, String key, String val, List pflist) throws ProviderContextException {
        try {
            this.getPropertiesContext().setStringProperty(channel, key, val, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setStringProperty(): ", ce);
        }
    }

    public Iterator getNames(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getNames(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getNames(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionPropperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, Map def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, Map def, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getCollectionProperty(channel, key, def, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, boolean localized) throws ProviderContextException {
        try {
            if (localized) {
                List pflist = this.getLocalePropertiesFilters();
                return this.getPropertiesContext().getCollectionProperty(channel, key, pflist);
            }
            return this.getPropertiesContext().getCollectionProperty(channel, key, (List)null);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public Map getCollectionProperty(String channel, String key, Map def, boolean localized) throws ProviderContextException {
        try {
            if (localized) {
                List pflist = this.getLocalePropertiesFilters();
                return this.getPropertiesContext().getCollectionProperty(channel, key, def, pflist);
            }
            return this.getPropertiesContext().getCollectionProperty(channel, key, def, null);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getCollectionProperty(): ", ce);
        }
    }

    public void setCollectionProperty(String channel, String key, Map val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setCollectionProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setCollectionProperty(): ", ce);
        }
    }

    public void setCollectionProperty(String channel, String key, Map val, List pflist) throws ProviderContextException {
        try {
            this.getPropertiesContext().setCollectionProperty(channel, key, val, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setCollectionProperty(): ", ce);
        }
    }

    public void setCollectionProperty(String channel, String key, List val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setCollectionProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setCollectionProperty(): ", ce);
        }
    }

    public void setCollectionProperty(String channel, String key, List val, List pflist) throws ProviderContextException {
        try {
            this.getPropertiesContext().setCollectionProperty(channel, key, val, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setCollectionProperty(): ", ce);
        }
    }

    public boolean getBooleanProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getBooleanProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getBooleanProperty(): ", ce);
        }
    }

    public boolean getBooleanProperty(String channel, String key, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getBooleanProperty(channel, key, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getBooleanProperty(): ", ce);
        }
    }

    public boolean getBooleanProperty(String channel, String key, boolean def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getBooleanProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getBooleanProperty(): ", ce);
        }
    }

    public boolean getBooleanProperty(String channel, String key, boolean def, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getBooleanProperty(channel, key, def, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getBooleanProperty(): ", ce);
        }
    }

    public void setBooleanProperty(String channel, String key, boolean val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setBooleanProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setBooleanProperty(): ", ce);
        }
    }

    public void setBooleanProperty(String channel, String key, boolean val, List pflist) throws ProviderContextException {
        try {
            this.getPropertiesContext().setBooleanProperty(channel, key, val, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setBooleanProperty(): ", ce);
        }
    }

    public int getIntegerProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getIntegerProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getIntegerProperty(): ", ce);
        }
    }

    public int getIntegerProperty(String channel, String key, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getIntegerProperty(channel, key, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getIntegerProperty(): ", ce);
        }
    }

    public Object getProperty(String channel, String key) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProperty(channel, key);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getProperty(): ", ce);
        }
    }

    public Object getProperty(String channel, String key, Object def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getProperty(): ", ce);
        }
    }

    public void setProperty(String channel, String key, Object val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setProperty(): ", ce);
        }
    }

    public int getIntegerProperty(String channel, String key, int def) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getIntegerProperty(channel, key, def);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getIntegerProperty(): ", ce);
        }
    }

    public int getIntegerProperty(String channel, String key, int def, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getIntegerProperty(channel, key, def, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getIntegerProperty(): ", ce);
        }
    }

    public void setIntegerProperty(String channel, String key, int val) throws ProviderContextException {
        try {
            this.getPropertiesContext().setIntegerProperty(channel, key, val);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setIntegerProperty(): ", ce);
        }
    }

    public void setIntegerProperty(String channel, String key, int val, List pflist) throws ProviderContextException {
        try {
            this.getPropertiesContext().setIntegerProperty(channel, key, val, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.setIntegerProperty(): ", ce);
        }
    }

    public boolean existsStringProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsStringProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsStringProperty(): ", ce);
        }
    }

    public boolean existsStringProperty(String channel, String name, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsStringProperty(channel, name, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsStringProperty(): ", ce);
        }
    }

    public boolean existsStringProperty(String channel, String name, boolean localized) throws ProviderContextException {
        try {
            if (localized) {
                List pflist = this.getLocalePropertiesFilters();
                return this.getPropertiesContext().existsStringProperty(channel, name, pflist);
            }
            return this.getPropertiesContext().existsStringProperty(channel, name, null);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsStringProperty(): ", ce);
        }
    }

    public boolean existsBooleanProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsBooleanProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsBooleanProperty(): ", ce);
        }
    }

    public boolean existsBooleanProperty(String channel, String name, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsBooleanProperty(channel, name, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsBooleanProperty(): ", ce);
        }
    }

    public boolean existsIntegerProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsIntegerProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsIntegerProperty(): ", ce);
        }
    }

    public boolean existsIntegerProperty(String channel, String name, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsIntegerProperty(channel, name, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsIntegerProperty(): ", ce);
        }
    }

    public boolean existsCollectionProperty(String channel, String name) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsCollectionProperty(channel, name);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsCollectionProperty(): ", ce);
        }
    }

    public boolean existsCollectionProperty(String channel, String name, List pflist) throws ProviderContextException {
        try {
            return this.getPropertiesContext().existsCollectionProperty(channel, name, pflist);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsCollectionProperty(): ", ce);
        }
    }

    public boolean existsCollectionProperty(String channel, String name, boolean localized) throws ProviderContextException {
        try {
            if (localized) {
                List pflist = this.getLocalePropertiesFilters();
                return this.getPropertiesContext().existsCollectionProperty(channel, name, pflist);
            }
            return this.getPropertiesContext().existsCollectionProperty(channel, name, null);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.existsCollectionProperty(): ", ce);
        }
    }

    public synchronized List getClientAndLocalePropertiesFilters() throws ProviderContextException {
        if (this.isAuthless(DesktopRequestThreadLocalizer.getRequest())) {
            return this.getAuthlessClientAndLocalePropertiesFilters();
        }
        if (this.clientAndLocalePropertiesFilters == null) {
            throw new ProviderContextException("PSProviderContext.getClientAndLocalePropertiesFilters(): not initialized");
        }
        boolean clientTypeChanged = this.isClientTypeChanged();
        boolean localeChanged = this.isLocaleChanged();
        if (clientTypeChanged || localeChanged) {
            this.clientAndLocalePropertiesFilters = this.initClientAndLocalePropertiesFilters(clientTypeChanged, localeChanged);
        }
        return this.clientAndLocalePropertiesFilters;
    }

    private List getAuthlessClientAndLocalePropertiesFilters() throws ProviderContextException {
        List pflist = (List)ROC.getObject(CLIENT_AND_LOCALE_PROPERTIES_FILTERS);
        if (pflist == null) {
            pflist = this.initAuthlessClientAndLocalePropertiesFilters();
        }
        return pflist;
    }

    protected List initClientAndLocalePropertiesFilters(boolean clientTypeChanged, boolean localeChanged) {
        if (clientTypeChanged) {
            this.clientPropertiesFilters = this.initClientPropertiesFilters();
        }
        if (localeChanged) {
            this.localePropertiesFilters = this.initLocalePropertiesFilters();
        }
        ArrayList pflist = new ArrayList();
        pflist.addAll(this.clientPropertiesFilters);
        pflist.addAll(this.localePropertiesFilters);
        this.clientAndLocalePropertiesFilters = Collections.unmodifiableList(pflist);
        return this.clientAndLocalePropertiesFilters;
    }

    protected List initAuthlessClientAndLocalePropertiesFilters() {
        List pflist = new ArrayList();
        this.initAuthlessClientPropertiesFilters();
        this.initAuthlessLocalePropertiesFilters();
        pflist.addAll((List)ROC.getObject(CLIENT_PROPERTIES_FILTERS));
        pflist.addAll((List)ROC.getObject(LOCALE_PROPERTIES_FILTERS));
        pflist = Collections.unmodifiableList(pflist);
        ROC.setObject(CLIENT_AND_LOCALE_PROPERTIES_FILTERS, pflist);
        return pflist;
    }

    public synchronized List getLocalePropertiesFilters() throws ProviderContextException {
        if (this.isAuthless(DesktopRequestThreadLocalizer.getRequest())) {
            return this.getAuthlessLocalePropertiesFilters();
        }
        if (this.localePropertiesFilters == null) {
            throw new ProviderContextException("PSProviderContext.getLocalePropertiesFilters(): not initialized");
        }
        if (this.isLocaleChanged()) {
            this.localePropertiesFilters = PSProviderContext.initLocalePropertiesFilters(this.getLocaleString());
        }
        return this.localePropertiesFilters;
    }

    private List getAuthlessLocalePropertiesFilters() throws ProviderContextException {
        List pflist = (List)ROC.getObject(LOCALE_PROPERTIES_FILTERS);
        if (pflist == null) {
            pflist = this.initAuthlessLocalePropertiesFilters();
        }
        return pflist;
    }

    private boolean isLocaleChanged() {
        String newLocale = this.getDesktopContext().getLocaleString();
        return newLocale != null && !newLocale.equals(this.localeString);
    }

    protected List initLocalePropertiesFilters() {
        this.localeString = this.getLocaleString();
        this.localePropertiesFilters = PSProviderContext.initLocalePropertiesFilters(this.localeString);
        if (this.localePropertiesFilters == null) {
            this.localeString = Locale.getDefault().toString();
            this.localePropertiesFilters = PSProviderContext.initLocalePropertiesFilters(this.localeString);
        }
        return this.localePropertiesFilters;
    }

    protected List initAuthlessLocalePropertiesFilters() {
        String authlessLocale = this.getLocaleString();
        List pflist = PSProviderContext.initLocalePropertiesFilters(authlessLocale);
        ROC.setObject(LOCALE_PROPERTIES_FILTERS, pflist);
        return pflist;
    }

    protected static List initLocalePropertiesFilters(String stringformat) {
        if (stringformat == null) {
            return null;
        }
        ArrayList<PropertiesFilter> pflist = new ArrayList<PropertiesFilter>();
        StringTokenizer tokenizer = new StringTokenizer(stringformat, "_");
        try {
            while (tokenizer.hasMoreTokens()) {
                PropertiesFilter pf = PropertiesFilterFactory.get("com.sun.portal.providers.context.LocalePropertiesFilter", tokenizer.nextToken(), false);
                pflist.add(pf);
            }
        }
        catch (PropertiesFilterException pfe) {
            throw new ContextError("PSDesktopContext.initLocalePropertiesFilters(): ", pfe);
        }
        return Collections.unmodifiableList(pflist);
    }

    public synchronized List getClientPropertiesFilters() throws ProviderContextException {
        if (this.isAuthless(DesktopRequestThreadLocalizer.getRequest())) {
            return this.getAuthlessClientPropertiesFilters();
        }
        if (this.clientPropertiesFilters == null) {
            throw new ProviderContextException("PSProviderContext.getClientPropertiesFilters(): not initialized");
        }
        if (this.isClientTypeChanged()) {
            this.clientPropertiesFilters = this.initClientPropertiesFilters();
        }
        return this.clientPropertiesFilters;
    }

    private List getAuthlessClientPropertiesFilters() throws ProviderContextException {
        List pflist = (List)ROC.getObject(CLIENT_PROPERTIES_FILTERS);
        if (pflist == null) {
            pflist = this.initAuthlessClientPropertiesFilters();
        }
        return pflist;
    }

    private boolean isClientTypeChanged() {
        String newClientType = this.getDesktopContext().getClientType();
        if (newClientType != null) {
            if (!newClientType.equals(this.clientType)) {
                return true;
            }
            Set newClientTypeParents = ClientPropertiesFilter.getClientParents(this, newClientType);
            if (newClientTypeParents != null && !newClientTypeParents.equals(this.clientTypeParents)) {
                return true;
            }
        }
        return false;
    }

    protected List initAuthlessClientPropertiesFilters() {
        String authlessClientType = this.getClientType();
        if (authlessClientType == null) {
            authlessClientType = this.getDefaultClientType();
        }
        List authlessClientPropertiesFilters = this.initClientPropertiesFilters(authlessClientType);
        ROC.setObject(CLIENT_PROPERTIES_FILTERS, authlessClientPropertiesFilters);
        return authlessClientPropertiesFilters;
    }

    protected List initClientPropertiesFilters() {
        this.clientType = this.getClientType();
        this.clientTypeParents = ClientPropertiesFilter.getClientParents(this, this.clientType);
        this.clientPropertiesFilters = this.initClientPropertiesFilters(this.clientType);
        if (this.clientPropertiesFilters == null) {
            this.clientType = this.getDefaultClientType();
            this.clientPropertiesFilters = this.initClientPropertiesFilters(this.clientType);
        }
        return this.clientPropertiesFilters;
    }

    protected List initClientPropertiesFilters(String clientType) {
        if (clientType == null) {
            return null;
        }
        List filters = new ArrayList();
        try {
            filters = ClientPropertiesFilter.getClientFilters(this, clientType, false);
        }
        catch (PropertiesFilterException e) {
            throw new ContextError("PSProviderContext.initClientPropertiesFilters(): ", e);
        }
        return Collections.unmodifiableList(filters);
    }

    public String getProviderName(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProviderName(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getProviderName(): ", ce);
        }
    }

    public int getProviderVersion(String channel) throws ProviderContextException {
        try {
            return this.getPropertiesContext().getProviderVersion(channel);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getVersion(): ", ce);
        }
    }

    public String getDesktopURL(HttpServletRequest req) {
        return this.getDesktopContext().getDesktopURL(req);
    }

    public String getDesktopURL(HttpServletRequest req, Map query, Map pathInfo) {
        return this.getDesktopContext().getDesktopURL(req, query, pathInfo);
    }

    public String getDesktopURL(HttpServletRequest req, Map query, Map pathInfo, boolean escape) {
        String url = this.getDesktopContext().getDesktopURL(req, query, pathInfo);
        if (escape) {
            try {
                url = this.escape(url);
            }
            catch (ProviderContextException pce) {
                this.debugError("PSProviderContext.getDesktopURL(): Couldn't escape the url String", pce);
            }
        }
        return url;
    }

    public String getDesktopURL(HttpServletRequest req, String query, boolean escape) {
        String url = this.getDesktopContext().getDesktopURL(req, query);
        if (escape) {
            try {
                url = this.escape(url);
            }
            catch (ProviderContextException pce) {
                this.debugError("PSProviderContext.getDesktopURL(): Couldn't escape the urlString", pce);
            }
        }
        return url;
    }

    public String getLocaleString() {
        return this.getDesktopContext().getLocaleString();
    }

    public synchronized Locale getLocale() {
        return this.getDesktopContext().getLocale();
    }

    public String getDesktopType() {
        return this.getDesktopContext().getDesktopType();
    }

    public String getLogoutURL() {
        return this.getDesktopContext().getLogoutURL();
    }

    public String getLoginURL() {
        return this.getDesktopContext().getLoginURL();
    }

    public String getStringAttribute(String name) {
        return this.getDesktopContext().getStringAttribute(name);
    }

    public void setStringAttribute(String name, String val) {
        this.getDesktopContext().setStringAttribute(name, val);
    }

    public String encodeURL(String url) {
        return this.getDesktopContext().encodeURL(url);
    }

    public String getDefaultChannelName() {
        return this.getDesktopContext().getDefaultChannelName();
    }

    public StringBuffer getRequestServer(HttpServletRequest req) {
        return this.getDesktopContext().getRequestServer(req);
    }

    public String getContentType() {
        return this.getDesktopContext().getContentType();
    }

    public String getCharset() {
        return this.getDesktopContext().getCharset();
    }

    public String getClientType() {
        return this.getDesktopContext().getClientType();
    }

    public String getDefaultClientType() {
        return this.getDesktopContext().getDefaultClientType();
    }

    public String getClientPath() {
        return this.getDesktopContext().getClientPath();
    }

    public String getClientTypeProperty(String key) {
        return this.getDesktopContext().getClientTypeProperty(key);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return this.getDesktopContext().getClientTypeProperty(clientType, key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        return this.getDesktopContext().getClientTypeProperties(clientType, key);
    }

    public String escape(String unescaped) throws ProviderContextException {
        try {
            return Encoder.encode(this.getDesktopContext().getEncoderClassName(), unescaped);
        }
        catch (EncoderException ee) {
            throw new ProviderContextException("ProviderContext.escape():", ee);
        }
    }

    public Object getSessionProperty(String name) {
        return this.getDesktopContext().getSessionProperty(name);
    }

    public void setSessionProperty(String name, Object val) {
        this.getDesktopContext().setSessionProperty(name, val);
    }

    public String getSessionID() {
        return this.getDesktopContext().getSessionID();
    }

    public boolean isAuthless(HttpServletRequest req) {
        return this.getDesktopContext().isAuthless(req);
    }

    public String getUserID() {
        return this.getDesktopContext().getUserID();
    }

    public void addSessionListener(SessionListener sl) {
        this.getDesktopContext().addSessionListener(sl);
    }

    public void addUserListener(UserListener ul) {
        this.getDesktopContext().addUserListener(ul);
    }

    public String getClientProperty(String name) {
        return this.getDesktopContext().getClientProperty(name);
    }

    public void setClientProperty(String name, String value) {
        this.getDesktopContext().setClientProperty(name, value);
    }

    public boolean isDebugEnabled() {
        return this.getDesktopContext().isDebugEnabled();
    }

    public boolean isDebugErrorEnabled() {
        return this.getDesktopContext().isDebugErrorEnabled();
    }

    public boolean isDebugWarningEnabled() {
        return this.getDesktopContext().isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.getDesktopContext().isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        this.getDesktopContext().debugMessage(o);
    }

    public void debugWarning(Object o) {
        this.getDesktopContext().debugWarning(o);
    }

    public void debugError(Object o) {
        this.getDesktopContext().debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        this.getDesktopContext().debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        this.getDesktopContext().debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        this.getDesktopContext().debugError(o, t);
    }

    public StringBuffer getTemplate(String name, String file) throws ProviderContextException {
        try {
            return this.getDesktopContext().getTemplate(name, this.getProviderName(name), file).getTemplateSB();
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getTemplate(): ", ce);
        }
    }

    public StringBuffer getTemplate(String desktopType, String locale, String name, String clientPath, String file, String baseDir) throws ProviderContextException {
        try {
            ParsedTagArray pta = this.getDesktopContext().getTemplate(desktopType, locale, name, this.getProviderName(name), clientPath, file, baseDir);
            return pta.getTemplateSB();
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getTemplate(): ", ce);
        }
    }

    public StringBuffer getTemplate(String name, String file, Hashtable table) throws ProviderContextException {
        try {
            return this.getDesktopContext().getTemplate(name, this.getProviderName(name), file, table);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getTemplate(): ", ce);
        }
    }

    public StringBuffer getTemplate(String desktopType, String locale, String name, String clientPath, String file, Hashtable table, String baseDir) throws ProviderContextException {
        try {
            return this.getDesktopContext().getTemplate(desktopType, locale, name, this.getProviderName(name), clientPath, file, table, baseDir);
        }
        catch (ContextError ce) {
            throw new ProviderContextException("PSProviderContext.getTemplate(): ", ce);
        }
    }

    public File getTemplatePath(String name, String file) throws ProviderContextException {
        return this.getDesktopContext().getTemplatePath(name, this.getProviderName(name), file);
    }

    public File getTemplatePath(String desktopType, String locale, String name, String clientPath, String file, String baseDir) throws ProviderContextException {
        return this.getDesktopContext().getTemplatePath(desktopType, locale, name, this.getProviderName(name), clientPath, file, baseDir);
    }

    public File getTemplateMostSpecificPath(String name, String file) throws ProviderContextException {
        return this.getDesktopContext().getTemplateMostSpecificPath(name, this.getProviderName(name), file);
    }

    public File getTemplateMostSpecificPath(String desktopType, String locale, String name, String clientPath, String file, String baseDir) throws ProviderContextException {
        return this.getDesktopContext().getTemplateMostSpecificPath(desktopType, locale, name, this.getProviderName(name), clientPath, file, baseDir);
    }

    public String getStaticContentPath() {
        return this.getDesktopContext().getStaticContentPath();
    }

    public ServletConfig getServletConfig() {
        return servletConfig;
    }

    public void userLogout(UserEvent ue) {
        String uid = ue.getUserID();
        Map map = propertiesContexts;
        synchronized (map) {
            propertiesContexts.remove(uid);
        }
    }

    public String getConfigProperty(String key) {
        return this.getDesktopContext().getConfigProperty(key);
    }

    public String getParentContainerName(String channel) {
        String parent = ParentContainerThreadLocalizer.get();
        return parent;
    }

    public Set getRoles() {
        return this.getDesktopContext().getRoles();
    }

    public String getTopChannelName(HttpServletRequest req) {
        return this.getDesktopContext().getTopChannelName(req);
    }

    public String encodeURLParameter(String key) {
        String enc = null;
        if (key != null && key.length() != 0) {
            try {
                enc = IURLEncoder.encode(I18n.encodeCharset(key, this.getCharset()));
            }
            catch (Exception e) {
                if (this.isDebugErrorEnabled()) {
                    this.debugError("PSProviderContext().URLEncode:Exception encoding String", e);
                }
                enc = "";
            }
        }
        return enc;
    }

    public String decodeURLParameter(String key) {
        return key;
    }
}

