/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DSAMEDebugContext;
import com.sun.portal.desktop.context.DebugLevels;
import com.sun.portal.desktop.context.PropertiesConfigContext;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class DSAMEAdminDPContext
implements DPContext,
DPUserContext,
DSAMEConstants,
DebugLevels {
    protected ConfigContext configContext = null;
    protected DSAMEConnection dsameConn = null;
    protected static DSAMEDebugContext debugContext = new DSAMEDebugContext();
    protected static DSAMEDebugContext perfContext = new DSAMEDebugContext();
    protected Map dpDocumentsLastRead = new HashMap();
    protected long dpUserDocumentLastRead = -1L;

    public void init(HttpServletRequest req) {
        ServletConfig sc = ServletConfigThreadLocalizer.get();
        this.configContext = new PropertiesConfigContext();
        this.configContext.init(sc);
        debugContext.init("desktop.debug", this.configContext.getDebugLevel());
        perfContext.init("desktop.perf", this.configContext.getPerfLevel());
        SSOToken ssoToken = DSAMEConnection.getSSOToken(req);
        this.dsameConn = new DSAMEConnection(ssoToken);
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        ServletConfig sc = (ServletConfig)req.getAttribute("desktop.servletConfig");
        this.configContext = new PropertiesConfigContext();
        this.configContext.init(sc);
        debugContext.init("desktop.debug", this.configContext.getDebugLevel());
        perfContext.init("desktop.perf", this.configContext.getPerfLevel());
        this.dsameConn = new DSAMEConnection(uid, pw);
    }

    public void init(final String uid, String password, String propertiesFile, String logFilename) {
        PropertiesConfigContext pcc = new PropertiesConfigContext();
        pcc.init(propertiesFile);
        this.configContext = pcc;
        SSOToken ssoToken = null;
        try {
            SSOTokenManager ssom = DSAMEConnection.getSSOTokenManager();
            ssoToken = ssom.createSSOToken(new Principal(){

                public String getName() {
                    return uid;
                }
            }, password);
        }
        catch (SSOException se) {
            throw new ContextError("DSAMEAdminContext.init(): Failed to create SSOToken.  ", se);
        }
        debugContext.init(logFilename, this.configContext.getDebugLevel());
        perfContext.init("desktop.perf", this.configContext.getPerfLevel());
        this.dsameConn = new DSAMEConnection(ssoToken);
    }

    public boolean isValidating() {
        return true;
    }

    public String getNameSpaceURI() {
        return this.dsameConn.getGlobalAttribute("SunPortalDesktopService", "sunPortalDesktopDpNamespaceURI");
    }

    public synchronized Locale getLocale() {
        return Locale.getDefault();
    }

    public Set getDPDocumentNames() {
        return this.dsameConn.getNodeNames();
    }

    public Set getDPDocumentNames(String name) {
        return this.dsameConn.getNodeNames(name);
    }

    public String getDPDocument(String name) {
        String dp = this.dsameConn.getAttributeByDN(name, "sunPortalDesktopDpDocument");
        if (dp != null) {
            this.setDPDocumentLastRead(name);
        }
        return dp;
    }

    public String getGlobalDPDocument() {
        String dp = this.dsameConn.getGlobalAttribute("SunPortalDesktopService", "sunPortalDesktopDpDocument");
        if (dp != null) {
            this.setDPDocumentLastRead("_!global!_");
        }
        return dp;
    }

    public byte[] getDPUserDocument() {
        byte[] userDP = this.dsameConn.getAttributeByteArray("sunPortalDesktopDpDocumentUser");
        if (userDP != null) {
            this.setDPUserDocumentLastRead();
        }
        return userDP;
    }

    public String getDPDocumentByDN(String dn) {
        return this.getDPDocument(dn);
    }

    protected void setDPUserDocumentLastModified() {
        this.dsameConn.setAttribute("sunPortalDesktopDpLastModifiedUser", Long.toString(System.currentTimeMillis()));
    }

    public void storeDPUserDocument(String dp) {
        if (dp != null) {
            this.dsameConn.setAttribute("sunPortalDesktopDpDocumentUser", dp);
            this.setDPUserDocumentLastModified();
            this.setDPUserDocumentLastRead();
        }
    }

    protected void setDPDocumentLastModified(String name) {
        this.dsameConn.setAttributeByDN(name, "sunPortalDesktopDpLastModified", Long.toString(System.currentTimeMillis()));
    }

    public void storeDPDocumentByDN(String dn, String dp) {
        if (dp == null) {
            throw new ContextError("DSAMEAdminDPContext.storeDPDocumentByDN(): Passed in DP doc is null. ");
        }
        this.dsameConn.setAttributeByDN(dn, "sunPortalDesktopDpDocument", dp);
        this.setDPDocumentLastModified(dn);
        this.setDPDocumentLastRead(dn);
    }

    public void storeGlobalDPDocument(String dp) {
        this.dsameConn.setGlobalAttribute("SunPortalDesktopService", "sunPortalDesktopDpDocument", dp);
        this.setDPDocumentLastModified("_!global!_");
        this.setDPDocumentLastRead("_!global!_");
    }

    public void removeDPDocumentByDN(String dn) {
        this.dsameConn.removeAttributeByDN(dn, "sunPortalDesktopDpDocument");
        this.setDPDocumentLastModified(dn);
        this.setDPDocumentLastRead(dn);
    }

    public void removeGlobalDPDocument() {
        this.dsameConn.removeGlobalAttribute("SunPortalDesktopService", "sunPortalDesktopDpDocument");
        this.setDPDocumentLastModified("_!global!_");
        this.setDPDocumentLastRead("_!global!_");
    }

    protected void setDPUserDocumentLastRead() {
        long lastRead;
        this.dpUserDocumentLastRead = lastRead = System.currentTimeMillis();
    }

    protected void setDPDocumentLastRead(String name) {
        Long l = new Long(System.currentTimeMillis());
        this.dpDocumentsLastRead.put(name, l);
    }

    public long getDPDocumentLastModified(String name) {
        long lastModified;
        String lm = this.dsameConn.getAttributeByDN(name, "sunPortalDesktopDpLastModified");
        if (lm == null) {
            lastModified = -1L;
        } else {
            try {
                lastModified = Long.parseLong(lm);
            }
            catch (NumberFormatException nfe) {
                lastModified = -1L;
            }
        }
        return lastModified;
    }

    public long getDPUserDocumentLastModified() {
        long lastModified;
        String lm = this.dsameConn.getAttribute("sunPortalDesktopDpLastModifiedUser");
        if (lm == null) {
            lastModified = -1L;
        } else {
            try {
                lastModified = Long.parseLong(lm);
            }
            catch (NumberFormatException nfe) {
                lastModified = -1L;
            }
        }
        return lastModified;
    }

    public long getDPUserDocumentLastRead() {
        return this.dpUserDocumentLastRead;
    }

    public long getDPDocumentLastRead(String name) {
        Long l = (Long)this.dpDocumentsLastRead.get(name);
        long lastRead = -1L;
        if (l != null) {
            lastRead = l;
        }
        return lastRead;
    }

    public short getDebugLevel() {
        return debugContext.getDebugLevel();
    }

    public void setDebugLevel(short level) {
        debugContext.setDebugLevel(level);
    }

    public boolean isDebugWarningEnabled() {
        return debugContext.isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return debugContext.isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        debugContext.debugMessage(o);
    }

    public void debugWarning(Object o) {
        debugContext.debugWarning(o);
    }

    public void debugError(Object o) {
        debugContext.debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        debugContext.debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        debugContext.debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        debugContext.debugError(o, t);
    }

    public boolean isPerfMessageEnabled() {
        return perfContext.isDebugMessageEnabled();
    }

    public boolean isPerfWarningEnabled() {
        return perfContext.isDebugWarningEnabled();
    }

    public void perfMessage(Object o) {
        perfContext.debugMessage(o);
    }

    public void perfWarning(Object o) {
        perfContext.debugWarning(o);
    }
}

