/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPSubCommand;
import com.sun.portal.rewriter.util.i18n.LocaleHelper;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

class CLIPSpecHelper {
    CLIPSpecHelper() {
    }

    static String[] removeFirstNArguments(String[] args, int aCount) {
        if (aCount > args.length) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> lResult = new ArrayList<String>(Arrays.asList(args));
        int i = 0;
        while (i < aCount) {
            lResult.remove(0);
            ++i;
        }
        return lResult.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    static CLIPOption[] getCommonOptions(Node aNode) throws Exception {
        ArrayList<CLIPOption> v = new ArrayList<CLIPOption>();
        Node[] children = aNode.selectNodes("\\\\CLIPToolSpec\\CommonOptions\\Option");
        int i = 0;
        while (i < children.length) {
            v.add(CLIPSpecHelper.createOption(children[i]));
            ++i;
        }
        return v.toArray(new CLIPOption[0]);
    }

    static int findType(String aString) {
        String lString = aString.trim();
        if (lString.equalsIgnoreCase("REGULAR")) {
            return 1;
        }
        if (lString.equalsIgnoreCase("BOOLEAN")) {
            return 0;
        }
        return -1;
    }

    static Locale findLocale(String[] args) {
        int i = 0;
        while (i < args.length) {
            if ((args[i].equals("-l") || args[i].equals("--locale")) && i < args.length - 1) {
                Locale locale = LocaleHelper.getLocale(args[i + 1]);
                return locale;
            }
            ++i;
        }
        return Locale.getDefault();
    }

    static CLIPSubCommand createSubCommand(Node aNode, CLIPOption[] commonOptions) throws Exception {
        return new CLIPSubCommand(aNode.getAttributeValue("name"), CLIPSpecHelper.createOptions(aNode, commonOptions), Integer.parseInt(aNode.getAttributeValue("minOperands")), Integer.parseInt(aNode.getAttributeValue("maxOperands")), aNode.getAttributeValue("operandsHelp"), aNode.getAttributeValue("help"));
    }

    static CLIPOption[] createOptions(Node aNode, CLIPOption[] commonOptions) throws Exception {
        ArrayList<CLIPOption> v = new ArrayList<CLIPOption>(Arrays.asList(commonOptions));
        Node[] options = Node.getChildNodes(aNode, "Option");
        int i = 0;
        while (i < options.length) {
            v.add(CLIPSpecHelper.createOption(options[i]));
            ++i;
        }
        return v.toArray(CLIPOption.EMTPY_CLIP_OPTION_ARRAY);
    }

    private static CLIPOption createOption(Node aNode) throws Exception {
        return new CLIPOption(aNode.getAttributeValue("longName"), aNode.getAttributeValue("shortName"), CLIPSpecHelper.findType(aNode.getAttributeValue("type")), aNode.getAttributeValue("defaultValues"), aNode.getAttributeValue("help"));
    }
}

