/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.rewriter.util.http.ChunkedContent;
import com.sun.portal.rproxy.rewriter.util.http.ContentInfo;
import com.sun.portal.rproxy.rewriter.util.http.MIMEAndEncodingParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class HTTPData {
    private static final String CONTENT_LENGTH_PATTERN = "Content-length";
    private final Response response;
    private final PageSpec pageSpec;
    private final ContentInfo contentInfo;
    private byte[] contentBytes;
    private String rawEncodedString;
    private String rawEncodedStringLowerCase;
    private String pageContent;

    public HTTPData(PageSpec pageSpec, Response response) throws IOException {
        this.response = response;
        this.pageSpec = pageSpec;
        this.contentInfo = new ContentInfo();
        MIMEAndEncodingParser.parse(this);
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public boolean isStreamRead() {
        return this.contentBytes != null;
    }

    public byte[] getContentBytes() throws IOException {
        if (this.contentBytes == null) {
            this.contentBytes = HTTPData.readFullContent(this.response);
        }
        return this.contentBytes;
    }

    public String getRawEncodedString() throws IOException {
        if (this.rawEncodedString == null && this.getContentBytes() != null) {
            this.rawEncodedString = new String(this.getContentBytes());
        }
        return this.rawEncodedString;
    }

    public String getRawEncodedStringLowerCase() throws IOException {
        if (this.rawEncodedStringLowerCase == null) {
            this.rawEncodedStringLowerCase = this.getRawEncodedString().toLowerCase();
        }
        return this.rawEncodedStringLowerCase;
    }

    public PageSpec getPageSpec() {
        return this.pageSpec;
    }

    public String getPageContent() throws IOException {
        String string = this.contentInfo.getEncoding();
        if (string == null || string == Constants.SYSTEM_ENCODING) {
            this.contentInfo.setEncoding(Constants.SYSTEM_ENCODING);
            return this.getRawEncodedString();
        }
        if (this.pageContent == null && this.getContentBytes() != null) {
            this.pageContent = new String(this.getContentBytes(), this.contentInfo.getEncoding());
        }
        return this.pageContent;
    }

    private static byte[] readFullContent(Response response) throws IOException {
        int n;
        Object object;
        Object object2;
        String string = response.getResponseHeader(CONTENT_LENGTH_PATTERN);
        BufferedInputStream bufferedInputStream = response.getContentStream();
        if (response instanceof HTTPResponse && (object2 = ((HTTPResponse)(object = (HTTPResponse)response)).getResponseHeader("Transfer-Encoding")) != null && ((String)object2).substring((n = ((String)object2).indexOf(58)) + 1).trim().equalsIgnoreCase("chunked")) {
            byte[] byArray = ChunkedContent.readChunkedContent(bufferedInputStream);
            ((HTTPResponse)object).removeHeader("Transfer-Encoding");
            return byArray;
        }
        if (bufferedInputStream == null) {
            return null;
        }
        if (string != null) {
            int n2 = Integer.parseInt(string.substring(string.indexOf(58) + 1).trim());
            object2 = new byte[n2];
            n = 0;
            int n3 = 0;
            while (n3 < n2) {
                n = bufferedInputStream.read((byte[])object2, n3, n2 - n3);
                if (n == -1) break;
                n3 += n;
            }
            return object2;
        }
        object = new ByteArrayOutputStream();
        object2 = new byte[2048];
        while ((n = bufferedInputStream.read((byte[])object2)) != -1) {
            ((ByteArrayOutputStream)object).write((byte[])object2, 0, n);
        }
        return ((ByteArrayOutputStream)object).toByteArray();
    }
}

