/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.rproxy.https.SRAPPasswordCallback;
import com.sun.portal.util.GWDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.util.PasswordCallback;

public class SRAPNSSInit {
    public static String nickname = "server-cert";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initialize() {
        String string;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        String string2 = System.getProperty("gateway.keybase", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps"));
        JSSDebug.debug.message("SRAPNSSInit: certdbDir = " + string2);
        try {
            JSSUtil.setDefaultDecoder((String)string2);
        }
        catch (SRADecoderException sRADecoderException) {
            GWDebug.debug.error("SRAPNSSInit: Unable to initialize the password encryption module : " + sRADecoderException.getMessage());
        }
        String string3 = System.getProperty("gateway.nickname", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps") + File.separatorChar + "cert" + File.separatorChar + ".nickname");
        JSSDebug.debug.message("SRAPNSSInit: nicknamefile = " + string3);
        if (string3 != null) {
            try {
                fileInputStream = new FileInputStream(string3);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                nickname = bufferedReader.readLine();
            }
            catch (Exception exception) {
                JSSDebug.debug.message("SRAPNSSInit: Unable to read jss nickname from file " + string3);
            }
        } else {
            JSSDebug.debug.message("SRAPNSSInit: Unable to get nickname file name");
        }
        String string4 = System.getProperty("gateway.pass", System.getProperty("SRAP_CONFIG_DIR", "/etc/opt/SUNWps") + File.separatorChar + "cert" + File.separatorChar + ".jsspass");
        JSSDebug.debug.message("SRAPNSSInit: pwfile = " + string4);
        if (string4 == null) return false;
        try {
            fileInputStream = new FileInputStream(string4);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            Password password = JSSUtil.decryptPassword((String)string);
            string = password.getPassword();
            if (password.isEncrypted() && GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("SRAPNSSInit: Found encrypted password");
            }
        }
        catch (Exception exception) {
            return false;
        }
        try {
            fileInputStream = new CryptoManager.InitializationValues(string2);
            CryptoManager.initialize((CryptoManager.InitializationValues)fileInputStream);
            CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new SRAPPasswordCallback(string));
            return true;
        }
        catch (KeyDatabaseException keyDatabaseException) {
            JSSDebug.debug.error("SRAPNSSInit: Couldn't open the key database." + (Object)((Object)keyDatabaseException));
            return false;
        }
        catch (CertDatabaseException certDatabaseException) {
            JSSDebug.debug.error("SRAPNSSInit: Couldn't open the certificate database." + (Object)((Object)certDatabaseException));
            return false;
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            JSSDebug.debug.message("SRAPNSSInit: CryptoManager already initialized." + (Object)((Object)alreadyInitializedException));
            return true;
        }
        catch (Exception exception) {
            JSSDebug.debug.message("SRAPNSSInit: Exception occurred: " + exception.getMessage());
            return false;
        }
    }
}

