/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.SocketCache;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLCachedSSLSocketFactory {
    private static SocketCache _cache;
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    private static int _timeout;

    private static CachedSocket createSocket(String string, int n, String string2, Integer n2) {
        CachedSocket cachedSocket;
        block4: {
            cachedSocket = null;
            SSLSocket sSLSocket = null;
            Socket socket = null;
            try {
                socket = SSLSocketFactory.getDefault().createSocket(string, n);
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.incrementSSLSockets();
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("RProxy", GWLocale.getPFString("csslsf1", new Object[]{n2, socket.getInetAddress().toString(), new Integer(socket.getPort())}));
                }
                sSLSocket = (SSLSocket)socket;
                sSLSocket.setUseClientMode(true);
                socket.setSoTimeout(_timeout);
                cachedSocket = new CachedSocket(socket);
                cachedSocket.setType(string2);
                cachedSocket.setActive();
                cachedSocket.setSocketCache(_cache);
                _cache.putSocket(cachedSocket);
            }
            catch (Exception exception) {
                if (!GWDebug.debug.errorEnabled()) break block4;
                GWDebug.debug.error("SSLCachedSSLSocketFactory cannot open connection to " + string + ":" + n, exception);
            }
        }
        return cachedSocket;
    }

    public static CachedSocket createSocket(SSLSocket sSLSocket) {
        CachedSocket cachedSocket;
        block2: {
            cachedSocket = null;
            try {
                sSLSocket.setUseClientMode(true);
                sSLSocket.setSoTimeout(_timeout);
                cachedSocket = new CachedSocket(sSLSocket);
                cachedSocket.setType(new String("ssl"));
                cachedSocket.setActive();
                cachedSocket.setSocketCache(_cache);
                _cache.putSocket(cachedSocket);
            }
            catch (Exception exception) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("SSLCachedSSLSocketFactory cannot create socket", exception);
            }
        }
        return cachedSocket;
    }

    public static CachedSocket getCachedSocket(String string, int n, String string2, Integer n2) {
        CachedSocket cachedSocket = null;
        if (cachedSocket == null) {
            cachedSocket = SSLCachedSSLSocketFactory.createSocket(string, n, string2, n2);
        }
        return cachedSocket;
    }

    public static CachedSocket getNewCachedSocket(String string, int n, String string2, Integer n2) {
        return SSLCachedSSLSocketFactory.createSocket(string, n, string2, n2);
    }

    static {
        _timeout = GatewayProfile.getInt(BLOCKED_SOCKET_TIMEOUT, 200000);
        _cache = new SocketCache();
    }
}

