/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.CookieManager;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class HTTPResponse
implements Response {
    private static final String _crlf = new String(new byte[]{13, 10});
    private static final String _lf = new String(new byte[]{10});
    private List _headerLines = new ArrayList();
    private boolean _firstLine = true;
    private static final String supportedHTTPVersion = "HTTP/1.0";
    private String _httpVersion = "HTTP/1.0";
    private boolean _headerComplete = false;
    private String _statusCode = null;
    private String _statusText = null;
    private String _contentType = null;
    private String _contentEncoding = null;
    private BufferedInputStream _contentStream = null;
    private Map _headerCache = new HashMap();
    private CachedSocket sock = null;
    private static final String allowClientCaching = SystemProperties.get("gateway.allow.client.caching");

    public void setSocket(CachedSocket cachedSocket) {
        this.sock = cachedSocket;
    }

    public void closeSocket() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getHTTPVersion() {
        return this._httpVersion;
    }

    public String getStatusCode() {
        return this._statusCode;
    }

    public String getStatusText() {
        return this._statusText;
    }

    public String getContentType() {
        try {
            if (this._contentType == null) {
                String string = this.getResponseHeader("Content-Type");
                int n = string.indexOf(58);
                this._contentType = n == -1 ? "" : (string.endsWith(_crlf) ? string.substring(n + 1, string.length() - 2).trim() : string.substring(n + 1, string.length() - 1).trim());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this._contentType;
    }

    public void setContentLength(int n) {
        String string = this.getResponseHeader("Content-Length");
        if (string != null) {
            int n2 = this._headerLines.size();
            int n3 = 0;
            while (n3 < n2) {
                if (string.equals((String)this._headerLines.get(n3))) {
                    this._headerLines.remove(n3);
                    n2 = this._headerLines.size();
                }
                ++n3;
            }
        }
        this._headerLines.add("Content-Length: " + n + "\r\n");
    }

    public void setClientCaching() {
        if (allowClientCaching == null) {
            return;
        }
        String string = this.getResponseHeader("Pragma");
        if (string != null) {
            this.removeHeader("Pragma");
        }
        if (allowClientCaching.toLowerCase().equals("false")) {
            this._headerLines.add("Pragma: no-cache\r\n");
        }
    }

    public void setConnectionClose() {
        String string = this.getResponseHeader("Connection");
        if (string != null) {
            int n = this._headerLines.size();
            int n2 = 0;
            while (n2 < n) {
                if (string.equals((String)this._headerLines.get(n2))) {
                    this._headerLines.remove(n2);
                    this._headerCache.remove("connection");
                    break;
                }
                ++n2;
            }
        }
        this._headerLines.add("Connection: close\r\n");
    }

    public void setConnectionAlive(String string) {
        String string2 = this.getResponseHeader("Connection");
        String string3 = this.getResponseHeader("KeepAlive");
        int n = 0;
        boolean bl = string2 != null;
        boolean bl2 = string3 != null;
        int n2 = 0;
        if (bl) {
            ++n2;
        }
        if (bl2) {
            ++n2;
        }
        if (n2 > 0) {
            int n3 = this._headerLines.size();
            String string4 = null;
            int n4 = 0;
            while (n4 < n3) {
                string4 = this._headerLines.get(n4).toString();
                if (bl && string2.equals(string4)) {
                    this._headerLines.remove(n4);
                    this._headerCache.remove("connection");
                    if (++n == n2) break;
                    n3 = this._headerLines.size();
                } else if (bl2 && string2.equals(string3)) {
                    this._headerLines.remove(n4);
                    this._headerCache.remove("keepalive");
                    if (++n == n2) break;
                    n3 = this._headerLines.size();
                }
                ++n4;
            }
        }
        this._headerLines.add("Connection: Keep-Alive\r\n");
        this._headerLines.add("Keep-Alive: " + string + "\r\n");
    }

    public void setLocation(String string) {
        String string2 = this.getResponseHeader("Location");
        if (string2 != null) {
            int n = this._headerLines.size();
            int n2 = 0;
            while (n2 < n) {
                if (string2.equals((String)this._headerLines.get(n2))) {
                    this._headerLines.remove(n2);
                    break;
                }
                ++n2;
            }
        }
        if (string.toLowerCase().startsWith("location:")) {
            this._headerLines.add(string);
        } else {
            this._headerLines.add("Location: " + string + "\r\n");
        }
    }

    public void setContentLocation(String string) {
        String string2 = this.getResponseHeader("Content-Location");
        if (string2 != null) {
            int n = this._headerLines.size();
            int n2 = 0;
            while (n2 < n) {
                if (string2.equals((String)this._headerLines.get(n2))) {
                    this._headerLines.remove(n2);
                    break;
                }
                ++n2;
            }
        }
        if (string.toLowerCase().startsWith("content-location:")) {
            this._headerLines.add(string);
        } else {
            this._headerLines.add("Content-Location: " + string + "\r\n");
        }
    }

    public String getContentEncoding() {
        try {
            if (this._contentEncoding == null) {
                String string = this.getResponseHeader("Content-Encoding");
                int n = string.indexOf(58);
                this._contentEncoding = n == -1 ? "" : string.substring(n + 1, string.length() - 2).trim();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this._contentEncoding;
    }

    public String getResponseHeader(String string) {
        String string2 = (String)this._headerCache.get(string = string.toLowerCase());
        if (string2 == null) {
            int n = this._headerLines.size();
            int n2 = 0;
            while (n2 < n && string2 == null) {
                String string3 = (String)this._headerLines.get(n2);
                if (string3.regionMatches(true, 0, string, 0, string.length())) {
                    string2 = string3;
                    this._headerCache.put(string, string3);
                }
                ++n2;
            }
        }
        return string2;
    }

    public void setResponseHeader(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        int n = string2.length();
        if (string2.charAt(n - 1) != '\n' || string2.charAt(n - 2) != '\r') {
            string2 = string2 + _crlf;
        }
        int n2 = string.length();
        int n3 = this._headerLines.size();
        int n4 = 0;
        while (n4 < n3) {
            String string3 = (String)this._headerLines.get(n4);
            if (string3.regionMatches(true, 0, string, 0, n2)) {
                this._headerLines.remove(n4);
                this._headerLines.add(string2);
                this._headerCache.remove(string);
                return;
            }
            ++n4;
        }
        this._headerLines.add(string2);
    }

    public void appendResponseHeader(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        int n = string2.length();
        if (string2.charAt(n - 1) != '\n' || string2.charAt(n - 2) != '\r') {
            string2 = string2 + _crlf;
        }
        this._headerLines.add(string2);
    }

    public void removeResponseHeader(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        this._headerCache.remove(string);
        Iterator iterator = this._headerLines.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (!string2.regionMatches(true, 0, string, 0, n)) continue;
            iterator.remove();
        }
    }

    public BufferedInputStream getContentStream() {
        return this._contentStream;
    }

    public void setContentStream(BufferedInputStream bufferedInputStream) {
        this._contentStream = bufferedInputStream;
    }

    public boolean isHeaderComplete() {
        return this._headerComplete;
    }

    public void addHeaderLine(String string) {
        if (this._firstLine) {
            if (!string.equals(_crlf)) {
                this._firstLine = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                this._httpVersion = supportedHTTPVersion;
                this._statusCode = stringTokenizer.nextToken();
                this._statusText = stringTokenizer.hasMoreTokens() ? string.substring(string.indexOf(this._statusCode) + this._statusCode.length(), string.length() - 2).trim() : "";
            }
        } else if (string.equals(_crlf) || string.equals(_lf)) {
            this._headerComplete = true;
        } else {
            this._headerLines.add(string);
        }
    }

    public byte[] getHeaderBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write((this.getHTTPVersion() + " " + this.getStatusCode() + " " + this.getStatusText() + "\r\n").getBytes());
            int n = this._headerLines.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)this._headerLines.get(n2);
                if (!string.endsWith(_crlf)) {
                    string = string.substring(0, string.indexOf("\n")) + _crlf;
                }
                if (string.toLowerCase().startsWith("content-disposition")) {
                    dataOutputStream.write(string.getBytes("ISO-8859-1"));
                } else {
                    dataOutputStream.write(string.getBytes());
                }
                ++n2;
            }
            dataOutputStream.write("\r\n".getBytes());
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return new String(this.getHeaderBytes());
    }

    public void setStatusText(String string) {
        this._statusText = string;
    }

    public void processSetCookieHeaders(Request request) {
        if (!ServiceIdentifier.isGateway() || request.isCookieSupported()) {
            return;
        }
        CookieManager.processSetCookieHeaders(request, this);
    }

    public List getHeaderAttributeList(String string) {
        int n = string.length();
        int n2 = this._headerLines.size();
        LinkedList<String> linkedList = new LinkedList<String>();
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            String string3 = this._headerLines.get(n3).toString();
            int n4 = string3.indexOf(58);
            if (n4 != -1 && (string2 = string3.substring(0, n4).trim()).equalsIgnoreCase(string)) {
                linkedList.addLast(string3);
            }
            ++n3;
        }
        return linkedList;
    }

    public boolean removeHeader(String string) {
        boolean bl = false;
        int n = this._headerLines.size();
        Iterator iterator = this._headerLines.iterator();
        string = string.trim().toLowerCase();
        while (iterator.hasNext()) {
            String string2;
            String string3 = iterator.next().toString();
            int n2 = string3.indexOf(58);
            if (n2 == -1 || !(string2 = string3.substring(0, n2).trim()).equalsIgnoreCase(string)) continue;
            iterator.remove();
            bl = true;
        }
        this._headerCache.remove(string);
        return bl;
    }

    public void setHeader(String string, String string2) {
        int n = string2.indexOf(58);
        boolean bl = false;
        if (n != -1) {
            String string3 = string2.substring(0, n).trim();
            if (!string3.equalsIgnoreCase(string)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            string2 = string + " : " + string2;
        }
        this._headerLines.add(string2);
    }

    public void setHeader(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.setHeader(string, iterator.next().toString());
        }
    }
}

