/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.portal.rproxy.configservlet.AMHashMap;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.server.Operation;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class UserProfileCache
implements SSOTokenListener {
    private static UserProfileCache instance = null;
    private HashMap cache = new HashMap();
    private int numEntries = 0;
    private int numOfCleanCacheSkips = 0;
    private boolean keepGoing = true;
    NoSuchElementException noSuchElementException = null;
    static final boolean doDebug = false;
    static PrintWriter log = null;

    private UserProfileCache() {
    }

    public void ssoTokenChanged(SSOTokenEvent sSOTokenEvent) {
        int n = -1;
        try {
            n = sSOTokenEvent.getType();
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        if (n == 3 || n == 1 || n == 2) {
            String string = sSOTokenEvent.getToken().getTokenID().toString();
            this.removeEntry(string);
        }
    }

    private synchronized void addEntry(String string, UserSessionListenerTableEntry userSessionListenerTableEntry) {
        if (this.cache.put(string, userSessionListenerTableEntry) == null) {
            ++this.numEntries;
        }
    }

    private synchronized Object getEntry(String string) {
        return this.cache.get(string);
    }

    private synchronized void removeEntry(String string) {
        if (this.cache.remove(string) != null) {
            --this.numEntries;
        }
    }

    private synchronized boolean containsKey(String string) {
        return this.cache.containsKey(string);
    }

    static void writeLog(String string) {
    }

    static void writeLog(Exception exception) {
    }

    private Object getValue(String string) {
        UserSessionListenerTableEntry userSessionListenerTableEntry = (UserSessionListenerTableEntry)this.getEntry(string);
        if (userSessionListenerTableEntry != null) {
            return userSessionListenerTableEntry.getResponse();
        }
        try {
            SSOToken sSOToken = this.getSSOToken(string);
            Response response = this.fetchUserAttributes(sSOToken);
            this.addNewEntry(sSOToken, string, response);
            userSessionListenerTableEntry = (UserSessionListenerTableEntry)this.getEntry(string);
        }
        catch (Exception exception) {
            return null;
        }
        return userSessionListenerTableEntry.getResponse();
    }

    private void addNewEntry(SSOToken sSOToken, String string, Response response) {
        UserSessionListenerTableEntry userSessionListenerTableEntry = new UserSessionListenerTableEntry(response);
        this.addEntry(string, userSessionListenerTableEntry);
        try {
            sSOToken.addSSOTokenListener((SSOTokenListener)this);
        }
        catch (SSOException sSOException) {
            this.removeEntry(string);
        }
    }

    public static void addEntry(SSOToken sSOToken, String string, Response response) {
        instance.addNewEntry(sSOToken, string, response);
    }

    public static Response getResponse(String string) {
        return (Response)instance.getValue(string);
    }

    public static boolean contains(String string) {
        return instance.containsKey(string);
    }

    private void setAttributeInternal(String string, String string2, Set set) throws NoSuchElementException {
        Object object;
        UserSessionListenerTableEntry userSessionListenerTableEntry = (UserSessionListenerTableEntry)this.getEntry(string);
        if (userSessionListenerTableEntry != null) {
            userSessionListenerTableEntry.setAttribute(string2, set);
        } else {
            try {
                object = this.getSSOToken(string);
                Response response = this.fetchUserAttributes((SSOToken)object);
                this.addNewEntry((SSOToken)object, string, response);
                userSessionListenerTableEntry = (UserSessionListenerTableEntry)this.getEntry(string);
                userSessionListenerTableEntry.setAttribute(string2, set);
            }
            catch (Exception exception) {
                if (this.noSuchElementException == null) {
                    this.noSuchElementException = new NoSuchElementException("Missing profile object !");
                }
                throw this.noSuchElementException;
            }
        }
        object = new HashMap();
        ((HashMap)object).put(string2, set);
        this.updateDsameProfile(string, (Map)object);
    }

    public static void setAttribute(String string, String string2, Set set) throws NoSuchElementException {
        instance.setAttributeInternal(string, string2, set);
    }

    protected SSOToken getSSOToken(String string) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        SSOToken sSOToken = null;
        try {
            sSOToken = sSOTokenManager.createSSOToken(string);
        }
        catch (SSOException sSOException) {
            try {
                sSOToken = sSOTokenManager.createSSOToken(URLEncoder.encode(string));
            }
            catch (SSOException sSOException2) {
                throw sSOException2;
            }
            catch (Exception exception) {
                throw sSOException;
            }
        }
        return sSOToken;
    }

    private Response fetchUserAttributes(SSOToken sSOToken) throws AMException, SSOException {
        Object object;
        AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
        AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
        HashMap hashMap = null;
        Map map = null;
        Map map2 = null;
        HashMap<String, Object> hashMap2 = null;
        String string = "true";
        try {
            hashMap = aMUser.getServiceAttributes("srapGatewayAccessService");
            Set set = (Set)hashMap.get("sunPortalGatewayAllowedAuthLevel");
            if (set != null && (object = set.iterator()).hasNext()) {
                string = this.evaluateAuthAllowed(object.next().toString(), sSOToken, string);
            }
        }
        catch (Exception exception) {
            hashMap = new HashMap();
        }
        try {
            map = aMUser.getServiceAttributes("srapNetletService");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            map2 = aMUser.getServiceAttributes("iplanetAMUserService");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        try {
            object = new PolicyEvaluator("srapGatewayAccessService");
            bl = object.isAllowed(sSOToken, "", "sunPortalGatewayEnableSSO");
        }
        catch (PolicyException policyException) {
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        hashMap2 = new HashMap<String, Object>();
        object = new HashSet();
        object.add(new Boolean(bl).toString());
        hashMap2.put("sunPortalGatewayEnableSSO", object);
        AMHashMap aMHashMap = new AMHashMap();
        if (hashMap != null) {
            aMHashMap.putAll(hashMap);
        }
        if (map != null) {
            aMHashMap.putAll(map);
        }
        if (map2 != null) {
            aMHashMap.putAll(map2);
        }
        if (hashMap2 != null) {
            aMHashMap.putAll(hashMap2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        aMHashMap.put("sunPortalGatewayAllowedAuthLevelResult", hashSet);
        Response response = new Response("", "", aMHashMap);
        return response;
    }

    /*
     * Unable to fully structure code
     */
    private String evaluateAuthAllowed(String var1_1, SSOToken var2_2, String var3_3) {
        var4_4 = new StringTokenizer(var1_1, "|");
        var5_5 = var3_3;
        var6_6 = 0;
        try {
            var6_6 = var2_2.getAuthLevel();
            if (true) ** GOTO lbl12
        }
        catch (SSOException var7_7) {
            return var3_3;
        }
        do {
            if (!(var8_9 = new Operation(var7_8 = var4_4.nextToken().trim())).isValid() || !var8_9.evaluate(var6_6)) continue;
            return "true";
lbl12:
            // 2 sources

        } while (var4_4.hasMoreTokens());
        return "false";
    }

    protected void updateDsameProfile(String string, Map map) {
        try {
            SSOToken sSOToken = this.getSSOToken(string);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
            if (aMUser.isExists()) {
                aMUser.setAttributes(map);
                aMUser.store();
            }
        }
        catch (SSOException sSOException) {
        }
        catch (AMException aMException) {
            // empty catch block
        }
    }

    static {
        instance = new UserProfileCache();
    }

    class UserSessionListenerTableEntry {
        private Response resp = null;
        private long timestamp;

        public UserSessionListenerTableEntry(Response response) {
            this.resp = response;
            this.timestamp = System.currentTimeMillis();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public Response getResponse() {
            this.timestamp = System.currentTimeMillis();
            return this.resp;
        }

        public void setAttribute(String string, Set set) {
            Map map = (Map)this.resp.getReturnedObject();
            map.put(string, set);
            this.resp.setReturnedObject(map);
            this.timestamp = System.currentTimeMillis();
        }
    }
}

