/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSchema;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Map;

public class GlobalAttributesServiceHandler
implements ServiceHandler {
    public Response handleRequest(Request request) throws RemoteException {
        try {
            SSOToken sSOToken = this.getSSOToken(request);
            AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
            AMSchema aMSchema = aMStoreConnection.getSchema(request.getServiceName(), AMSchema.Type.GLOBAL);
            Map map = aMSchema.getAttributeDefaults();
            Response response = new Response(request.getServiceName(), request.getRequestType(), map);
            return response;
        }
        catch (SSOException sSOException) {
            throw new RemoteException("Not able to get Global Attributes", sSOException);
        }
        catch (AMException aMException) {
            throw new RemoteException("Not able to get Global Attributes", aMException);
        }
    }

    private SSOToken getSSOToken(Request request) throws RemoteException {
        try {
            String string = new String(AdminUtils.getAdminPassword());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            return sSOTokenManager.createSSOToken(new Principal(){

                public String getName() {
                    return AdminUtils.getAdminDN();
                }
            }, string);
        }
        catch (SSOException sSOException) {
            throw new RemoteException("Not able to get the token", sSOException);
        }
    }
}

