/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.common;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.common.TagText;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.List;

public final class TagTextRule
extends DataRule {
    private final TagText tagText;
    private final Pattern[] tagSpec;
    private final Pattern[][] tagAttributeSpec;
    private final boolean isStarAttributeValue;

    public TagTextRule(TagText aTagText) {
        this(aTagText, true);
    }

    public TagTextRule(TagText aTagText, boolean aIgnoreCase) {
        super(aTagText);
        this.tagText = aTagText;
        this.tagSpec = DataRule.createAttributeSpec(this.tagText.getTag(), aIgnoreCase);
        this.tagAttributeSpec = new Pattern[aTagText.getAttributeMap().size()][2];
        this.fillTagAttributeSpec(aIgnoreCase);
        this.isStarAttributeValue = aTagText.getAttributePatterns().equals("*");
    }

    public TagTextRule(Node aNode, boolean aIgnoreCase) {
        this(new TagText(aNode.getAttributeValue("tag"), aNode.getAttributeValue("attributePatterns"), aNode.getAttributeValue("source")), aIgnoreCase);
    }

    private void fillTagAttributeSpec(boolean aIgnoreCase) {
        ListMap cAttMap = this.tagText.getAttributeMap();
        List cAttNames = cAttMap.keyList();
        int i = 0;
        while (i < cAttNames.size()) {
            String bAttName = (String)cAttNames.get(i);
            this.tagAttributeSpec[i][0] = new Pattern(bAttName, aIgnoreCase);
            this.tagAttributeSpec[i][1] = new Pattern((String)cAttMap.get(bAttName), aIgnoreCase);
            ++i;
        }
    }

    public boolean plugableMatch(Data aMache) {
        if (!(aMache instanceof TagText)) {
            return false;
        }
        TagText valueObject = (TagText)aMache;
        if (DataRule.match(this.tagSpec, valueObject.getTag())) {
            if (this.isStarAttributeValue) {
                return true;
            }
            ListMap valueMap = valueObject.getAttributeMap();
            List valueKeyList = valueMap.keyList();
            int i = 0;
            while (i < valueKeyList.size()) {
                String valueKey = valueKeyList.get(i).toString();
                Pattern valueRule2Match = this.findValueRule2Match(valueKey);
                if (valueRule2Match == null) {
                    return false;
                }
                if (!DataRule.match(valueRule2Match, valueMap.get(valueKey).toString())) {
                    return false;
                }
                ++i;
            }
            return valueMap.size() >= this.tagAttributeSpec.length;
        }
        return false;
    }

    public boolean isValid() {
        return DataRule.doBasicValidation(new String[]{this.tagText.getTag()});
    }

    private Pattern findValueRule2Match(String aKey) {
        int i = 0;
        while (i < this.tagAttributeSpec.length) {
            if (DataRule.match(this.tagAttributeSpec[i][0], aKey)) {
                return this.tagAttributeSpec[i][1];
            }
            ++i;
        }
        return null;
    }

    public static final TagTextRule[] createTagTextRules(Node[] aNodeList, boolean aIgnoreCase) {
        TagTextRule[] lResult = new TagTextRule[aNodeList.length];
        int i = 0;
        while (i < aNodeList.length) {
            lResult[i] = new TagTextRule(aNodeList[i], aIgnoreCase);
            ++i;
        }
        return lResult;
    }

    public static void main(String[] args) {
        TagTextRule[] textStrings = SampleRuleObjects.defaultXMLTextStrings;
        int i = 0;
        while (i < textStrings.length) {
            Debug.println(textStrings[i].toXML());
            ++i;
        }
    }
}

