/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exceptions.PimExceptionMapper;
import com.aligo.pim.lotus.LotusPimExceptionMapper;
import com.aligo.pim.lotus.LotusPimUserInfo;
import lotus.domino.NotesException;
import org.omg.CORBA.INV_OBJREF;

public class LotusPimException
extends PimException {
    private long m_iLotusExceptionCode = -900L;
    private String m_szLotusExceptionMessage = "";
    private long m_iPimExceptionCode = -900L;
    private String m_szPimExceptionMessage = "";

    public LotusPimException(long l) {
        this.setPimExceptionCode(l);
        this.resolve();
    }

    public LotusPimException(Exception exception) {
        if (LotusPimUserInfo.DEBUG) {
            exception.printStackTrace();
        }
        if (exception instanceof NotesException) {
            NotesException notesException = (NotesException)((Object)exception);
            this.setLotusExceptionCode(notesException.id);
            this.setLotusExceptionMessage(notesException.text);
        } else if (exception instanceof LotusPimException) {
            LotusPimException lotusPimException = (LotusPimException)((Object)exception);
            this.setPimExceptionMessage(lotusPimException.getMessage());
            this.setPimExceptionCode(lotusPimException.getCode());
        } else if (exception instanceof INV_OBJREF) {
            LotusPimException lotusPimException = (LotusPimException)((Object)exception);
            this.setPimExceptionCode(27L);
        } else {
            this.setLotusExceptionMessage(exception.getMessage());
        }
        this.resolve();
    }

    private void setLotusExceptionCode(long l) {
        this.m_iLotusExceptionCode = l;
    }

    private void setLotusExceptionMessage(String string) {
        this.m_szLotusExceptionMessage = string;
    }

    private long getLotusExceptionCode() {
        return this.m_iLotusExceptionCode;
    }

    private String getLotusExceptionMessage() {
        return this.m_szLotusExceptionMessage;
    }

    private void setPimExceptionCode(long l) {
        this.m_iPimExceptionCode = l;
    }

    private void setPimExceptionMessage(String string) {
        this.m_szPimExceptionMessage = string;
    }

    private long getPimExceptionCode() {
        return this.m_iPimExceptionCode;
    }

    private String getPimExceptionMessage() {
        return this.m_szPimExceptionMessage;
    }

    public String getMessage() {
        return this.getPimExceptionMessage();
    }

    public long getCode() {
        return this.getPimExceptionCode();
    }

    private void resolve() {
        if (this.getPimExceptionCode() != -900L) {
            this.setPimExceptionMessage(PimExceptionMapper.getPimExceptionMessage((long)this.getPimExceptionCode()));
        } else if (this.getLotusExceptionCode() != -900L) {
            this.setPimExceptionCode(LotusPimExceptionMapper.getPimExceptionCode(this.getLotusExceptionCode()));
            this.setPimExceptionMessage(PimExceptionMapper.getPimExceptionMessage((long)this.getPimExceptionCode()));
        } else {
            this.setPimExceptionMessage(this.getLotusExceptionMessage());
        }
    }
}

