/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimSortType;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimAppointmentItemFilter;
import com.aligo.pim.interfaces.PimAppointmentItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;
import com.aligo.pim.lotus.LotusPimAppointmentItem;
import com.aligo.pim.lotus.LotusPimAppointmentItemFilter;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimItems;
import com.aligo.pim.lotus.LotusPimNewAppointmentItem;
import com.aligo.pim.lotus.LotusPimRecurringAppointmentItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.View;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;

public class LotusPimAppointmentItems
extends LotusPimItems
implements PimAppointmentItems {
    private LotusPimAppointmentItemFilter m_oPimAppointmentItemFilter;
    private RecurringAppointmentDateIndexManager m_oRecurringAppointmentDateIndexManager;
    private View _oView;

    public LotusPimAppointmentItems(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) throws LotusPimException {
        super(lotusPimSession, recycle);
        try {
            this._oView = viewEntryCollection.getParent();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setLotusAppointmentItems(ViewEntryCollection viewEntryCollection) throws LotusPimException {
        try {
            this._oView = viewEntryCollection.getParent();
            if (this.m_oPimAppointmentItemFilter != null) {
                this.m_oPimAppointmentItemFilter.reset();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntryCollection getLotusViewEntryCollection() throws Exception {
        try {
            ((LotusPimAppointmentItemFilter)this.getAppointmentItemFilter()).update();
            return ((LotusPimAppointmentItemFilter)this.getAppointmentItemFilter()).getLotusViewEntryCollection();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public View getLotusView() {
        return this._oView;
    }

    public Database getLotusDatabase() throws LotusPimException {
        try {
            return this._oView.getParent();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem addAppointmentItem() throws LotusPimException {
        try {
            return new LotusPimNewAppointmentItem(this.getLotusViewEntryCollection(), this.getLotusPimSession(), this.getRecycle());
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItemFilter getAppointmentItemFilter() throws LotusPimException {
        try {
            if (this.m_oPimAppointmentItemFilter == null) {
                this.m_oPimAppointmentItemFilter = new LotusPimAppointmentItemFilter(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimAppointmentItemFilter;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws LotusPimException {
        try {
            return this.getAppointmentItemFilter();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public ViewEntry getViewEntry(int n) throws LotusPimException {
        try {
            if (this.getCount() <= 0 || n >= this.getCount() || n < 0) {
                return null;
            }
            ViewEntry viewEntry = this.getLotusViewEntryCollection().getNthEntry(n + 1);
            this.getRecycle().add(viewEntry);
            return viewEntry;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private boolean isItRecurringAppointment(ViewEntry viewEntry) throws LotusPimException {
        try {
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return false;
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("OrgRepeat");
            String string3 = document.getItemValueString("AppointmentType");
            String string4 = document.getItemValueString("Repeats");
            return string2 != null && string2.equals("1") && !string3.equals("2") && string4.equals("1");
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem getAppointmentItem(int n) throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(n);
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getAppointmentItem(n + 1);
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Appointment")) {
                if (this.isItRecurringAppointment(viewEntry)) {
                    return new LotusPimRecurringAppointmentItem(viewEntry, this.getIndexManager().getFirstIndex(viewEntry), this.getIndexManager().getFirstIndex(viewEntry), this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimAppointmentItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getAppointmentItem(n + 1);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem getAppointmentItem(String string) throws LotusPimException {
        try {
            Document document;
            Object object;
            int n = string.indexOf("+");
            if (n != -1) {
                Document document2;
                Object object2;
                object = null;
                int n2 = -1;
                int n3 = -1;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
                if (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    object2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                    n2 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    n3 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                }
                if ((object2 = this.getLotusDatabase()) != null && (document2 = object2.getDocumentByID((String)object)) != null) {
                    this.getRecycle().add(document2);
                    return new LotusPimRecurringAppointmentItem(document2, n2, n3, this.getLotusPimSession(), this.getRecycle());
                }
            }
            if ((object = this.getLotusDatabase()) != null && (document = object.getDocumentByUNID(string)) != null) {
                this.getRecycle().add(document);
                LotusPimAppointmentItem lotusPimAppointmentItem = new LotusPimAppointmentItem(document, this.getLotusPimSession(), this.getRecycle());
                return lotusPimAppointmentItem;
            }
            return null;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem getFirstAppointmentItem() throws LotusPimException {
        try {
            this.getIndexManager().clearHash();
            ViewEntry viewEntry = this.getViewEntry(this.getFirstIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getNextAppointmentItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Appointment")) {
                if (this.isItRecurringAppointment(viewEntry)) {
                    int n = this.getIndexManager().getFirstIndex(viewEntry);
                    return new LotusPimRecurringAppointmentItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimAppointmentItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getNextAppointmentItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem getLastAppointmentItem() throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(this.getLastIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getPreviousAppointmentItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Appointment")) {
                if (this.isItRecurringAppointment(viewEntry)) {
                    int n = this.getIndexManager().getLastIndex(viewEntry);
                    return new LotusPimRecurringAppointmentItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimAppointmentItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getPreviousAppointmentItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem getNextAppointmentItem() throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(this.getNextIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getNextAppointmentItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Appointment")) {
                if (this.isItRecurringAppointment(viewEntry)) {
                    int n = this.getIndexManager().getNextIndex(viewEntry);
                    return new LotusPimRecurringAppointmentItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimAppointmentItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getNextAppointmentItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimAppointmentItem getPreviousAppointmentItem() throws LotusPimException {
        try {
            ViewEntry viewEntry = this.getViewEntry(this.getPreviousIndex());
            if (viewEntry == null) {
                return null;
            }
            String string = viewEntry.getNoteID();
            Document document = this.getLotusDatabase().getDocumentByID(string);
            if (document == null) {
                return this.getPreviousAppointmentItem();
            }
            this.getRecycle().add(document);
            String string2 = document.getItemValueString("Form");
            if (string2 != null && string2.equals("Appointment")) {
                if (this.isItRecurringAppointment(viewEntry)) {
                    int n = this.getIndexManager().getPreviousIndex(viewEntry);
                    return new LotusPimRecurringAppointmentItem(viewEntry, n, n, this.getLotusPimSession(), this.getRecycle());
                }
                return new LotusPimAppointmentItem(viewEntry, this.getLotusPimSession(), this.getRecycle());
            }
            return this.getPreviousAppointmentItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public int getCount() throws LotusPimException {
        try {
            return this.getLotusViewEntryCollection().getCount();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void delete() throws LotusPimException {
        try {
            this.getLotusViewEntryCollection().removeAll(true);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void sort(PimSortType pimSortType) throws LotusPimException {
    }

    public PimItem addItem() throws LotusPimException {
        return this.addMessageItem();
    }

    public PimItem getItem(int n) throws LotusPimException {
        return this.getMessageItem(n);
    }

    public PimItem getItem(String string) throws LotusPimException {
        return this.getMessageItem(string);
    }

    public PimItem getFirstItem() throws LotusPimException {
        return this.getFirstMessageItem();
    }

    public PimItem getLastItem() throws LotusPimException {
        return this.getLastMessageItem();
    }

    public PimItem getNextItem() throws LotusPimException {
        return this.getNextMessageItem();
    }

    public PimItem getPreviousItem() throws LotusPimException {
        return this.getPreviousMessageItem();
    }

    public PimMessageItem addMessageItem() throws LotusPimException {
        return this.addAppointmentItem();
    }

    public PimMessageItem getMessageItem(int n) throws LotusPimException {
        return this.getAppointmentItem(n);
    }

    public PimMessageItem getMessageItem(String string) throws LotusPimException {
        return this.getAppointmentItem(string);
    }

    public PimMessageItem getFirstMessageItem() throws LotusPimException {
        return this.getFirstAppointmentItem();
    }

    public PimMessageItem getLastMessageItem() throws LotusPimException {
        return this.getLastAppointmentItem();
    }

    public PimMessageItem getNextMessageItem() throws LotusPimException {
        return this.getNextAppointmentItem();
    }

    public PimMessageItem getPreviousMessageItem() throws LotusPimException {
        return this.getPreviousAppointmentItem();
    }

    private RecurringAppointmentDateIndexManager getIndexManager() {
        if (this.m_oRecurringAppointmentDateIndexManager == null) {
            this.m_oRecurringAppointmentDateIndexManager = new RecurringAppointmentDateIndexManager();
        }
        return this.m_oRecurringAppointmentDateIndexManager;
    }

    private DateTime getFilterStartDateTime() throws LotusPimException {
        try {
            return ((LotusPimAppointmentItemFilter)this.getAppointmentItemFilter()).getStartDateTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private DateTime getFilterEndDateTime() throws LotusPimException {
        try {
            return ((LotusPimAppointmentItemFilter)this.getAppointmentItemFilter()).getEndDateTime();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void clearHash() {
        this.getIndexManager().clearHash();
    }

    class RecurringAppointmentDateIndexManager {
        private HashMap mapOfNoteIdWithDateIndex = new HashMap();

        RecurringAppointmentDateIndexManager() {
        }

        private HashMap getHashMap() {
            return this.mapOfNoteIdWithDateIndex;
        }

        public void clearHash() {
            this.getHashMap().clear();
        }

        public int getFirstIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(0);
                    if (n < 0) {
                        n = 0;
                        vector.set(0, new Integer(n));
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getFirstIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        public int getNextIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(1);
                    int n2 = (Integer)vector.elementAt(0);
                    int n3 = (Integer)vector.elementAt(2);
                    if (++n < n2 || n > n3) {
                        n = n2;
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getNextIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        public int getPreviousIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(1);
                    int n2 = (Integer)vector.elementAt(0);
                    int n3 = (Integer)vector.elementAt(2);
                    if (--n < n2 || n > n3) {
                        n = n3;
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getPreviousIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        public int getLastIndex(ViewEntry viewEntry) throws LotusPimException {
            try {
                if (viewEntry == null) {
                    return 0;
                }
                String string = viewEntry.getNoteID();
                if (this.getHashMap().containsKey(string)) {
                    Vector vector = (Vector)this.getHashMap().get(string);
                    int n = (Integer)vector.elementAt(2);
                    if (n < 0) {
                        n = 0;
                    }
                    vector.set(1, new Integer(n));
                    return n;
                }
                this.insertNewEntryIntoHashMap(viewEntry);
                return this.getLastIndex(viewEntry);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }

        private void insertNewEntryIntoHashMap(ViewEntry viewEntry) throws LotusPimException {
            try {
                Document document = LotusPimAppointmentItems.this.getLotusDatabase().getDocumentByID(viewEntry.getNoteID());
                if (document == null) {
                    return;
                }
                LotusPimAppointmentItems.this.getRecycle().add(document);
                Vector vector = document.getItemValue("StartDateTime");
                Vector vector2 = document.getItemValue("EndDateTime");
                DateTime dateTime = LotusPimAppointmentItems.this.getFilterStartDateTime();
                DateTime dateTime2 = LotusPimAppointmentItems.this.getFilterEndDateTime();
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                while (n3 < vector.size()) {
                    DateTime dateTime3 = (DateTime)vector.elementAt(n3);
                    int n4 = dateTime3.timeDifference(dateTime);
                    if (n4 >= 0) {
                        n = n3;
                        break;
                    }
                    ++n3;
                }
                int n5 = vector2.size() - 1;
                while (n5 >= 0) {
                    DateTime dateTime4 = (DateTime)vector2.elementAt(n5);
                    int n6 = dateTime4.timeDifference(dateTime2);
                    if (n6 <= 0) {
                        n2 = n5;
                        break;
                    }
                    --n5;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                Vector<Integer> vector3 = new Vector<Integer>();
                vector3.add(0, new Integer(n));
                vector3.add(1, new Integer(-1));
                vector3.add(2, new Integer(n2));
                this.getHashMap().put(viewEntry.getNoteID(), vector3);
            }
            catch (Exception exception) {
                throw new LotusPimException(exception);
            }
        }
    }
}

