/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange.outlook;

import com.aligo.pim.PimBusyStatusType;
import com.aligo.pim.PimCalendarType;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.outlook.OutlookPimMessageItem;
import com.aligo.pim.exchange.outlook.OutlookPimRecipientItems;
import com.aligo.pim.exchange.outlook.OutlookPimRecurrencePatternItem;
import com.aligo.pim.exchange.outlook.OutlookPimReminderItem;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAppointmentItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import java.util.Date;
import outlook.Recipients;
import outlook.RecurrencePattern;
import outlook._AppointmentItem;

public class OutlookPimAppointmentItem
extends OutlookPimMessageItem
implements PimAppointmentItem {
    private OutlookPimRecipientItems m_oPimRecipientItems;
    private OutlookPimReminderItem m_oPimReminderItem;
    private PimCalendarType pimCalendarType = PimCalendarType.APPOINTMENT;
    Date oStartTime;
    Date oEndTime;
    private OutlookPimRecurrencePatternItem m_oPimRecurrencePatternItem;

    public OutlookPimAppointmentItem(Object _oAppointmentItem) {
        super(_oAppointmentItem);
    }

    public void setOutlookAppointmentItem(Object _oAppointmentItem) {
        this.setOutlookMessage(_oAppointmentItem);
    }

    public _AppointmentItem getOutlookAppointmentItem() {
        return (_AppointmentItem)this.getMessageObject();
    }

    public PimReminderItem getReminderItem() throws ExchangePimException {
        try {
            if (this.m_oPimReminderItem == null) {
                if (!this.getOutlookAppointmentItem().isReminderSet()) {
                    return null;
                }
                this.m_oPimReminderItem = new OutlookPimReminderItem(this);
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimReminderItem addReminderItem() throws ExchangePimException {
        try {
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new OutlookPimReminderItem(this);
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            throw new ExchangePimException(-2L);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws ExchangePimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                RecurrencePattern _oRecurrencePattern = this.getOutlookAppointmentItem().getRecurrencePattern();
                if (_oRecurrencePattern == null) {
                    return null;
                }
                this.m_oPimRecurrencePatternItem = new OutlookPimRecurrencePatternItem(_oRecurrencePattern, this);
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getSubject() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getSubject();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getID() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getEntryID();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimImportanceType getImportance() throws ExchangePimException {
        try {
            int importance = this.getOutlookAppointmentItem().getImportance();
            switch (importance) {
                case 0: {
                    return PimImportanceType.LOW;
                }
                case 1: {
                    return PimImportanceType.NORMAL;
                }
                case 2: {
                    return PimImportanceType.HIGH;
                }
            }
            return PimImportanceType.NORMAL;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getSender() throws ExchangePimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public int getDuration() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getDuration();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getLocation() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getLocation();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getText() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getBody();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getStartTime() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getStart();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getEndTime() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().getEnd();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean isAllDayEvent() throws ExchangePimException {
        try {
            return this.getOutlookAppointmentItem().isAllDayEvent();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setSubject(String subject) throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().setSubject(subject);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setBusyStatusType(PimBusyStatusType pimBusyStatusType) throws ExchangePimException {
    }

    public void setLocation(String location) throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().setLocation(location);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setImportance(PimImportanceType importance) throws ExchangePimException {
    }

    public void setText(String text) throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().setBody(text);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setStartTime(Date date) throws ExchangePimException {
        try {
            this.oStartTime = date;
            this.getOutlookAppointmentItem().setStart(date);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setEndTime(Date date) throws ExchangePimException {
        try {
            this.oEndTime = date;
            this.getOutlookAppointmentItem().setEnd(date);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().delete();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public PimAddressEntryItem getOrganizer() throws ExchangePimException {
        return this.getSender();
    }

    public void setAllDayEvent(boolean isAllDayEvent) throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().setAllDayEvent(isAllDayEvent);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void update() throws ExchangePimException {
        this.update(true, false);
        ((OutlookPimRecurrencePatternItem)this.getRecurrencePatternItem()).doExceptionDatesDeletion();
    }

    public void update(boolean makeItPermanent, boolean refreshObject) throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().save();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItems getRecipientItems() throws ExchangePimException {
        try {
            Recipients _oRecipients = this.getOutlookAppointmentItem().getRecipients();
            if (_oRecipients == null) {
                return null;
            }
            if (this.m_oPimRecipientItems == null) {
                this.m_oPimRecipientItems = new OutlookPimRecipientItems(_oRecipients);
            } else {
                this.m_oPimRecipientItems.setOutlookRecipients(_oRecipients);
            }
            return this.m_oPimRecipientItems;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void send() throws ExchangePimException {
        try {
            if (this.pimCalendarType.equals(PimCalendarType.MEETING) && this.m_oPimRecipientItems != null) {
                _AppointmentItem appointment = this.getOutlookAppointmentItem();
                appointment.setMeetingStatus(1);
                appointment.send();
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setType(PimCalendarType pimCalendarType) throws ExchangePimException {
        try {
            this.pimCalendarType = pimCalendarType;
            if (pimCalendarType.equals(PimCalendarType.MEETING)) {
                this.getOutlookAppointmentItem().setMeetingStatus(1);
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimCalendarType getType() throws ExchangePimException {
        return this.pimCalendarType;
    }

    public PimMessageItem forward() throws ExchangePimException {
        return null;
    }

    public String getName() throws ExchangePimException {
        return "Appointment: " + this.getSubject() + " in " + this.getLocation();
    }
}

