/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;

public class ModifyTrustAttributes
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext jSSContext) {
        StringTokenizer stringTokenizer;
        this.cntx = jSSContext;
        CertAdminUtil.println(CertAdminHelpText.getTrustHelpText());
        String string = CertAdminUtil.question(CertAdminLocale.getPFString("q18", "Enter the name of the certificate ?"));
        if (string.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m30", "Certificate name entered is not valid!"));
            return false;
        }
        if (!JSSUtil.certExist(jSSContext, string)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m31", "Specified certificate does not exist!"));
            return false;
        }
        String string2 = "CT,CT,c";
        String string3 = CertAdminUtil.question(CertAdminLocale.getPFString("q19", "Enter the trust attribute you want the certificate to have [") + string2 + CertAdminLocale.getPFString("q1", "]"));
        if (string3.trim().equals("")) {
            string3 = string2;
        }
        if ((stringTokenizer = new StringTokenizer(string3, ",")).countTokens() != 3) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m34", "Invalid trust attribute") + " " + string3 + " " + CertAdminLocale.getPFString("m35", "specified!"));
            return false;
        }
        CertAdminUtil.println(CertAdminConstants.newline);
        CertAdminUtil.println(CertAdminLocale.getPFString("m36", "specified!"));
        try {
            X509Certificate x509Certificate = JSSUtil.getCertByNickname(jSSContext, string);
            X509Certificate x509Certificate2 = JSSUtil.changeCertificateTrust(x509Certificate, stringTokenizer.nextToken().trim(), stringTokenizer.nextToken().trim(), stringTokenizer.nextToken().trim());
            jSSContext.getCryptoManager().importCertToPerm(x509Certificate2, string);
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m37", "Could not modify the trust attributes of the certificate!") + " " + string + " ");
            exception.printStackTrace();
            return false;
        }
        CertAdminUtil.println(CertAdminLocale.getPFString("m38", "Certificate trust attributes modified successfully "));
        return true;
    }
}

