/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.MaskingThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CertAdminUtil {
    static void showMenu() {
        CertAdminUtil.println(CertAdminLocale.getPFString("m7", "************************************************************************"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m71", "*********             Certificate Administration               *********"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m7", "************************************************************************"));
        CertAdminUtil.println();
        CertAdminUtil.println(CertAdminLocale.getPFString("m72", "1)  Generate Self-Signed Certificate"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m73", "2)  Generate Certificate Signing Request (CSR)"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m74", "3)  Add Root CA Certificate"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m75", "4)  Install Certificate From Certificate Authority (CA)"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m76", "5)  Delete Certificate"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m77", "6)  Modify Trust Attributes of Certificate (e.g., for PDC)"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m78", "7)  List Root CA Certificates"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m79", "8)  List All Certificates"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m711", "9)  Print Certificate content"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m712", "10) Quit"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m713", "----------------------------"));
        CertAdminUtil.print(CertAdminLocale.getPFString("m714", "choice: [10]"));
    }

    static int processMenuOption() {
        CertAdminUtil.println(CertAdminConstants.newline);
        CertAdminUtil.showMenu();
        String string = CertAdminUtil.readConsoleInput();
        int n = 99;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        while (!(string.equals("") || n >= 1 && n <= 10)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m8", "Invalid Option!"));
            CertAdminUtil.print(CertAdminLocale.getPFString("m714", "choice: [10]"));
            string = CertAdminUtil.readConsoleInput();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CertAdminUtil.println(CertAdminConstants.newline);
        return n;
    }

    static boolean yesno(String string) {
        String string2 = CertAdminUtil.question(string);
        return string2.equalsIgnoreCase("Y") || string2.equals("");
    }

    static String question(String string) {
        CertAdminUtil.print(string);
        return CertAdminUtil.readConsoleInput();
    }

    static String questionMasked(String string) {
        MaskingThread maskingThread = new MaskingThread(string);
        Thread thread = new Thread(maskingThread);
        thread.start();
        String string2 = CertAdminUtil.readConsoleInput();
        maskingThread.stopMasking();
        return string2;
    }

    static boolean fileExist(String string) {
        return new File(string).exists();
    }

    static String readLine(String string) {
        try {
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            return bufferedReader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean writeLine(String string, String string2, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2, bl);
            PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
            printWriter.print(string);
            printWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean writeLine(String string, String string2) {
        return CertAdminUtil.writeLine(string, string2, false);
    }

    static boolean delete(String string) {
        try {
            new File(string).delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean rename(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            file.renameTo(file2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean mkdir(String string) {
        try {
            File file = new File(string);
            return file.mkdir();
        }
        catch (Exception exception) {
            return false;
        }
    }

    static String[] list(String string) {
        try {
            File file = new File(string);
            if (!file.isDirectory()) {
                String[] stringArray = new String[]{string};
                return stringArray;
            }
            return file.list();
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    static void exitOnError() {
        CertAdminUtil.println(CertAdminLocale.getPFString("m45", "Usage: java certadmin <config-name> <basedir> <idsame-locale-dir>"));
        System.exit(0);
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void println() {
        CertAdminUtil.println("");
    }

    static void print(String string) {
        System.out.print(string);
    }

    static void print() {
        CertAdminUtil.print("");
    }

    static String readConsoleInput() {
        String string;
        try {
            string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (Exception exception) {
            string = "";
        }
        return string.trim();
    }

    static String getCurrentDateTime() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddyykkmmss");
        String string = simpleDateFormat.format(date);
        return string.trim();
    }
}

