/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.i18n.MIMEHelper;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import java.net.MalformedURLException;

public final class PageSpec {
    private final String inputString;
    private final DecoratedURI pageURI;
    private DecoratedURI baseURI;
    private String mime;
    private String encoding;
    private boolean valid;

    public PageSpec(String aBaseURI) {
        this(aBaseURI, null);
    }

    public PageSpec(String aBaseURI, String aMIMEType) {
        this(aBaseURI, aMIMEType, null);
    }

    public PageSpec(String aBaseURI, String aMIMEType, String aEncoding) {
        this.inputString = aBaseURI;
        this.mime = StringHelper.normalize(aMIMEType, "UNKNOWN");
        this.encoding = StringHelper.normalize(aEncoding, "UNKNOWN");
        this.setBase(aBaseURI);
        this.pageURI = this.baseURI;
    }

    public void setBase(String aBase) {
        this.valid = true;
        try {
            this.setBase(new DecoratedURI(aBase));
        }
        catch (MalformedURLException e) {
            this.valid = false;
        }
    }

    private void setBase(DecoratedURI aDecoratedURI) throws MalformedURLException {
        String bValue;
        this.baseURI = new DecoratedURI(aDecoratedURI.toNormalForm());
        if (!this.baseURI.isValid() && !this.baseURI.isAbsolute()) {
            throw new MalformedURLException("INVALID URI: Page URI Should be Absolute:" + aDecoratedURI.getInputString());
        }
        if (this.mime.equals("UNKNOWN")) {
            this.mime = MIMEHelper.guessContentTypeFromFileName(this.baseURI.getFileName());
        }
        if ((bValue = this.baseURI.getParameterValue("psScriptReferrer")) != null && bValue.length() != 0) {
            this.setBase(bValue);
        }
    }

    public String getInputString() {
        return this.inputString;
    }

    public DecoratedURI getPageURI() {
        return this.pageURI;
    }

    public DecoratedURI getBaseURI() {
        if (this.isValid()) {
            return this.baseURI;
        }
        return DecoratedURI.EMPTY_DECORATED_URI;
    }

    public String getMIME() {
        return this.mime;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "Page URI: " + this.getInputString() + ",\n" + (this.getBaseURI().getInputString().equalsIgnoreCase(this.getInputString()) ? "" : "Resolve URI: " + this.getBaseURI().toExternalForm() + ",\n") + "Content MIME: " + this.getMIME() + ",\n" + "Content Encoding: " + this.getEncoding() + ",\n";
    }
}

