/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.idsame.cli;

import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.rom.RuleSetManager;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.services.DataServiceFactory;
import com.sun.portal.rewriter.services.DataServiceHelper;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.clip.CLIHandler;
import com.sun.portal.rewriter.util.clip.CLIPException;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public final class RuleSetCLI
implements CLIHandler {
    private static final String SUB_COMMAND_LIST = "list";
    private static final String SUB_COMMAND_STORE = "store";
    private static final String SUB_COMMAND_GET = "get";
    private static final String SUB_COMMAND_REMOVE = "remove";
    private static final String OPTION_RULESET_ID = "rulesetid";
    private static final String OPTION_BIND_DN = "runasdn";
    private static final String OPTION_PASSWORD = "password";
    public RuleSetManager rulesetManager;

    private void doInit(Map aOptions) {
        String userName = ((String[])aOptions.get(OPTION_BIND_DN))[0];
        String password = ((String[])aOptions.get(OPTION_PASSWORD))[0];
        Properties props = DataServiceHelper.getDefaultIDSAMEProps();
        props.setProperty("USER_NAME", userName);
        props.setProperty("PASSWORD", password);
        try {
            this.rulesetManager = new RuleSetManager(DataServiceFactory.create(props));
        }
        catch (DataServiceException e) {
            if (e.getLocaleID() == 5001) {
                System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgAuthorizationFailed", new Object[]{userName}));
                System.exit(0);
            }
            throw e;
        }
    }

    private Object doList(String[] aOperands, Map aOptions) {
        String[] listOfRules = this.rulesetManager.getRuleSetNames().toArray(Constants.EMPTY_STRING_ARRAY);
        if (listOfRules.length == 0) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgNoRulesPresent"));
        } else {
            int i = 0;
            while (i < listOfRules.length) {
                System.out.println(listOfRules[i]);
                ++i;
            }
        }
        return listOfRules;
    }

    private Object doStore(String[] aOperands, Map aOptions) {
        String xmlString = Resource.readXML(aOperands[0]);
        if (xmlString.trim().length() == 0) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgFileDoesNotExist", new Object[]{aOperands[0]}));
        } else {
            try {
                String matchID = this.rulesetManager.matchesWithID(xmlString);
                if (matchID == null) {
                    String result = this.rulesetManager.store(xmlString);
                    System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgSuccess"));
                    return result;
                }
                System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgRuleSetIDConsumed", new Object[]{matchID}));
            }
            catch (InvalidXMLException e) {
                System.err.println(e.getCause());
            }
        }
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgFailure"));
        return null;
    }

    private Object doGet(String[] aOperands, Map aOptions) {
        String ruleSetID = ((String[])aOptions.get(OPTION_RULESET_ID))[0];
        String xmlString = this.rulesetManager.retrieve(ruleSetID);
        if (xmlString == null) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgMissingRuleSet", new Object[]{ruleSetID}));
            return xmlString;
        }
        if (aOperands.length == 0) {
            System.out.println(xmlString);
            return xmlString;
        }
        String fileName = aOperands[0];
        if (Resource.saveXML(fileName, xmlString)) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgSuccess"));
            return xmlString;
        }
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgCouldNotSave2File", new Object[]{fileName}));
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgFailure"));
        return xmlString;
    }

    private Object doRemove(String[] aOperands, Map aOptions) {
        String result = null;
        String lRuleSetID = ((String[])aOptions.get(OPTION_RULESET_ID))[0].trim();
        result = this.rulesetManager.delete(lRuleSetID);
        if (result != null) {
            System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgSuccess"));
            return result;
        }
        System.out.println(CLIPSpec.getLocaleHelper().getLocalizedString("msgMissingRuleSet", new Object[]{lRuleSetID}));
        return result;
    }

    public Object executeCommand(CLIPSpec aCLIPSpec, String[] args) {
        try {
            CLIPParser lCLIPParser = aCLIPSpec.getCLIPParser();
            Map lOptions = Collections.unmodifiableMap(lCLIPParser.getOptions(args));
            String[] lOperands = lCLIPParser.getOperands(args);
            this.doInit(lOptions);
            String lCommand = lCLIPParser.getSubCommand(args);
            if (lCommand.equals(SUB_COMMAND_LIST)) {
                return this.doList(lOperands, lOptions);
            }
            if (lCommand.equals(SUB_COMMAND_STORE)) {
                return this.doStore(lOperands, lOptions);
            }
            if (lCommand.equals(SUB_COMMAND_GET)) {
                return this.doGet(lOperands, lOptions);
            }
            if (lCommand.equals(SUB_COMMAND_REMOVE)) {
                return this.doRemove(lOperands, lOptions);
            }
        }
        catch (CLIPException e) {
            System.err.println(e);
        }
        return null;
    }
}

