/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.ids;

import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.services.ids.DataSource;
import com.sun.portal.rewriter.services.ids.IDSRuleSetBuilder;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;

public final class IDSDataService
implements DataService {
    private static final String TESTS_DATA_SOURCE_CLASS = "com.sun.portal.rewriter.services.ids.test.MockIDSDataSource";
    private static final String IDS_DATA_SOURCE_CLASS = "com.sun.portal.rewriter.services.ids.IDSDataSource";
    private DataSource dataSource;

    public IDSDataService(Properties aProps) {
        String type = aProps.getProperty("DATA_SOURCE_TYPE", "test");
        String implClass = IDS_DATA_SOURCE_CLASS;
        if ("test".equals(type)) {
            implClass = TESTS_DATA_SOURCE_CLASS;
        }
        try {
            this.dataSource = (DataSource)Class.forName(implClass).newInstance();
        }
        catch (Exception e) {
            ConfigManager.componentPanic("Unable to Load IDSDataService class, check the build.xml file\n", e);
        }
    }

    public String storeXML(String aRuleSetIDKey, String aXMLRuleSet) throws DataServiceException, UnsupportedOperationException {
        throw new UnsupportedOperationException("\"storeXML\" is not supported in IDS");
    }

    public String deleteKey(String aRuleSetID) throws DataServiceException, UnsupportedOperationException {
        throw new UnsupportedOperationException("\"deleteKey\" is not supported in IDS");
    }

    public String retrieveXML(String aRuleSetIDKey) throws DataServiceException {
        try {
            return IDSRuleSetBuilder.createRuleSet(this.dataSource).toXML();
        }
        catch (InvalidXMLException e) {
            Debug.error("This Exception should never come IDSDataService as ID is hardcode to small case", e);
            return null;
        }
    }

    public Set retrieveKeys() throws DataServiceException {
        return null;
    }

    public Observable getChangeNotifier() {
        return new Observable();
    }

    public String matchesWithID(String aKey) throws DataServiceException {
        return null;
    }

    public static void main(String[] args) throws DataServiceException {
        Debug.println(new IDSDataService(new Properties()).retrieveXML(null));
    }
}

