/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.common.logging.impl.LoggerImpl;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portletcontainercommon.PortletPreferencesUtility;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletInfoDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletsDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PreferenceDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityRoleRefDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SupportsDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDProviderEntryGenerator {
    public static final String PortletWindowClassName = "com.sun.portal.providers.portletwindow.PortletWindowProvider";
    public static final String[][] defaultProperties = new String[][]{{"width", "thick"}, {"fontFace1", "Sans-serif"}, {"productName", "Sun ONE Portal Server"}};
    public static final String[][] advancedProperties = new String[][]{{"refreshTime", "0"}, {"editType", "edit_complete"}, {"contentPage", "PortletHelp.jsp"}, {"editPage", "PortletEdit.jsp"}, {"processPage", ""}};
    public static final String mimeType = "text/html";
    private static final String PORTLET_PREFIX = "__Portlet__";
    private static final String PREF_PROPS_NAME = "__Portlet__PreferenceProperties";
    private static final String ADDL_PREF_NAME = "__Portlet__AdditionalPreferences";
    private static final String DOT_SEPARATOR = ".";
    private static final String CONTENT_TYPE_NAME = "supportedContentTypes";
    private static final String IS_EDITABLE_COLLECTION = "isEditableByMimeType";
    private static final String HAS_HELP_COLLECTION = "hasHelpByMimeType";
    private static final String ROLE_MAP_NAME = "roleMap";
    private static final String UI_MAP_NAME = "userInfoMap";
    private static final String NAME_STRING = "name";
    private static final String VALUE_STRING = "value";
    private static final String ADVANCED_STRING = "advanced";
    private static final String CLASS_STRING = "class";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String HELP_URL = "helpURL";
    private PortletsDescriptor psd = null;
    private PortletAppDescriptor pad = null;
    private String portletAppName = null;
    private Properties configProps = null;

    public PDProviderEntryGenerator(InputStream in, InputStream extStream, Properties props, String appName) throws PortletDeployerException {
        this.configProps = props;
        String DDSchemaLocation = System.getProperty(DeploymentDescriptorReader.PORTLET_SCHEMA_LOCATION);
        DeploymentDescriptorReader ddReader = new DeploymentDescriptorReader(this.getLogger(), DDSchemaLocation);
        String validateProp = this.configProps.getProperty("validate_schema");
        try {
            if (validateProp != null && validateProp.toLowerCase().equals(TRUE)) {
                System.setProperty("validate_schema", TRUE);
            }
            this.pad = ddReader.loadPortletAppDescriptor(in, extStream);
        }
        catch (DeploymentDescriptorException dde) {
            Object[] tokens = new Object[]{dde.toString()};
            throw new PortletDeployerException("errorReadingPortletDD", tokens);
        }
        this.portletAppName = appName;
        this.psd = this.pad.getPortletsDescriptor();
    }

    public String getPortletAppName() {
        return this.portletAppName;
    }

    public List createProviderElements(Properties roleProps, Properties uiProps, List webAppRoles) throws PortletDeployerException {
        ArrayList<Element> providerElements = new ArrayList<Element>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{ex.toString()};
            throw new PortletDeployerException("errorDocumentBuilder", tokens);
        }
        Document d = null;
        try {
            d = db.newDocument();
        }
        catch (Exception e) {
            Object[] tokens = new Object[]{e.toString()};
            throw new PortletDeployerException("errorNewDocument", tokens);
        }
        List portletDescriptors = this.psd.getPortletDescriptors();
        int i = 0;
        while (i < portletDescriptors.size()) {
            Object[] tokens;
            Object[] tokens2;
            PortletDescriptor pd = (PortletDescriptor)portletDescriptors.get(i);
            String portletName = pd.getPortletName();
            String providerName = PORTLET_PREFIX + this.portletAppName + DOT_SEPARATOR + portletName;
            String entityIDPrefix = this.portletAppName + "|" + portletName;
            PortletInfoDescriptor pInfo = pd.getPortletInfoDescriptor();
            String title = portletName;
            if (pInfo != null) {
                title = pInfo.getTitle();
            }
            String description = "";
            if (pd.getDescription() != null) {
                description = pd.getDescription();
            }
            String isEditable = FALSE;
            String helpUrl = "";
            List supportedPortletModes = pd.getSupportedPortletModes(mimeType);
            if (supportedPortletModes != null) {
                int k = 0;
                while (k < supportedPortletModes.size()) {
                    String mode = (String)supportedPortletModes.get(k);
                    if (mode.equalsIgnoreCase("EDIT")) {
                        isEditable = TRUE;
                    } else if (mode.equalsIgnoreCase("HELP")) {
                        helpUrl = HELP_URL;
                    }
                    ++k;
                }
            }
            boolean sessionEnabled = pd.sessionEnabled();
            boolean allowSavePref = this.pad.isSavePreferencesAllowed();
            Element propertiesElement = null;
            try {
                propertiesElement = d.createElement("Properties");
                propertiesElement = this.addDefaultProperties(propertiesElement, d);
                propertiesElement.appendChild(this.createPropertyElement("String", d, "title", title, FALSE));
                propertiesElement.appendChild(this.createPropertyElement("String", d, "description", description, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("String", d, "entityIDPrefix", entityIDPrefix, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "isEditable", isEditable, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "showExceptions", FALSE, FALSE));
                propertiesElement.appendChild(this.createPropertyElement("String", d, HELP_URL, helpUrl, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "sessionEnabled", new Boolean(sessionEnabled).toString(), TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "allowSavePref", new Boolean(allowSavePref).toString(), TRUE));
                Element emptyPref = d.createElement("Collection");
                emptyPref.setAttribute(NAME_STRING, ADDL_PREF_NAME);
                emptyPref.setAttribute(ADVANCED_STRING, TRUE);
                propertiesElement.appendChild(emptyPref);
            }
            catch (DOMException de) {
                Object[] tokens3 = new Object[]{de.toString()};
                throw new PortletDeployerException("errorCreatePropertiesElement", tokens3);
            }
            PortletPreferencesDescriptor ppd = pd.getPortletPreferencesDescriptor();
            List preferenceDescriptors = null;
            if (ppd != null) {
                preferenceDescriptors = ppd.getPreferenceDescriptors();
            }
            try {
                Element prefPropsElement = d.createElement("Collection");
                prefPropsElement.setAttribute(NAME_STRING, PREF_PROPS_NAME);
                Element defaultElement = d.createElement("Collection");
                defaultElement.setAttribute(NAME_STRING, "default");
                Element isReadOnlyElement = d.createElement("Collection");
                isReadOnlyElement.setAttribute(NAME_STRING, "isReadOnly");
                if (preferenceDescriptors != null && !preferenceDescriptors.isEmpty()) {
                    int j = 0;
                    while (j < preferenceDescriptors.size()) {
                        PreferenceDescriptor prd = (PreferenceDescriptor)preferenceDescriptors.get(j);
                        String name = prd.getPrefName();
                        List values = prd.getPrefValues();
                        String value = PortletPreferencesUtility.getPreferenceString((List)values);
                        defaultElement.appendChild(this.createPropertyElement("String", d, name, value, FALSE));
                        String isReadOnly = String.valueOf(prd.getReadOnly());
                        isReadOnlyElement.appendChild(this.createPropertyElement("Boolean", d, name, isReadOnly, FALSE));
                        propertiesElement.appendChild(this.createPropertyElement("String", d, PORTLET_PREFIX + name, value, FALSE));
                        ++j;
                    }
                }
                prefPropsElement.appendChild(defaultElement);
                prefPropsElement.appendChild(isReadOnlyElement);
                propertiesElement.appendChild(prefPropsElement);
            }
            catch (DOMException de) {
                Object[] tokens4 = new Object[]{de.toString()};
                throw new PortletDeployerException("errorCreatePreferenceElement", tokens4);
            }
            List supportDescriptors = pd.getSupportsDescriptors();
            if (!supportDescriptors.isEmpty()) {
                try {
                    Element contentTypeElement = d.createElement("Collection");
                    contentTypeElement.setAttribute(NAME_STRING, CONTENT_TYPE_NAME);
                    contentTypeElement.setAttribute(ADVANCED_STRING, TRUE);
                    Element isEditableCollection = d.createElement("Collection");
                    isEditableCollection.setAttribute(NAME_STRING, IS_EDITABLE_COLLECTION);
                    isEditableCollection.setAttribute(ADVANCED_STRING, TRUE);
                    Element hasHelpCollection = d.createElement("Collection");
                    hasHelpCollection.setAttribute(NAME_STRING, HAS_HELP_COLLECTION);
                    hasHelpCollection.setAttribute(ADVANCED_STRING, TRUE);
                    int j = 0;
                    while (j < supportDescriptors.size()) {
                        SupportsDescriptor sd = (SupportsDescriptor)supportDescriptors.get(j);
                        String contentType = sd.getMimeType();
                        Element property = d.createElement("String");
                        property.setAttribute(VALUE_STRING, contentType);
                        contentTypeElement.appendChild(property);
                        String editable = FALSE;
                        String helpLink = "";
                        List supportedModes = pd.getSupportedPortletModes(contentType);
                        if (supportedModes != null) {
                            int k = 0;
                            while (k < supportedModes.size()) {
                                String mode = (String)supportedModes.get(k);
                                if (mode.equalsIgnoreCase("EDIT")) {
                                    editable = TRUE;
                                } else if (mode.equalsIgnoreCase("HELP")) {
                                    helpLink = HELP_URL;
                                }
                                ++k;
                            }
                        }
                        Element editableElement = d.createElement("Boolean");
                        editableElement.setAttribute(NAME_STRING, contentType);
                        editableElement.setAttribute(VALUE_STRING, editable);
                        isEditableCollection.appendChild(editableElement);
                        Element helpElement = d.createElement("String");
                        helpElement.setAttribute(NAME_STRING, contentType);
                        helpElement.setAttribute(VALUE_STRING, helpLink);
                        hasHelpCollection.appendChild(helpElement);
                        ++j;
                    }
                    propertiesElement.appendChild(contentTypeElement);
                    propertiesElement.appendChild(isEditableCollection);
                    propertiesElement.appendChild(hasHelpCollection);
                }
                catch (DOMException de) {
                    Object[] tokens5 = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreatecontentTypeElement", tokens5);
                }
            }
            Collection roleValues = ((Hashtable)roleProps).values();
            List securityRoleRefDescriptors = pd.getSecurityRoleRefDescriptors();
            int k = 0;
            while (k < securityRoleRefDescriptors.size()) {
                SecurityRoleRefDescriptor srd = (SecurityRoleRefDescriptor)securityRoleRefDescriptors.get(k);
                String roleLink = srd.getRoleLink();
                String portletRole = srd.getRoleName();
                if (webAppRoles.contains(roleLink)) {
                    if (!roleValues.contains(roleLink)) {
                        tokens2 = new Object[]{roleLink};
                        throw new PortletDeployerException("errorRoleMapping", tokens2);
                    }
                } else if (webAppRoles.contains(portletRole)) {
                    if (!roleValues.contains(portletRole)) {
                        tokens2 = new Object[]{portletRole};
                        throw new PortletDeployerException("errorRoleMapping", tokens2);
                    }
                } else {
                    tokens2 = new Object[]{portletRole};
                    throw new PortletDeployerException("errorRoleValidation", tokens2);
                }
                ++k;
            }
            Set roleKeys = ((Hashtable)roleProps).keySet();
            if (!roleKeys.isEmpty()) {
                try {
                    Element roleMapElement = d.createElement("Collection");
                    roleMapElement.setAttribute(NAME_STRING, ROLE_MAP_NAME);
                    roleMapElement.setAttribute(ADVANCED_STRING, TRUE);
                    Iterator j = roleKeys.iterator();
                    while (j.hasNext()) {
                        String key = (String)j.next();
                        String value = roleProps.getProperty(key);
                        roleMapElement.appendChild(this.createPropertyElement("String", d, key, value, FALSE));
                    }
                    propertiesElement.appendChild(roleMapElement);
                }
                catch (DOMException de) {
                    tokens = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreateRoleMapElement", tokens);
                }
            }
            if (!((Hashtable)uiProps).isEmpty()) {
                try {
                    Element uiMapElement = d.createElement("Collection");
                    uiMapElement.setAttribute(NAME_STRING, UI_MAP_NAME);
                    uiMapElement.setAttribute(ADVANCED_STRING, TRUE);
                    Set keys = ((Hashtable)uiProps).keySet();
                    Iterator j = keys.iterator();
                    while (j.hasNext()) {
                        String key = (String)j.next();
                        String value = uiProps.getProperty(key);
                        uiMapElement.appendChild(this.createPropertyElement("String", d, key, value, FALSE));
                    }
                    propertiesElement.appendChild(uiMapElement);
                }
                catch (DOMException de) {
                    tokens = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreateUIMapElement", tokens);
                }
            }
            Element providerElement = null;
            try {
                providerElement = d.createElement("Provider");
            }
            catch (DOMException de) {
                tokens2 = new Object[]{de.toString()};
                throw new PortletDeployerException("errorCreateProviderElement", tokens2);
            }
            providerElement.setAttribute(NAME_STRING, providerName);
            providerElement.setAttribute(CLASS_STRING, PortletWindowClassName);
            providerElement.appendChild(propertiesElement);
            providerElements.add(providerElement);
            ++i;
        }
        return providerElements;
    }

    public List getProviderNames() {
        ArrayList<String> providerNames = new ArrayList<String>();
        List portletNames = this.psd.getPortletNames();
        int i = 0;
        while (i < portletNames.size()) {
            String portletName = (String)portletNames.get(i);
            String providerName = PORTLET_PREFIX + this.portletAppName + DOT_SEPARATOR + portletName;
            providerNames.add(providerName);
            ++i;
        }
        return providerNames;
    }

    private Element addDefaultProperties(Element propertiesElement, Document d) throws DOMException {
        int i = 0;
        while (i < defaultProperties.length) {
            Element property = this.createPropertyElement("String", d, defaultProperties[i][0], defaultProperties[i][1], FALSE);
            propertiesElement.appendChild(property);
            ++i;
        }
        int i2 = 0;
        while (i2 < advancedProperties.length) {
            Element property = this.createPropertyElement("String", d, advancedProperties[i2][0], advancedProperties[i2][1], TRUE);
            propertiesElement.appendChild(property);
            ++i2;
        }
        return propertiesElement;
    }

    private Element createPropertyElement(String tagname, Document d, String name, String value, String advanced) throws DOMException {
        Element property = d.createElement(tagname);
        property.setAttribute(NAME_STRING, name);
        property.setAttribute(VALUE_STRING, value);
        if (advanced.equals(TRUE)) {
            property.setAttribute(ADVANCED_STRING, advanced);
        }
        return property;
    }

    public Logger getLogger() {
        LoggerImpl logger = new LoggerImpl();
        logger.init("PortletSample", this.configProps);
        return logger;
    }
}

