/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.SessionKeepAlive;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetletGroupManager {
    private static Hashtable userNetlets = new Hashtable();
    private static NetletGroupManager manager = null;
    private static SessionKeepAlive ska = null;

    private NetletGroupManager() {
    }

    public static NetletGroupManager getNetletGroupManager() {
        if (manager == null) {
            manager = new NetletGroupManager();
        }
        return manager;
    }

    public static synchronized void registerReaderWriter(ReaderWriterLock readerWriterLock, SSOToken sSOToken) throws SSOException {
        String string = sSOToken.getTokenID().toString();
        NetletGroupManager.init(sSOToken);
        NetletGroup netletGroup = (NetletGroup)userNetlets.get(string);
        if (netletGroup == null) {
            netletGroup = new NetletGroup(manager, sSOToken);
        }
        netletGroup.add(readerWriterLock);
        userNetlets.put(string, netletGroup);
    }

    public static synchronized void registerReaderWriter(ReaderWriterLock readerWriterLock, SSOTokenID sSOTokenID) throws SSOException {
        String string = sSOTokenID.toString();
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        SSOToken sSOToken = sSOTokenManager.createSSOToken(string);
        NetletGroupManager.init(sSOToken);
        NetletGroup netletGroup = (NetletGroup)userNetlets.get(string);
        if (netletGroup == null) {
            netletGroup = new NetletGroup(manager, sSOToken);
        }
        netletGroup.add(readerWriterLock);
        userNetlets.put(string, netletGroup);
    }

    public static synchronized void registerReaderWriter(ReaderWriterLock readerWriterLock, String string) throws SSOException {
        SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
        SSOToken sSOToken = sSOTokenManager.createSSOToken(string);
        NetletGroupManager.init(sSOToken);
        NetletGroup netletGroup = (NetletGroup)userNetlets.get(string);
        if (netletGroup == null) {
            netletGroup = new NetletGroup(manager, sSOToken);
        }
        netletGroup.add(readerWriterLock);
        userNetlets.put(string, netletGroup);
    }

    public static synchronized void unregister(SSOToken sSOToken) {
        String string = sSOToken.getTokenID().toString();
        NetletGroupManager.clean(string);
        userNetlets.remove(string);
    }

    public static synchronized void unregister(SSOTokenID sSOTokenID) {
        String string = sSOTokenID.toString();
        NetletGroupManager.clean(string);
        userNetlets.remove(string);
    }

    public static synchronized void unregister(String string) {
        NetletGroupManager.clean(string);
        userNetlets.remove(string);
    }

    public static synchronized void clean(String string) {
        NetletGroup netletGroup = (NetletGroup)userNetlets.get(string);
        netletGroup.clean();
    }

    public static synchronized String[] getRegisteredSessions() {
        Enumeration enumeration = userNetlets.keys();
        int n = 0;
        String[] stringArray = new String[userNetlets.size()];
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static synchronized NetletGroup getNetletGroup(String string) {
        return (NetletGroup)userNetlets.get(string);
    }

    private static void init(SSOToken sSOToken) {
        block5: {
            if (ska == null) {
                try {
                    ska = new SessionKeepAlive(manager, sSOToken.getMaxIdleTime());
                    GWThreadPool.run(ska);
                }
                catch (InterruptedException interruptedException) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Unable to start Session Keep Alive Thread from Netlet Group manager", interruptedException);
                    }
                }
                catch (SSOException sSOException) {
                    if (!GWDebug.debug.errorEnabled()) break block5;
                    GWDebug.debug.error("Unable to start Session Keep Alive Thread from Netlet Group manager", sSOException);
                }
            }
        }
    }
}

