/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class DeploymentDescriptorReader {
    public static String PORTLET_SCHEMA_LOCATION = "DDSchemaLocation";
    public static String PORTLET_SCHEMA_FILE = "/portlet.xsd";
    public static String SUN_PORTLET_SCHEMA_FILE = "/sun-portlet.xsd";
    public static String PORTLET_NAMESPACE = "http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd";
    public static String SUN_PORTAL_NAMESPACE = "http://www.sun.com/software/xml/ns/portal_server";
    public static String BUILDER_SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    public static String BUILDER_VALIDATION_SCHEMA_FEATURE = "http://apache.org/xml/features/validation/schema";
    public static String BUILDER_SCHEMA_LOC_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String VALIDATE_SCHEMA = "validate_schema";
    private Logger _logger;
    private String _portletSchemaLocation;

    public DeploymentDescriptorReader(Logger logger, String schemaLocation) {
        this._logger = logger;
        this._portletSchemaLocation = schemaLocation;
        this._logger.log(Level.SEVERE, "DeploymentDescriptorReader, schema location:" + schemaLocation);
    }

    private Element readDeploymentDescriptor(InputStream portletStream, String schemaLocation) throws DeploymentDescriptorException {
        SAXBuilder builder = null;
        String validateString = System.getProperty(VALIDATE_SCHEMA);
        if (validateString != null && validateString.equalsIgnoreCase("true")) {
            builder = new SAXBuilder(BUILDER_SAX_PARSER, true);
            builder.setFeature(BUILDER_VALIDATION_SCHEMA_FEATURE, true);
            builder.setProperty(BUILDER_SCHEMA_LOC_PROPERTY, (Object)schemaLocation);
            this._logger.log(Level.INFO, "DeploymentDescriptorReader.readDeploymentDescriptor, validate_schema:" + validateString);
        } else {
            builder = new SAXBuilder();
        }
        Element element = null;
        try {
            Document doc = builder.build(portletStream);
            element = doc.getRootElement();
        }
        catch (JDOMException je) {
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, "DeploymentDescriptorReader.readDeploymentDescriptor, can not read depoloyment descriptor", (Throwable)je);
            }
            throw new DeploymentDescriptorException("Can not read deployment descriptor", je);
        }
        this._logger.log(Level.INFO, "DeploymentDescriptorReader.readDeploymentDescriptor, root element: " + element);
        return element;
    }

    public PortletAppDescriptor loadPortletAppDescriptor(InputStream portletStream, InputStream extStream) throws DeploymentDescriptorException {
        Element root;
        PortletAppDescriptor appDescriptor = null;
        if (portletStream != null && (root = this.readDeploymentDescriptor(portletStream, PORTLET_NAMESPACE + " " + this._portletSchemaLocation + PORTLET_SCHEMA_FILE)) != null) {
            Namespace namespace = Namespace.getNamespace((String)PORTLET_NAMESPACE);
            appDescriptor = new PortletAppDescriptor(this._logger, extStream);
            appDescriptor.load(root, namespace, this);
        }
        return appDescriptor;
    }

    public DeploymentExtensionDescriptor loadDeploymentExtensionDescriptor(InputStream extStream) throws DeploymentDescriptorException {
        Element root;
        DeploymentExtensionDescriptor exDescriptor = null;
        if (extStream != null && (root = this.readDeploymentDescriptor(extStream, SUN_PORTAL_NAMESPACE + " " + this._portletSchemaLocation + SUN_PORTLET_SCHEMA_FILE)) != null) {
            Namespace namespace = Namespace.getNamespace((String)SUN_PORTAL_NAMESPACE);
            exDescriptor = new DeploymentExtensionDescriptor(this._logger);
            exDescriptor.load(root, namespace);
        }
        return exDescriptor;
    }
}

