/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.uri;

import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import java.net.MalformedURLException;

public class SRAPGatewayURI
extends DecoratedURI {
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private String reverseProxyForm = null;
    private SRAPGatewayURI httpURI;
    private SRAPGatewayURI httpsURI;

    public SRAPGatewayURI(String string) throws MalformedURLException {
        super(string);
    }

    public SRAPGatewayURI makeProtocolConsistantURI(DecoratedURI decoratedURI) {
        try {
            if (this.httpsURI == null) {
                this.assignObjectVars();
            }
            if (this.httpsURI != null) {
                if (this.httpsURI.getProtocol().equalsIgnoreCase(decoratedURI.getProtocol())) {
                    return this.httpsURI;
                }
                if (this.httpURI.getProtocol().equalsIgnoreCase(decoratedURI.getProtocol())) {
                    return this.httpURI;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return this;
    }

    public SRAPGatewayURI decideGatewayURI(DecoratedURI decoratedURI) {
        if (SRAPConfigManager.isUseConsistantProtocol4Gateway()) {
            return this.makeProtocolConsistantURI(decoratedURI);
        }
        return this;
    }

    public final String toReverseProxyForm() {
        if (this.reverseProxyForm == null) {
            this.reverseProxyForm = this.getFullFileURI();
            if (this.reverseProxyForm.endsWith("/")) {
                this.reverseProxyForm = this.reverseProxyForm.substring(0, this.reverseProxyForm.length() - 1);
            }
        }
        return this.reverseProxyForm;
    }

    private void assignObjectVars() throws MalformedURLException {
        if (this.getProtocol().equalsIgnoreCase(HTTP_PROTOCOL)) {
            this.httpURI = this;
            this.httpsURI = new SRAPGatewayURI("https://" + this.getUserInfo() + this.getHost() + SRAPConfigManager.getHTTPSPort() + this.getPath() + this.getQuery() + this.getReference());
        } else if (this.getProtocol().equalsIgnoreCase(HTTPS_PROTOCOL)) {
            this.httpsURI = this;
            this.httpURI = new SRAPGatewayURI("http://" + this.getUserInfo() + this.getHost() + SRAPConfigManager.getHTTPPort() + this.getPath() + this.getQuery() + this.getReference());
        }
    }
}

