/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.config;

import com.iplanet.am.util.Debug;
import com.sun.ssoadapter.config.ClientAwareAppContext;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.DSAMEConnection;
import com.sun.ssoadapter.config.DSAMEConstants;
import com.sun.ssoadapter.config.DSAMEUtils;
import com.sun.ssoadapter.config.SAALException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PSClientAwareUserContext
implements ClientAwareUserContext,
DSAMEConstants {
    private static Debug debug = DSAMEConnection.debug;
    private String thisClassName = null;
    private DSAMEConnection dsameConn = null;
    private DSAMEUtils dsameUtils = null;
    private String sessClientType = null;
    private String charset = null;
    private ClientAwareAppContext caAppContext = null;

    public synchronized void init(HttpServletRequest req, ClientAwareAppContext appContext) throws IllegalStateException, SAALException {
        this.thisClassName = this.getClass().getName();
        this.caAppContext = appContext;
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":init()");
        }
        if (!this.caAppContext.validateSession(req)) {
            if (debug.messageEnabled()) {
                debug.message("Session not valid");
            }
            throw new IllegalStateException("Session Invalid:");
        }
        this.sessClientType = this.caAppContext.getClientType(req);
        this.dsameConn = new DSAMEConnection(req);
        this.dsameUtils = DSAMEUtils.getInstance();
        if (this.dsameUtils == null) {
            throw new SAALException(this.thisClassName + ": DSAMEUtils not Initialized");
        }
    }

    public void store() {
    }

    public String getStringAttribute(Map service, String attrName) throws IllegalStateException, IOException {
        return this.getStringAttribute(service, this.getClientType(), attrName);
    }

    public String getStringAttribute(Map service, String client, String attrName) throws IllegalStateException, IOException {
        String val = null;
        Set vals = this.getAttribute(service, client, attrName);
        if (vals != null && vals.size() > 0) {
            Iterator iter = vals.iterator();
            val = (String)iter.next();
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":getStringAttribute(): AttrName = " + attrName + " :: Val = " + val);
        }
        return val;
    }

    public Set getAttribute(Map service, String attrName) throws IllegalStateException, IOException {
        return this.getAttribute(service, this.getClientType(), attrName);
    }

    public Set getAttribute(Map service, String client, String attrName) throws IllegalStateException, IOException {
        String serviceName = this.dsameUtils.getServiceName(service);
        return this.getAttribute(serviceName, client, attrName, true, null, 0, 0);
    }

    private Set getAttribute(String serviceName, String client, String attrName, boolean removeClientInfo, Map awareMap, int scope, int type) throws IllegalStateException, IOException {
        Set vals = null;
        Set retVals = null;
        scope = scope != 0 ? scope : this.dsameUtils.getAttributeScope(serviceName, attrName);
        switch (scope) {
            case 5: {
                vals = this.dsameConn.getGlobalAttribute(serviceName, attrName);
                break;
            }
            case 6: {
                vals = this.dsameConn.getOrganizationAttribute(serviceName, attrName);
                break;
            }
            case 7: {
                break;
            }
            default: {
                vals = this.dsameConn.getAttribute(attrName);
            }
        }
        type = type != 0 ? type : this.dsameUtils.getAttributeType(serviceName, attrName);
        switch (type) {
            case 1: {
                retVals = vals;
                break;
            }
            case 3: {
                retVals = this.dsameUtils.getClientValues(vals, client, awareMap, removeClientInfo);
                break;
            }
            default: {
                retVals = vals;
            }
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":getAttribute(): AttrName = " + attrName + " :: Vals = " + retVals);
        }
        return retVals;
    }

    public void setStringAttribute(Map service, String attrName, String val) throws IllegalStateException, MissingResourceException, IOException {
        this.setStringAttribute(service, this.getClientType(), attrName, val, false);
    }

    public void setStringAttribute(Map service, String attrName, String val, boolean forceCA) throws IllegalStateException, MissingResourceException, IOException {
        this.setStringAttribute(service, this.getClientType(), attrName, val, forceCA);
    }

    public void setStringAttribute(Map service, String client, String attrName, String val) throws IllegalStateException, MissingResourceException, IOException {
        this.setStringAttribute(service, client, attrName, val, true);
    }

    private void setStringAttribute(Map service, String client, String attrName, String val, boolean forceClientAwareness) throws IllegalStateException, MissingResourceException, IOException {
        HashSet<String> vals = new HashSet<String>();
        vals.add(val);
        this.setAttribute(service, client, attrName, vals, forceClientAwareness);
    }

    public void setAttribute(Map service, String attrName, Set vals) throws IllegalStateException, MissingResourceException, IOException {
        this.setAttribute(service, this.getClientType(), attrName, vals, false);
    }

    public void setAttribute(Map service, String attrName, Set vals, boolean forceClientAwareness) throws IllegalStateException, MissingResourceException, IOException {
        this.setAttribute(service, this.getClientType(), attrName, vals, forceClientAwareness);
    }

    public void setAttribute(Map service, String client, String attrName, Set vals) throws IllegalStateException, MissingResourceException, IOException {
        this.setAttribute(service, client, attrName, vals, true);
    }

    private void setAttribute(Map service, String client, String attrName, Set vals, boolean forceCA) throws IllegalStateException, MissingResourceException, IOException {
        String serviceName = this.dsameUtils.getServiceName(service);
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ".setAttribute():: Service: " + serviceName + " :: Attrname: " + attrName + " :: Client: " + client + " :: Force CA: " + forceCA + " :: User vals: " + vals);
        }
        if (serviceName == null) {
            throw new MissingResourceException("Missing in Map", "DSAMEServiceUserContext", "serviceName");
        }
        int scope = this.dsameUtils.getAttributeScope(serviceName, attrName);
        int type = this.dsameUtils.getAttributeType(serviceName, attrName);
        Set newVals = null;
        if (type == 4 || type == 2) {
            newVals = vals;
        } else if (type == 1) {
            String msg = null;
            if (vals != null && vals.size() > 1) {
                msg = "Cannot set multi-values in attribute defined as SINGLE. ";
            }
            if (forceCA) {
                msg = msg + ":Cannot forceClientAwareness on an attribute defined as SINGLE.";
            }
            if (msg != null) {
                throw new IOException(msg);
            }
            newVals = vals;
        } else {
            HashMap awareMap = new HashMap();
            this.getAttribute(serviceName, client, attrName, false, awareMap, scope, type);
            newVals = this.dsameUtils.modifyValues(client, awareMap, vals, forceCA);
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ".setAttribute():: Scope: " + DSAMEConstants.scopeArray[scope] + " :: Type: " + type + " :: Modified Vals: " + newVals);
        }
        switch (scope) {
            case 5: {
                this.dsameConn.setGlobalAttribute(serviceName, attrName, newVals);
                break;
            }
            case 6: {
                this.dsameConn.setOrganizationAttribute(serviceName, attrName, newVals);
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.dsameConn.setAttribute(attrName, newVals);
            }
        }
    }

    public void removeAttribute(Map service, String attrName) throws IllegalStateException, MissingResourceException, IOException {
        String serviceName = this.dsameUtils.getServiceName(service);
        int scope = this.dsameUtils.getAttributeScope(serviceName, attrName);
        HashSet<String> attrs = new HashSet<String>();
        attrs.add(attrName);
        switch (scope) {
            case 5: {
                throw new IOException("Cannot remove global attributes");
            }
            case 6: {
                this.dsameConn.removeOrganizationAttribute(serviceName, attrs);
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.dsameConn.removeAttribute(attrs);
            }
        }
    }

    public String getClientType() {
        return this.sessClientType;
    }
}

