/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exceptions.PimExceptionMapper;
import com.aligo.pim.exchange.ExchangePimExceptionMapper;
import com.aligo.pim.exchange.ExchangePimUserInfo;
import com.linar.jintegra.AutomationException;

public class ExchangePimException
extends PimException {
    private long m_iExchangeExceptionCode = -900L;
    private String m_szExchangeExceptionMessage = "";
    private long m_iPimExceptionCode = -900L;
    private String m_szPimExceptionMessage = "";

    public ExchangePimException(long code) {
        this.setPimExceptionCode(code);
        this.resolve();
    }

    public ExchangePimException(Exception e) {
        if (ExchangePimUserInfo.DEBUG) {
            e.printStackTrace();
        }
        if (e instanceof AligoExchangeException) {
            AligoExchangeException ne = (AligoExchangeException)e;
            this.setExchangeExceptionCode(ne.getCode());
            this.setExchangeExceptionMessage(ne.getMessage());
        } else if (e instanceof AutomationException) {
            AutomationException ae = (AutomationException)((Object)e);
            this.setExchangeExceptionCode(ae.getCode());
            this.setExchangeExceptionMessage(ae.getMessage());
        } else if (e instanceof ExchangePimException) {
            ExchangePimException ep = (ExchangePimException)((Object)e);
            this.setPimExceptionCode(ep.getCode());
            this.setPimExceptionMessage(ep.getMessage());
        } else {
            this.setExchangeExceptionMessage(e.getMessage());
        }
        this.resolve();
    }

    private void setExchangeExceptionCode(long code) {
        this.m_iExchangeExceptionCode = code;
    }

    private void setExchangeExceptionMessage(String message) {
        this.m_szExchangeExceptionMessage = message;
    }

    private long getExchangeExceptionCode() {
        return this.m_iExchangeExceptionCode;
    }

    private String getExchangeExceptionMessage() {
        return this.m_szExchangeExceptionMessage;
    }

    private void setPimExceptionCode(long code) {
        this.m_iPimExceptionCode = code;
    }

    private void setPimExceptionMessage(String message) {
        this.m_szPimExceptionMessage = message;
    }

    private long getPimExceptionCode() {
        return this.m_iPimExceptionCode;
    }

    private String getPimExceptionMessage() {
        return this.m_szPimExceptionMessage;
    }

    public String getMessage() {
        return this.getPimExceptionMessage();
    }

    public long getCode() {
        return this.getPimExceptionCode();
    }

    private void resolve() {
        if (this.getPimExceptionCode() != -900L) {
            this.setPimExceptionMessage(PimExceptionMapper.getPimExceptionMessage((long)this.getPimExceptionCode()));
        } else if (this.getExchangeExceptionCode() != -900L) {
            this.setPimExceptionCode(ExchangePimExceptionMapper.getPimExceptionCode(this.getExchangeExceptionCode()));
            this.setPimExceptionMessage(PimExceptionMapper.getPimExceptionMessage((long)this.getPimExceptionCode()));
        } else {
            this.setPimExceptionMessage(this.getExchangeExceptionMessage());
        }
    }
}

