/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeSession;
import com.aligo.pim.PimFolderType;
import com.aligo.pim.PimTimeZoneType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimCalendar;
import com.aligo.pim.exchange.ExchangePimContact;
import com.aligo.pim.exchange.ExchangePimDeleted;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFolder;
import com.aligo.pim.exchange.ExchangePimGlobalAddressEntry;
import com.aligo.pim.exchange.ExchangePimInbox;
import com.aligo.pim.exchange.ExchangePimJournal;
import com.aligo.pim.exchange.ExchangePimNotes;
import com.aligo.pim.exchange.ExchangePimOutbox;
import com.aligo.pim.exchange.ExchangePimSent;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimTask;
import com.aligo.pim.exchange.ExchangePimUserInfo;
import com.aligo.pim.exchange.outlook.OutlookPimCalendar;
import com.aligo.pim.exchange.outlook.OutlookPimContact;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimContainer;
import com.aligo.pim.interfaces.PimFolder;
import com.aligo.pim.interfaces.PimSession;
import com.aligo.pim.interfaces.PimUserInfo;
import java.net.UnknownHostException;

public class ExchangePimContainer
implements PimContainer {
    private ExchangePimUserInfo m_oPimUserInfo;
    private ExchangePimSession m_oPimSession;
    private boolean m_bLoggedOn;

    public PimUserInfo addUserInfo() {
        this.m_oPimUserInfo = new ExchangePimUserInfo();
        return this.m_oPimUserInfo;
    }

    public void logon() throws ExchangePimException {
        if (this.m_oPimUserInfo == null) {
            throw new ExchangePimException(2L);
        }
        if (this.m_bLoggedOn) {
            this.logoff();
        }
        this.createSession();
        this.m_bLoggedOn = true;
    }

    public void logoff() throws ExchangePimException {
        if (!this.m_bLoggedOn) {
            throw new ExchangePimException(9L);
        }
        this.getExchangePimSession().logoff();
        this.m_bLoggedOn = false;
    }

    private PimSession createSession() throws ExchangePimException {
        try {
            ExchangeSession oSession = new ExchangeSession(this.m_oPimUserInfo.getUserName(), this.m_oPimUserInfo.getPassword(), this.m_oPimUserInfo.getMailBox(), this.m_oPimUserInfo.getServer(), this.m_oPimUserInfo.getDomain(), this.m_oPimUserInfo.getOcxhostLocation(), this.m_oPimUserInfo.getAligoAuthLocation(), this.m_oPimUserInfo.getOutlookLocation(), this.m_oPimUserInfo.getIsAligoAuthUsed(), this.m_oPimUserInfo.getSuperUser());
            oSession.logon();
            oSession.getOutOfOffice();
            this.m_oPimSession = new ExchangePimSession(oSession);
            return this.m_oPimSession;
        }
        catch (UnknownHostException ex) {
            throw new ExchangePimException(6L);
        }
        catch (AligoExchangeException ex) {
            if (ex.getCode() == 5) {
                throw new ExchangePimException(1L);
            }
            throw new ExchangePimException(ex);
        }
        catch (Exception ex) {
            throw new ExchangePimException(-1L);
        }
    }

    private ExchangePimSession getExchangePimSession() throws ExchangePimException {
        if (!this.m_bLoggedOn) {
            throw new ExchangePimException(9L);
        }
        if (this.m_oPimSession == null) {
            this.m_oPimSession = (ExchangePimSession)this.createSession();
        }
        return this.m_oPimSession;
    }

    public PimFolder getFolder(PimFolderType folderType) throws ExchangePimException {
        return this.getFolder(folderType, null);
    }

    public PimFolder getFolder(PimFolderType folderType, String user) throws ExchangePimException {
        if (!this.m_bLoggedOn) {
            throw new ExchangePimException(9L);
        }
        if (user != null && !PimFolderType.PERSONAL_ADDRESS_BOOK.equals(folderType) && !PimFolderType.CALENDAR.equals(folderType)) {
            throw new ExchangePimException(-2L);
        }
        if (PimFolderType.INBOX.equals(folderType)) {
            ExchangePimInbox pimInbox = this.getExchangePimSession().getInbox();
            return pimInbox;
        }
        if (PimFolderType.PERSONAL_ADDRESS_BOOK.equals(folderType)) {
            if (user == null) {
                ExchangePimContact pimContact = this.getExchangePimSession().getContact();
                return pimContact;
            }
            OutlookPimContact pimContact = this.getExchangePimSession().getContact(user);
            return pimContact;
        }
        if (PimFolderType.GLOBAL_ADDRESS_BOOK.equals(folderType)) {
            ExchangePimGlobalAddressEntry pimGlobalAddressEntrty = this.getExchangePimSession().getAddressLists();
            return pimGlobalAddressEntrty;
        }
        if (PimFolderType.CALENDAR.equals(folderType)) {
            if (user == null) {
                ExchangePimCalendar pimCalendar = this.getExchangePimSession().getCalendar();
                return pimCalendar;
            }
            OutlookPimCalendar pimCalendar = this.getExchangePimSession().getCalendar(user);
            return pimCalendar;
        }
        if (PimFolderType.OUTBOX.equals(folderType)) {
            ExchangePimOutbox pimOutbox = this.getExchangePimSession().getOutbox();
            return pimOutbox;
        }
        if (PimFolderType.JOURNAL.equals(folderType)) {
            ExchangePimJournal pimJournal = this.getExchangePimSession().getJournal();
            return pimJournal;
        }
        if (PimFolderType.NOTES.equals(folderType)) {
            ExchangePimNotes pimNotes = this.getExchangePimSession().getNotes();
            return pimNotes;
        }
        if (PimFolderType.SENT.equals(folderType)) {
            ExchangePimSent pimSent = this.getExchangePimSession().getSent();
            return pimSent;
        }
        if (PimFolderType.TASK.equals(folderType)) {
            ExchangePimTask pimTask = this.getExchangePimSession().getTask();
            return pimTask;
        }
        if (PimFolderType.DELETED.equals(folderType)) {
            ExchangePimDeleted pimDeleted = this.getExchangePimSession().getDeleted();
            return pimDeleted;
        }
        return null;
    }

    public PimFolder getFolder(String nameOfFolder) throws ExchangePimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getCurrentUser() throws ExchangePimException {
        if (!this.m_bLoggedOn) {
            throw new ExchangePimException(9L);
        }
        return this.getExchangePimSession().getCurrentUser();
    }

    public void setTimeZone(PimTimeZoneType pimTimeZoneType) throws ExchangePimException {
    }

    public PimFolder getRootFolder() throws PimException {
        ExchangePimFolder exchangePimFolder = this.getExchangePimSession().getRootFolder();
        return exchangePimFolder;
    }

    public PimFolder getPublicRootFolder() throws PimException {
        ExchangePimFolder exchangePimFolder = this.getExchangePimSession().getPublicRootFolder();
        return exchangePimFolder;
    }
}

