/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util;

import com.sun.portal.rewriter.util.Constants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class StringHelper {
    public static String searchAndReplace(String aSource, String[][] aFindReplaceMap) {
        if (aSource == null || aFindReplaceMap == null) {
            return aSource;
        }
        String lResult = aSource;
        int i = 0;
        while (i < aFindReplaceMap.length) {
            lResult = StringHelper.searchAndReplace(lResult, aFindReplaceMap[i][0], aFindReplaceMap[i][1]);
            ++i;
        }
        return lResult;
    }

    public static String[] searchAndReplace(String[] aSource, String aFind, String aReplace) {
        if (aSource == null || aSource.length == 0) {
            return aSource;
        }
        String[] lResult = new String[aSource.length];
        int i = 0;
        while (i < aSource.length) {
            lResult[i] = StringHelper.searchAndReplace(aSource[i], aFind, aReplace);
            ++i;
        }
        return lResult;
    }

    /*
     * WARNING - void declaration
     */
    public static String searchAndReplace(String aSource, String aFind, String aReplace) {
        int length;
        int lFindLength;
        if (aSource == null || aFind == null || (lFindLength = aFind.length()) == 0) {
            return aSource;
        }
        if (aReplace == null) {
            aReplace = "";
        }
        int lSourceLength = aSource.length();
        int lReplaceLength = aReplace.length();
        if (lFindLength == lReplaceLength) {
            length = lSourceLength;
        } else {
            int end;
            int count = 0;
            int start = 0;
            while ((end = aSource.indexOf(aFind, start)) != -1) {
                void var9_9;
                ++count;
                start = var9_9 + lFindLength;
            }
            if (count == 0) {
                return aSource;
            }
            length = lSourceLength - count * (lFindLength - lReplaceLength);
        }
        int start = 0;
        int end = aSource.indexOf(aFind, start);
        if (end == -1) {
            return aSource;
        }
        StringBuffer sb = new StringBuffer(length);
        while (end != -1) {
            sb.append(aSource.substring(start, end));
            sb.append(aReplace);
            start = end + lFindLength;
            end = aSource.indexOf(aFind, start);
        }
        end = lSourceLength;
        sb.append(aSource.substring(start, end));
        return sb.toString();
    }

    public static String normalize(String aSource) {
        return aSource != null ? aSource.trim() : "";
    }

    public static String normalize(String aSource, String aDefault) {
        String result = StringHelper.normalize(aSource);
        return result.length() == 0 ? aDefault : result;
    }

    public static String exceptionStack2String(Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        return null;
    }

    public static String findMatchByIgnoringCase(Collection aCollection, String aString) {
        Iterator iterator = aCollection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (!s.equalsIgnoreCase(aString)) continue;
            return s;
        }
        return null;
    }

    public static final String[] tokenize(String aString, String aTokens) {
        return StringHelper.tokenize(aString, aTokens, false);
    }

    public static String[] tokenize(String aSource, String aTokenList, boolean aIncludeEmpty, int aEnsureLength) {
        String[] result = StringHelper.tokenize(aSource, aTokenList, aIncludeEmpty);
        return StringHelper.ensureLength(result, aEnsureLength);
    }

    public static final String[] tokenize(String aString, String aTokens, boolean aIncludeEmpty) {
        if (aTokens.length() == 1) {
            return StringHelper.tokenize(aString, aTokens.charAt(0), aIncludeEmpty);
        }
        return StringHelper.tokenizeNonPerfWay(aString, aTokens, aIncludeEmpty);
    }

    private static final String[] tokenize(String aOrgString, char aToken, boolean aIncludeEmpty) {
        String sub;
        ArrayList<String> lList = new ArrayList<String>();
        String aString = aOrgString;
        int i = 0;
        int j = aString.indexOf(aToken);
        while (j >= 0) {
            if (j != 0 && aString.charAt(j - 1) == Constants.ESCAPE_FORWARD_SLASH_CHAR) {
                aString = aString.substring(0, j - 1) + aString.substring(j);
                j = aString.indexOf(aToken, j);
                continue;
            }
            sub = aString.substring(i, j);
            i = j + 1;
            j = aString.indexOf(aToken, i);
            if (!aIncludeEmpty && sub.length() <= 0) continue;
            lList.add(sub);
        }
        sub = aString.substring(i);
        if (aString.length() > 0 && (aIncludeEmpty || sub.length() > 0)) {
            lList.add(sub);
        }
        return lList.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    private static String[] tokenizeNonPerfWay(String aSourceString, String aDelimList, boolean aBool) {
        StringTokenizer st = new StringTokenizer(aSourceString, aDelimList, aBool);
        ArrayList<String> lList = new ArrayList<String>();
        boolean wasPreviousOneADelim = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            boolean isPresentOneADelim;
            String bToken = st.nextToken();
            boolean bl = isPresentOneADelim = aDelimList.indexOf(bToken) != -1;
            if (!isPresentOneADelim) {
                lList.add(bToken);
            } else if (i == 0) {
                lList.add("");
            } else if (wasPreviousOneADelim) {
                lList.add("");
            }
            wasPreviousOneADelim = isPresentOneADelim;
            ++i;
        }
        if (wasPreviousOneADelim) {
            lList.add("");
        }
        return lList.toArray(Constants.EMPTY_STRING_ARRAY);
    }

    private static String[] ensureLength(String[] result, int aLength) {
        if (aLength > result.length) {
            Object[] temp = new String[aLength];
            Arrays.fill(temp, "");
            System.arraycopy(result, 0, temp, 0, result.length);
            result = temp;
        }
        return result;
    }

    public static String[] regExpSplit(String aOrgURL, String aRegExp) {
        if (aOrgURL == null) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        String urlPart = aOrgURL.trim();
        while (urlPart.startsWith("\"") || urlPart.startsWith("'") || urlPart.startsWith("\\'") || urlPart.startsWith("\\\"")) {
            urlPart = urlPart.substring(1).trim();
        }
        while (urlPart.startsWith("&#")) {
            int index = urlPart.indexOf(";");
            if (index == -1) break;
            urlPart = urlPart.substring(index + 1).trim();
        }
        int firstIndex = aOrgURL.indexOf(urlPart);
        while (urlPart.endsWith("\\'") || urlPart.endsWith("\\\"") || urlPart.endsWith("\"") || urlPart.endsWith("'")) {
            if (!(urlPart = urlPart.substring(0, urlPart.length() - 1).trim()).endsWith("\\")) continue;
            urlPart = urlPart.substring(0, urlPart.length() - 1).trim();
        }
        return new String[]{aOrgURL.substring(0, firstIndex), urlPart, aOrgURL.substring(firstIndex + urlPart.length())};
    }

    public static final String trimQuotes(String aString) {
        String lValue = aString;
        String[] splitted = StringHelper.regExpSplit(lValue, "^([(\\\\\")\\s\"'])+|([(\\\\\")\\s\"'])+$");
        if (splitted.length == 3) {
            lValue = splitted[1];
        }
        return lValue;
    }

    public static boolean startsWithIgnoreCase(String aSRC, String aMache) {
        return aSRC.regionMatches(true, 0, aMache, 0, aMache.length());
    }

    public static void main(String[] args) {
        String[][] lData = new String[][]{{"", ":"}, {":::", ":"}, {"jini://raja.sun. com ;mahesh.sun.com;jini://srinu.sil.co.in", ";"}, {",y,,", ","}, {"test", " "}, {",y,", ","}, {",y", ","}, {" ,y", ","}};
        int i = 0;
        while (i < lData.length) {
            System.out.println(Arrays.asList(StringHelper.tokenize(lData[i][0], lData[i][1], true)));
            ++i;
        }
    }
}

