/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.clip.CLIPException;
import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import com.sun.portal.rewriter.util.clip.CLIPSubCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CLIPParser {
    private String toolHelpMessageID;
    private final Map subCommandsList = new HashMap();
    private final List orderedSubCommandsList = new ArrayList();

    public CLIPParser(CLIPSubCommand[] aSubCommands, String aToolHelpMessage) throws IllegalArgumentException {
        this.toolHelpMessageID = aToolHelpMessage;
        if (aSubCommands == null || aSubCommands.length == 0) {
            throw new IllegalArgumentException("CLIPParser - sub command array can not be null or empty");
        }
        int i = 0;
        while (i < aSubCommands.length) {
            if (aSubCommands[i].getSubCommandName() == null) {
                throw new IllegalArgumentException("CLIPSubCommand can not be null");
            }
            this.addSubCommand(aSubCommands[i]);
            ++i;
        }
    }

    public CLIPParser(CLIPOption[] options, int minOperands, int maxOperands, String aCommandHelpMessage, String operandsHelp) throws IllegalArgumentException {
        CLIPSubCommand subCommand = new CLIPSubCommand(null, options, minOperands, maxOperands, operandsHelp, aCommandHelpMessage);
        this.addSubCommand(subCommand);
    }

    private void addSubCommand(CLIPSubCommand subCommand) throws IllegalArgumentException {
        if (subCommand.getSubCommandName() != null) {
            CLIPParser.verifyName(subCommand.getSubCommandName(), "CLIPSubCommand");
        }
        if (this.subCommandsList.containsKey(subCommand.getSubCommandName())) {
            throw new IllegalArgumentException("CLIPSubCommand '" + subCommand.getSubCommandName() + "', sub command already defined");
        }
        this.subCommandsList.put(subCommand.getSubCommandName(), subCommand);
        this.orderedSubCommandsList.add(subCommand);
    }

    public String getToolHelp() {
        return CLIPSpec.getLocaleHelper().getLocalizedString(this.toolHelpMessageID);
    }

    public void verifyArguments(String[] args) {
        try {
            if (CLIPParser.scanForStdExitOptions(args) != null) {
                return;
            }
            this.getSubCommand(args);
            this.getOptions(args);
            this.getOperands(args);
        }
        catch (CLIPException e) {
            System.err.println(e);
            System.exit(0);
        }
    }

    public String getSubCommand(String[] args) throws CLIPException {
        boolean hasSubCommands = !this.subCommandsList.containsKey(null);
        String firstArgument = args.length > 0 && hasSubCommands ? args[0] : null;
        CLIPSubCommand subCommand = (CLIPSubCommand)this.subCommandsList.get(firstArgument);
        if (subCommand == null) {
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidSubCmd", new Object[]{firstArgument}), 0);
        }
        return firstArgument;
    }

    public Map getOptions(String[] args) throws CLIPException {
        CLIPSubCommand subCommand = (CLIPSubCommand)this.subCommandsList.get(this.getSubCommand(args));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator i = subCommand.getDefaultOptionValues().keySet().iterator();
        while (i.hasNext()) {
            String optionName = (String)i.next();
            List optionValues = (List)subCommand.getDefaultOptionValues().get(optionName);
            map.put(optionName, ((ArrayList)optionValues).clone());
        }
        int argumentIndex = this.processOptions(args, map);
        i = subCommand.getValidOptions().keySet().iterator();
        while (i.hasNext()) {
            String optionName = (String)i.next();
            CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
            if (option.getDefaultValues() != null || map.containsKey(option.getLongName())) continue;
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingMandatoryOption", new Object[]{option.getLongName()}), argumentIndex);
        }
        return CLIPParser.massageOptions(map);
    }

    public String[] getOperands(String[] args) throws CLIPException {
        CLIPSubCommand subCommand = (CLIPSubCommand)this.subCommandsList.get(this.getSubCommand(args));
        int i = this.processOptions(args, new HashMap());
        int numberOfOperands = args.length - i;
        if (subCommand.getMinOperands() > numberOfOperands || numberOfOperands > subCommand.getMaxOperands()) {
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOperandsCount"), i);
        }
        int j = i;
        while (j < args.length) {
            if (args[j].equals("--")) {
                throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorDashDashCantBeOperand"), j);
            }
            ++j;
        }
        String[] operands = new String[numberOfOperands];
        if (args.length > 0) {
            System.arraycopy(args, i, operands, 0, numberOfOperands);
        }
        return operands;
    }

    private int processOptions(String[] args, Map map) throws CLIPException {
        CLIPSubCommand subCommand = (CLIPSubCommand)this.subCommandsList.get(this.getSubCommand(args));
        boolean allOptionsProcessed = false;
        int i = subCommand.getSubCommandName() != null ? 1 : 0;
        while (!allOptionsProcessed && i < args.length) {
            List values;
            String optionValue;
            String token;
            StringTokenizer tokens;
            String optionValue2;
            List values2;
            String optionName;
            if (args[i].startsWith("--add-")) {
                optionName = args[i].substring("--add-".length());
                CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
                if (optionName.length() < 2 || option == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{optionName}), i);
                }
                if (option.getType() != 2) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotACollection", new Object[]{optionName}), i);
                }
                values2 = CLIPParser.getOptionValues(subCommand, map, optionName);
                if (i + 1 == args.length) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingCollectionValuesToAdd", new Object[]{optionName}), i);
                }
                tokens = new StringTokenizer(optionValue2, (optionValue2 = args[++i]).indexOf(" ") > -1 ? " " : ",");
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    values2.add(token);
                }
            } else if (args[i].startsWith("--remove-")) {
                optionName = args[i].substring("--remove-".length());
                CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
                if (optionName.length() < 2 || option == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{optionName}), i);
                }
                if (option.getType() != 2) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotACollection", new Object[]{optionName}), i);
                }
                if (i + 1 == args.length) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingCollectionValuesToDelete", new Object[]{optionName}), i);
                }
                values2 = CLIPParser.getOptionValues(subCommand, map, optionName);
                tokens = new StringTokenizer(optionValue2, (optionValue2 = args[++i]).indexOf(" ") > -1 ? " " : ",");
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (values2.contains(token)) {
                        values2.remove(token);
                        continue;
                    }
                    int j = 0;
                    while (j < values2.size()) {
                        String v = (String)values2.get(j);
                        if (v.startsWith(token + "=")) {
                            values2.remove(j);
                        }
                        ++j;
                    }
                }
            } else if (args[i].equals("--")) {
                ++i;
                allOptionsProcessed = true;
            } else if (args[i].startsWith("--no-")) {
                optionName = args[i].substring("--no-".length());
                CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
                if (option == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{optionName}), i);
                }
                if (option.getType() != 0) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotABoolean", new Object[]{optionName}), i);
                }
                optionValue = "false";
                values = CLIPParser.getOptionValues(subCommand, map, optionName);
                values.clear();
                values.add(optionValue);
            } else if (args[i].startsWith("--")) {
                optionName = args[i].substring("--".length());
                CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
                if (option == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{optionName}), i);
                }
                if (option.getType() == 2) {
                    if (i + 1 == args.length) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingCollectionOptionValue", new Object[]{optionName}), i);
                    }
                    optionValue = args[++i];
                    values = CLIPParser.getOptionValues(subCommand, map, optionName);
                    values.clear();
                    tokens = new StringTokenizer(optionValue, optionValue.indexOf(" ") > -1 ? " " : ",");
                    while (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        values.add(token);
                    }
                } else {
                    i = this.handleRest(args, subCommand, option, optionName, map, i);
                }
            } else if (args[i].startsWith("-")) {
                optionName = args[i].substring("-".length());
                int j = 0;
                while (j < optionName.length() - 1) {
                    String shortOptionName = "" + optionName.charAt(j);
                    CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(shortOptionName);
                    if (option == null) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{shortOptionName}), i);
                    }
                    if (option.getType() != 0) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotABooleanOption", new Object[]{shortOptionName}), i);
                    }
                    String optionValue3 = "true";
                    List values3 = CLIPParser.getOptionValues(subCommand, map, shortOptionName);
                    values3.clear();
                    values3.add(optionValue3);
                    ++j;
                }
                optionName = "" + optionName.charAt(optionName.length() - 1);
                CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
                i = this.checkBoolAndRegular(args, subCommand, optionName, option, i, map);
            } else {
                allOptionsProcessed = true;
            }
            ++i;
        }
        if (allOptionsProcessed) {
            --i;
        }
        return i;
    }

    private int checkBoolAndRegular(String[] args, CLIPSubCommand aSubCommand, String aOptionName, CLIPOption aOption, int aI, Map map) throws CLIPException {
        if (aOption == null) {
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{aOptionName}), aI);
        }
        return this.handleRest(args, aSubCommand, aOption, aOptionName, map, aI);
    }

    private int handleRest(String[] aArgs, CLIPSubCommand aSubCommand, CLIPOption aOption, String aOptionName, Map aMap, int aIndex) throws CLIPException {
        if (aOption.getType() == 0) {
            String optionValue = "true";
            List values = CLIPParser.getOptionValues(aSubCommand, aMap, aOptionName);
            values.clear();
            values.add(optionValue);
        } else if (aOption.getType() == 1) {
            if (aIndex + 1 == aArgs.length) {
                throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingRegularOptionValue", new Object[]{aOptionName}), aIndex);
            }
            String optionValue = aArgs[++aIndex];
            List values = CLIPParser.getOptionValues(aSubCommand, aMap, aOptionName);
            values.clear();
            values.add(optionValue);
        } else {
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("clipInternalError"), aIndex);
        }
        return aIndex;
    }

    private static List getOptionValues(CLIPSubCommand subCommand, Map map, String optionName) {
        CLIPOption option = (CLIPOption)subCommand.getValidOptions().get(optionName);
        String longName = option.getLongName();
        ArrayList list = (ArrayList)map.get(longName);
        if (list == null) {
            list = new ArrayList();
            map.put(longName, list);
        }
        return list;
    }

    private static Map massageOptions(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String option = (String)i.next();
            List values = (List)map.get(option);
            String[] arrayValues = new String[values.size()];
            values.toArray(arrayValues);
            map.put(option, arrayValues);
        }
        return map;
    }

    public static String getName(String element) {
        String name = element;
        int index = element.indexOf("=");
        if (index > -1) {
            name = element.substring(0, index);
        }
        return name;
    }

    public static String getValue(String element) {
        String value = null;
        int index = element.indexOf("=");
        if (index > -1) {
            value = element.substring(index + 1);
        }
        return value;
    }

    public String toString(String[] args) throws CLIPException {
        StringBuffer sb = new StringBuffer(2048);
        String subCmd = this.getSubCommand(args);
        Map options = this.getOptions(args);
        String[] operands = this.getOperands(args);
        sb.append("\n").append("Sub-command: ").append(subCmd).append("\n").append("\n").append("Options: ").append("\n");
        Iterator i = options.keySet().iterator();
        while (i.hasNext()) {
            String option = (String)i.next();
            String[] values = (String[])options.get(option);
            sb.append(("  " + option + "              ").substring(0, 12) + ": ");
            int j = 0;
            while (j < values.length) {
                sb.append(values[j]).append(" ");
                ++j;
            }
            sb.append("\n");
        }
        sb.append("\n").append("Operands: ").append("\n");
        int j = 0;
        while (j < operands.length) {
            sb.append("  ").append(operands[j]).append("\n");
            ++j;
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean needsHelp(String[] args) {
        boolean help = false;
        try {
            this.verifyArguments(args);
            Map options = this.getOptions(args);
            help = options.containsKey("help") && ((String[])options.get("help"))[0].equals("true");
        }
        catch (CLIPException ex) {
            help = true;
        }
        return help;
    }

    public String getHelp(String[] args) {
        CLIPSubCommand subCommand;
        boolean fullHelp = false;
        String firstArgument = args.length > 0 ? args[0] : null;
        boolean bl = fullHelp = !this.subCommandsList.containsKey(firstArgument);
        if (!fullHelp) {
            subCommand = (CLIPSubCommand)this.subCommandsList.get(firstArgument);
        } else {
            subCommand = (CLIPSubCommand)this.subCommandsList.get(null);
            fullHelp = subCommand == null || subCommand.getSubCommandName() != null;
        }
        StringBuffer sb = new StringBuffer(2048);
        if (fullHelp) {
            sb.append(this.getToolHelp()).append("\n\n");
            sb.append("SUBCOMMANDS\n");
            int size = this.orderedSubCommandsList.size();
            int i = 0;
            while (i < size) {
                subCommand = (CLIPSubCommand)this.orderedSubCommandsList.get(i);
                String name = subCommand.getSubCommandName();
                name = name == null ? "<NO SUB COMMAND>  " : name + "  ";
                sb.append("  ").append(name).append(subCommand.getSubCommandHelp()).append(".\n");
                CLIPParser.printOptionsHelp(sb, "    ", subCommand.getOrderedOptions());
                if (subCommand.getMaxOperands() > 0) {
                    if (subCommand.getMaxOperands() == 1) {
                        sb.append("    <OPERAND> ");
                    } else {
                        sb.append("    <OPERANDS> ");
                    }
                    sb.append(subCommand.getOperandsHelp()).append("\n");
                }
                ++i;
            }
        } else {
            sb.append(subCommand.getSubCommandHelp()).append(".\n\n");
            sb.append("OPTIONS\n");
            CLIPParser.printOptionsHelp(sb, "  ", subCommand.getOrderedOptions());
            if (subCommand.getMaxOperands() > 0) {
                if (subCommand.getMaxOperands() == 1) {
                    sb.append("\nOPERAND\n");
                } else {
                    sb.append("\nOPERANDS\n");
                }
                sb.append("  ").append(subCommand.getOperandsHelp()).append("\n");
            }
        }
        return sb.toString();
    }

    private static void printOptionsHelp(StringBuffer sb, String padding, List options) {
        int size = options.size();
        int i = 0;
        while (i < size) {
            CLIPOption option = (CLIPOption)options.get(i);
            sb.append(padding);
            if (option.getShortName() == null || option.getShortName().length() == 0) {
                sb.append("   ");
            } else {
                sb.append('-').append(option.getShortName()).append(' ');
            }
            sb.append("--").append(option.getLongName()).append(' ');
            sb.append(option.getHelpMessage()).append(" (");
            if (option.getDefaultValues() == null) {
                sb.append("none");
            } else {
                int j = 0;
                while (j < option.getDefaultValues().length) {
                    if (j > 0) {
                        sb.append(' ');
                    }
                    sb.append(option.getDefaultValues()[j]);
                    ++j;
                }
            }
            sb.append(")\n");
            ++i;
        }
    }

    static String scanForStdExitOptions(String[] args) {
        String stdHelpOption = "--help";
        String stdVersionOption = "--version";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--help")) {
                return "--help";
            }
            if (args[i].equals("--version")) {
                return "--version";
            }
            ++i;
        }
        return null;
    }

    static void verifyName(String name, String exceptionMsgPrefix) {
        if (name == null || name.length() < 2) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " has to be at least 2 chars long");
        }
        if (name.equals("--")) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " can not be '--'");
        }
        if (name.startsWith("-") || name.endsWith("-")) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " can not start or end with '-'");
        }
        if (!name.equals(name.toLowerCase())) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " has to be in lower case");
        }
    }

    public String toString() {
        return "Tool Help Message: " + this.getToolHelp() + "\n" + "\nSub Command List: " + this.subCommandsList + "\n";
    }
}

