/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import com.sun.portal.rproxy.configservlet.server.CdmHandler;
import com.sun.portal.rproxy.configservlet.server.GatewayServiceHandler;
import com.sun.portal.rproxy.configservlet.server.GlobalAttributesServiceHandler;
import com.sun.portal.rproxy.configservlet.server.UserAttributesServiceHandler;
import com.sun.portal.rproxy.configservlet.server.UserAttributesSetHandler;
import com.sun.portal.rproxy.rewriter.services.idsame.IDSAMEDataServiceSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteConfigServlet
extends HttpServlet {
    private static final String GET_GLOBALS = "GET_GLOBALS";
    private static final String GET_USERS = "GET_USERS";
    private static final String SET_USER_ATTRIBUTES = "SET_USER_ATTRIBUTES";
    private static final String CDM_GET_CLIENT_PROPERTY = "CDM_GET_CLIENT_PROPERTY";

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Request request = this.getRequest(httpServletRequest);
        if (!this.validateRequest(request)) {
            Response response = new Response("", "", "");
            response.setNeedRecreateSession(true);
            this.sendResponse(httpServletResponse, response);
            return;
        }
        Response response = this.handleRequest(request);
        this.sendResponse(httpServletResponse, response);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    private Request getRequest(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)httpServletRequest.getInputStream());
            Request request = (Request)objectInputStream.readObject();
            return request;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServletException(classNotFoundException.getMessage());
        }
    }

    private void sendResponse(HttpServletResponse httpServletResponse, Response response) throws ServletException, IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)servletOutputStream);
        objectOutputStream.writeObject(response);
        servletOutputStream.close();
    }

    private Response handleRequest(Request request) {
        ServiceHandler serviceHandler = this.getServiceHandler(request);
        try {
            return serviceHandler.handleRequest(request);
        }
        catch (RuntimeException runtimeException) {
            return new Response(request.getServiceName(), request.getRequestType(), runtimeException);
        }
        catch (RemoteException remoteException) {
            return new Response(request.getServiceName(), request.getRequestType(), remoteException);
        }
    }

    private ServiceHandler getServiceHandler(Request request) {
        if ("srapGatewayService".equals(request.getServiceName())) {
            return new GatewayServiceHandler();
        }
        if (GET_GLOBALS.equals(request.getRequestType())) {
            return new GlobalAttributesServiceHandler();
        }
        if (GET_USERS.equals(request.getRequestType())) {
            return new UserAttributesServiceHandler();
        }
        if (SET_USER_ATTRIBUTES.equals(request.getRequestType())) {
            return new UserAttributesSetHandler();
        }
        if (CDM_GET_CLIENT_PROPERTY.equals(request.getRequestType())) {
            return CdmHandler.getInstance();
        }
        if ("HTTPDataService".equals(request.getServiceName())) {
            return new IDSAMEDataServiceSkeleton();
        }
        return null;
    }

    private boolean validateRequest(Request request) {
        try {
            SSOToken sSOToken = null;
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = request.getGatewaySessionID();
            sSOToken = sSOTokenManager.createSSOToken(string);
            if (sSOTokenManager.isValidToken(sSOToken)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

