/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.test;

import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderEditTypes;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ProviderWidths;
import com.sun.portal.providers.UnknownEditTypeException;
import com.sun.portal.providers.context.ContainerProviderContext;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ProviderAdapterTest
extends TestCase
implements ProviderEditTypes,
ProviderWidths {
    protected Provider provider = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected DesktopAppContext appContext = null;

    public ProviderAdapterTest(Provider p, HttpServletRequest req, HttpServletResponse res, String test) {
        super(test);
        this.provider = p;
        this.req = req;
        this.res = res;
        this.appContext = DesktopAppContextThreadLocalizer.get();
    }

    public static TestSuite suite(ContainerProviderContext cpc, HttpServletRequest req, HttpServletResponse res) {
        Provider p = cpc.getProvider(req, null, "test1");
        TestSuite ts = new TestSuite();
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testProviderNotNull"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetName"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetTitle"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetDescription"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetRefreshTime"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testIsEditable"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetEditType"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetWidth"));
        ts.addTest((Test)new ProviderAdapterTest(p, req, res, "testGetHelp"));
        return ts;
    }

    public void testProviderNotNull() {
        Assert.assertNotNull((Object)this.provider);
    }

    public void testGetName() throws ProviderException {
        String name = this.provider.getName();
        Assert.assertNotNull((Object)name);
    }

    public void testGetTitle() throws ProviderException {
        String title = this.provider.getTitle();
        Assert.assertNotNull((Object)title);
    }

    public void testGetDescription() throws ProviderException {
        String desc = this.provider.getDescription();
        Assert.assertNotNull((Object)desc);
    }

    public void testGetHelp() {
        try {
            URL hu = this.provider.getHelp(this.req);
            Assert.assertNotNull((String)"returned null unexpectedly", (Object)hu);
        }
        catch (ProviderException pe) {
            this.appContext.debugError(pe);
            throw new AssertionFailedError(pe.getMessage());
        }
    }

    public void testGetRefreshTime() throws ProviderException {
        long rt = this.provider.getRefreshTime();
        Assert.assertTrue((rt > -1L ? 1 : 0) != 0);
    }

    public void testIsEditable() throws ProviderException {
        boolean e = this.provider.isEditable();
        Assert.assertTrue((!e ? 1 : 0) != 0);
    }

    public void testGetEditType() throws UnknownEditTypeException {
        int et = this.provider.getEditType();
        boolean valid = et == 3 || et == 4;
        Assert.assertTrue((boolean)valid);
    }

    public void testGetWidth() throws ProviderException {
        int w = this.provider.getWidth();
        boolean valid = w == 0 || w == 1 || w == 2 || w == 3;
        Assert.assertTrue((boolean)valid);
    }
}

